/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthInterceptorEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthHorizontalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthVerticalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLConditionFilterAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLOrderbyAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLSystemParamAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.service.dataview.executor.InterceptorExecutor;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSqlAnalysis
implements SqlAnalysis {
    @Override
    public void analysis(ExecuteContextModel executeContext) {
        executeContext.setExecuteSql(executeContext.getDataView().getSourceSql());
        SQLAuthVerticalAnalysis.buildSQLAuthVertical(executeContext);
        SQLSystemParamAnalysis.buildSystemParamAnalysis(executeContext);
        SQLConditionFilterAnalysis.buildSQLConditions(executeContext);
        SQLAuthHorizontalAnalysis.buildSQLAuthHorizoncal(executeContext);
        this.interceptor(executeContext);
        SQLOrderbyAnalysis.buildOrderBy(executeContext);
        this.pageAnalysis(executeContext);
    }

    abstract void pageAnalysis(ExecuteContextModel var1);

    protected void interceptor(ExecuteContextModel executeContext) {
        DataAuthEntity dataAuth = executeContext.getDataAuth();
        if (dataAuth == null) {
            return;
        }
        Set<DataAuthInterceptorEntity> interceptors = dataAuth.getInterceptors();
        if (CollectionUtils.isEmpty(interceptors)) {
            return;
        }
        new InterceptorExecutor(executeContext, interceptors).execute();
    }
}

