/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component
public class MysqlAnalysis
extends AbstractSqlAnalysis {
    @Override
    protected void pageAnalysis(ExecuteContextModel executeContext) {
        PageableModel pageable = executeContext.getExecuteParam().getPageable();
        if (pageable == null) {
            return;
        }
        Validate.isTrue((pageable.getPage() >= 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((pageable.getSize() > 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1", (Object[])new Object[0]);
        String executeSql = executeContext.getExecuteSql();
        String countSQL = String.format("select count(*) from (%s) a", executeSql);
        int pageStart = pageable.getPage() * pageable.getSize();
        executeContext.addExecuteCountSqlParameters(executeContext.getExecuteSqlParameters());
        executeContext.addExecuteSqlParameter(pageStart);
        executeContext.addExecuteSqlParameter(pageable.getSize());
        executeContext.appendExecuteSql(" limit ?,?");
        executeContext.setExecuteCountSql(countSQL);
    }

    @Override
    public String concatSql(String ... strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        return "concat(" + StringUtils.join((Object[])strs, (String)",") + ")";
    }
}

