/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SqlOperatorEnum;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SqlParamAnalysis;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

class SQLConditionFilterAnalysis {
    SQLConditionFilterAnalysis() {
    }

    static void buildSQLConditions(ExecuteContextModel executeContext) {
        SQLConditionFilterAnalysis.handleInputParams(executeContext);
        SQLConditionFilterAnalysis.handleKeyParams(executeContext);
    }

    private static void handleInputParams(ExecuteContextModel executeContext) {
        Set<DataViewFilterEntity> filters = executeContext.getDataViewFilters();
        if (CollectionUtils.isEmpty(filters)) {
            return;
        }
        ExecuteParamModel executeParam = executeContext.getExecuteParam();
        for (DataViewFilterEntity filter : filters) {
            DataViewFieldEntity field = filter.getField();
            Validate.notNull((Object)((Object)field), (String)"\u672a\u627e\u5230\u53c2\u6570\u7684\u5bf9\u5e94\u5b57\u6bb5\uff1a%s", (Object[])new Object[]{filter.getDisplayName()});
            String fieldName = field.getFieldName();
            Object value = executeParam.getInputParam(filter.getParamName());
            if (!filter.getNullable().booleanValue()) {
                Validate.notNull((Object)value, (String)"\u672a\u53d1\u73b0\u5fc5\u4f20\u7684\u7b5b\u9009\u53c2\u6570\uff1a%s", (Object[])new Object[]{field.getFieldName()});
            }
            if (value == null) continue;
            SqlParamAnalysis.handleParamCondition(executeContext, fieldName, field.getFieldType(), filter.getOpType(), value);
        }
    }

    private static void handleKeyParams(ExecuteContextModel executeContext) {
        ExecuteParamModel executeParam = executeContext.getExecuteParam();
        Map<String, Object> keyParams = executeParam.getKeyParams();
        if (CollectionUtils.isEmpty(keyParams)) {
            return;
        }
        Set<DataViewFieldEntity> fields = executeContext.getDataViewFields();
        Map<String, DataViewFieldEntity> fieldMap = fields.stream().collect(Collectors.toMap(DataViewFieldEntity::getFieldName, f -> f));
        for (Map.Entry<String, Object> entry : keyParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Validate.notNull((Object)value, (String)"\u4e3b\u952e\u67e5\u8be2\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)key, (String)"\u4e3b\u952e\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            DataViewFieldEntity field = fieldMap.get(key);
            Validate.notNull((Object)((Object)field), (String)"\u672a\u627e\u5230\u5b57\u6bb5\uff1a%s", (Object[])new Object[]{key});
            SqlParamAnalysis.handleParamCondition(executeContext, field.getFieldName(), field.getFieldType(), SqlOperatorEnum.IN.name(), value);
        }
    }
}

