/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dauth;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthPrefabricateRepositoryCustom;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="DataAuthPrefabricateRepositoryCustomImpl")
public class DataAuthPrefabricateRepositoryCustomImpl
implements DataAuthPrefabricateRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Value(value="${spring.application.name:}")
    private String appName;

    @Override
    public Page<DataAuthPrefabricateEntity> findByConditions(Pageable pageable, String name, String code, Integer type, Integer tstatus) {
        StringBuilder hql = new StringBuilder("select d from DataAuthPrefabricateEntity d left join fetch d.authType d_authType where 1 = 1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from DataAuthPrefabricateEntity d where 1 = 1 ");
        StringBuilder condition = new StringBuilder();
        condition.append(" and d.projectName = :projectName and d.isDelete = false ");
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put("projectName", this.appName);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            condition.append(" and d.name like concat('%',:name,'%') ");
            parameterMap.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            condition.append(" and d.code = :code ");
            parameterMap.put("code", code);
        }
        if (type != null) {
            condition.append(" and d.type = :type ");
            parameterMap.put("type", type);
        }
        if (tstatus != null) {
            condition.append(" and d.tstatus = :tstatus ");
            parameterMap.put("tstatus", tstatus);
        }
        return this.queryByConditions(this.entityManager, hql.append((CharSequence)condition).toString(), countHql.append((CharSequence)condition).toString(), parameterMap, pageable, false, DataAuthPrefabricateEntity.class);
    }

    @Override
    public List<DataAuthPrefabricateEntity> findByNameLikeOnlyExpand(String name) {
        StringBuilder hql = new StringBuilder("select d from DataAuthPrefabricateEntity d left join fetch d.authType d_authType where 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            hql.append(" and d.name like concat('%',:name,'%') ");
        }
        hql.append(" and d.projectName = :projectName and d.isDelete = false and d_authType.expand = 1 ");
        hql.append(" order by d_authType.expand , d_authType.sortIndex , d.sortIndex");
        Query query = this.entityManager.createQuery(hql.toString());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            query.setParameter("name", (Object)name);
        }
        query.setParameter("projectName", (Object)this.appName);
        return query.getResultList();
    }
}

