/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.executor;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.ClassTypeEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthInterceptorEntity;
import com.bizunited.platform.core.interceptor.DataViewAuthInterceptor;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class InterceptorExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptorExecutor.class);
    protected static final String ERROR_INTERCEPTOR_IMPLEMENTS = "\u6743\u9650\u62e6\u622a\u5668\u7c7b\u5fc5\u987b\u5b9e\u73b0\u63a5\u53e3\uff1acom.bizunited.platform.core.interceptor.DataViewAuthInterceptor";
    private Object context;
    private Set<DataAuthInterceptorEntity> authInterceptors;

    public InterceptorExecutor(Object context, Set<DataAuthInterceptorEntity> authInterceptors) {
        this.context = context;
        this.authInterceptors = authInterceptors;
    }

    public void execute() {
        if (CollectionUtils.isEmpty(this.authInterceptors)) {
            return;
        }
        for (DataAuthInterceptorEntity authInterceptor : this.authInterceptors) {
            DataViewAuthInterceptor interceptor = this.getInterceptor(authInterceptor);
            if (interceptor == null) continue;
            interceptor.intercept(this.context);
        }
    }

    protected DataViewAuthInterceptor getInterceptor(DataAuthInterceptorEntity interceptor) {
        if (interceptor == null) {
            return null;
        }
        String interceptorClass = interceptor.getInterceptor();
        if (StringUtils.isBlank((CharSequence)interceptorClass)) {
            return null;
        }
        Integer classType = interceptor.getClassType();
        if (ClassTypeEnum.CLASS_PATH.getType().equals(classType)) {
            try {
                Class<?> clazz = Class.forName(interceptorClass);
                Validate.isTrue((boolean)DataViewAuthInterceptor.class.isAssignableFrom(clazz), (String)ERROR_INTERCEPTOR_IMPLEMENTS, (Object[])new Object[0]);
                return (DataViewAuthInterceptor)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u672a\u627e\u5230java\u7c7b\uff1a%s", interceptorClass));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u5b9e\u4f8b\u5316\u7c7b\u9519\u8bef\uff1a%s", interceptorClass));
            }
        }
        if (ClassTypeEnum.BEAN_NAME.getType().equals(classType)) {
            ApplicationContext applicationContext = ApplicationContextUtils.getApplicationContext();
            Validate.isTrue((boolean)applicationContext.containsBean(interceptorClass), (String)"ioc\u5bb9\u5668\u4e2d\u672a\u53d1\u73b0bean\uff1a%s", (Object[])new Object[]{interceptorClass});
            Object bean = applicationContext.getBean(interceptorClass);
            Validate.isTrue((boolean)DataViewAuthInterceptor.class.isAssignableFrom(bean.getClass()), (String)ERROR_INTERCEPTOR_IMPLEMENTS, (Object[])new Object[0]);
            return (DataViewAuthInterceptor)bean;
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u62e6\u622a\u5668\u7c7b\u578b:%s", classType));
    }
}

