/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.executor;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.enums.DataAuthPrefabricateTypeEnum;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dataview.executor.DataViewExecutor;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateCustomService;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DataAuthPrefabricateExecutor {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private DataViewFieldService dataViewFieldService;
    @Autowired
    private DataViewExecutor dataViewExecutor;

    public Object executor(DataAuthPrefabricateEntity dataAuthPrefabricateEntity) {
        Validate.notNull((Object)((Object)dataAuthPrefabricateEntity), (String)"\u6570\u636e\u6743\u9650\u9884\u5236\u503c\u5b9e\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthPrefabricateTypeEnum type = DataAuthPrefabricateTypeEnum.valueOfType(dataAuthPrefabricateEntity.getType());
        switch (type) {
            case IMPLEMENTATION: {
                return this.execImplementation(dataAuthPrefabricateEntity);
            }
            case DATAVIEW: {
                return this.execDataView(dataAuthPrefabricateEntity);
            }
            case GROOVY: {
                return this.execGroovy(dataAuthPrefabricateEntity);
            }
            case SERVICABL: {
                return this.execServicabl(dataAuthPrefabricateEntity);
            }
        }
        throw new IllegalArgumentException(String.format("\u9884\u5236\u503c\u7c7b\u578b\u9519\u8bef,\u3010%s\u3011\u8bf7\u68c0\u67e5\uff01", dataAuthPrefabricateEntity.getType()));
    }

    private Object execImplementation(DataAuthPrefabricateEntity dataAuthPrefabricateEntity) {
        Validate.notBlank((CharSequence)dataAuthPrefabricateEntity.getCustomClass(), (String)"\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String clz = StringUtils.substringBeforeLast((String)dataAuthPrefabricateEntity.getCustomClass(), (String)".");
        String method = StringUtils.substringAfterLast((String)dataAuthPrefabricateEntity.getCustomClass(), (String)".");
        Object value = null;
        try {
            DataAuthPrefabricateCustomService service = (DataAuthPrefabricateCustomService)this.applicationContext.getBean(StringUtils.uncapitalize((String)StringUtils.substringAfterLast((String)clz, (String)".")), DataAuthPrefabricateCustomService.class);
            value = service.getPresetValue(dataAuthPrefabricateEntity.getCode());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5b9e\u73b0\u7c7b\u6267\u884c\u9519\u8bef", e);
        }
        return value;
    }

    private Object execDataView(DataAuthPrefabricateEntity dataAuthPrefabricateEntity) {
        Validate.notBlank((CharSequence)dataAuthPrefabricateEntity.getDataViewFieldCode(), (String)"\u6570\u636e\u89c6\u56fe\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewFieldEntity dataViewFieldEntity = this.dataViewFieldService.findByCode(dataAuthPrefabricateEntity.getDataViewFieldCode());
        ExecuteParamModel executeParamModel = new ExecuteParamModel();
        executeParamModel.setDataViewCode(dataViewFieldEntity.getDataView().getCode());
        ExecuteContextModel executeContext = this.dataViewExecutor.buildContext(executeParamModel);
        List<JSONObject> jsonObjectList = this.dataViewExecutor.executeQuery(executeContext);
        return jsonObjectList.stream().map(json -> json.get((Object)dataViewFieldEntity.getFieldName())).collect(Collectors.toSet());
    }

    private Object execGroovy(DataAuthPrefabricateEntity dataAuthPrefabricateEntity) {
        Validate.notBlank((CharSequence)dataAuthPrefabricateEntity.getScriptName(), (String)"groovy\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String scriptContent = this.scriptService.findContentByName(dataAuthPrefabricateEntity.getScriptName());
        HashMap params = Maps.newHashMap();
        params.put("ctx", this.applicationContext);
        Object value = null;
        try {
            value = this.scriptService.invoke(scriptContent, (Map<String, Object>)params);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("groovy\u6267\u884c\u9519\u8bef", e);
        }
        return value;
    }

    private Object execServicabl(DataAuthPrefabricateEntity dataAuthPrefabricateEntity) {
        Validate.notBlank((CharSequence)dataAuthPrefabricateEntity.getScriptName(), (String)"\u670d\u52a1\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvokeParams invokeParams = new InvokeParams();
        invokeParams.putInvokeParam("ctx", (Object)this.applicationContext);
        Object value = null;
        try {
            value = this.servicableMethodService.invoke(dataAuthPrefabricateEntity.getServiceName(), invokeParams);
        }
        catch (InvokeProxyException e) {
            throw new IllegalArgumentException("\u670d\u52a1\u6e90\u6267\u884c\u9519\u8bef", e);
        }
        return value;
    }
}

