/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.common.enums.DataAuthPrefabricateTypeEnum;
import com.bizunited.platform.core.common.enums.InnerPresetValuesEnum;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthTypeEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dauth.DataAuthPrefabricateRepository;
import com.bizunited.platform.core.repository.dauth.DataAuthPrefabricateRepositoryCustom;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateEntityService;
import com.bizunited.platform.core.service.dauth.DataAuthTypeEntityService;
import com.bizunited.platform.core.service.dauth.executor.DataAuthPrefabricateExecutor;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataAuthPrefabricateEntityServiceImpl
implements DataAuthPrefabricateEntityService {
    @Autowired
    private DataAuthPrefabricateRepository dataAuthPrefabricateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DataAuthTypeEntityService dataAuthTypeEntityService;
    @Autowired
    private DataViewFieldService dataViewFieldService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DataAuthPrefabricateRepositoryCustom dataAuthPrefabricateRepositoryCustom;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private DataAuthPrefabricateExecutor dataAuthPrefabricateExecutor;
    @Autowired
    private RedissonClient redissonClient;
    @Value(value="${spring.application.name:}")
    private String appName;

    @Override
    @Transactional
    public Set<DataAuthPrefabricateEntity> save(Set<DataAuthPrefabricateEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Sets.newHashSet();
        }
        this.validate(entities);
        this.fillDatas(entities);
        Set<String> keySet = entities.stream().map(DataAuthPrefabricateEntity::getCode).collect(Collectors.toSet());
        List<DataAuthPrefabricateEntity> dbDatas = this.dataAuthPrefabricateRepository.findByCodes(keySet);
        HashSet updateDatas = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(entities, dbDatas, UuidEntity::getId, (Collection)Sets.newHashSet(), (Collection)updateDatas, (Collection)Sets.newHashSet());
        Map<String, DataAuthPrefabricateEntity> frontDatas = entities.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v));
        for (DataAuthPrefabricateEntity e2 : updateDatas) {
            this.validateRepeatability(e2, 1);
            DataAuthPrefabricateEntity frontData = frontDatas.get(e2.getId());
            e2.setCode(frontData.getCode());
            e2.setCustomClass(frontData.getCustomClass());
            e2.setAuthType(frontData.getAuthType());
            e2.setName(frontData.getName());
            e2.setSortIndex(frontData.getSortIndex());
            e2.setTstatus(frontData.getTstatus());
            this.dataAuthPrefabricateRepository.saveAndFlush((Object)e2);
        }
        HashSet results = Sets.newHashSet();
        Set needCreate = entities.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        for (DataAuthPrefabricateEntity e3 : needCreate) {
            this.validateRepeatability(e3, 0);
            this.dataAuthPrefabricateRepository.saveAndFlush((Object)e3);
        }
        results.addAll(needCreate);
        results.addAll(updateDatas);
        return results;
    }

    @Override
    public String findDataType(Integer type, String value) {
        Validate.notNull((Object)type, (String)"\u9884\u5236\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)value, (String)"\u9884\u5236\u503c\u68c0\u67e5\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthPrefabricateTypeEnum prefabricateType = DataAuthPrefabricateTypeEnum.valueOfType(type);
        switch (prefabricateType) {
            case IMPLEMENTATION: {
                return this.getImplementationReturnType(value);
            }
            case DATAVIEW: {
                return this.getDataViewReturnType(value);
            }
            case GROOVY: {
                return this.getGroovyReturnType(value);
            }
            case SERVICABL: {
                return this.getServiceReturnType(value);
            }
        }
        throw new IllegalArgumentException("\u9884\u5236\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
    }

    private String getImplementationReturnType(String value) {
        String clz = null;
        String method = null;
        try {
            clz = StringUtils.substringBeforeLast((String)value, (String)".");
            method = StringUtils.substringAfterLast((String)value, (String)".");
            Class<?> clazz = Class.forName(clz);
            Method m = clazz.getDeclaredMethod(method, new Class[0]);
            Type returnType = m.getAnnotatedReturnType().getType();
            return returnType.getTypeName();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("\u9884\u5236\u503c\u4fe1\u606f%s\u7c7b\u4e0d\u5b58\u5728 \u6216 \u4e0d\u662f\u7c7b\u65b9\u6cd5\u5168\u8def\u5f84\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", clz));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("\u9884\u5236\u503c\u4fe1\u606f%s\u7c7b %s\u65b9\u6cd5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", clz, method));
        }
    }

    private String getDataViewReturnType(String value) {
        DataViewFieldEntity dataViewFieldEntity = this.dataViewFieldService.findByCode(value);
        Validate.notNull((Object)((Object)dataViewFieldEntity), (String)"\u6570\u636e\u5b57\u6bb5\u9879\u4e3a\u7a7a", (Object[])new Object[0]);
        return dataViewFieldEntity.getFieldType();
    }

    private String getGroovyReturnType(String value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userVo", SecurityUtils.getCurrentUser());
        params.put("ctx", this.applicationContext);
        try {
            Object object = this.scriptService.invoke(value, params);
            Validate.notNull((Object)object, (String)"\u811a\u672c\u6267\u884c\u65e0\u8fd4\u56de\u7ed3\u679c,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            return object.getClass().getTypeName();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u811a\u672c\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u5185\u5bb9");
        }
    }

    private String getServiceReturnType(String value) {
        ServicableMethodInfo servicableMethodInfo = this.servicableMethodService.findDetailsByName(value);
        Validate.notNull((Object)servicableMethodInfo, (String)"\u670d\u52a1\u6e90\u6570\u636e\u9519\u8bef,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        return servicableMethodInfo.getReturnClass().getTypeName();
    }

    @Override
    @Transactional
    public DataAuthPrefabricateEntity create(DataAuthPrefabricateEntity entity, String scriptContent) {
        this.validate(entity);
        this.fillDatas(entity);
        this.validateRepeatability(entity, 0);
        DataAuthTypeEntity dataAuthTypeEntity = this.dataAuthTypeEntityService.findByCode(entity.getAuthType().getCode());
        Validate.notNull((Object)((Object)dataAuthTypeEntity), (String)"\u5173\u8054\u6570\u636e\u6743\u9650\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setAuthType(dataAuthTypeEntity);
        DataAuthPrefabricateTypeEnum type = DataAuthPrefabricateTypeEnum.valueOfType(entity.getType());
        if (type == DataAuthPrefabricateTypeEnum.GROOVY) {
            Validate.notBlank((CharSequence)scriptContent, (String)"groovy\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ScriptEntity scriptEntity = new ScriptEntity();
            scriptEntity.setLanguage("groovy");
            String scriptName = "dataAuthPrefabricate_" + entity.getCode();
            scriptEntity.setName(scriptName);
            this.scriptService.create(scriptEntity, scriptContent);
            entity.setScriptName(scriptName);
        }
        return (DataAuthPrefabricateEntity)((Object)this.dataAuthPrefabricateRepository.saveAndFlush((Object)entity));
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"dataAuthPrefabricate"}, allEntries=true)
    public DataAuthPrefabricateEntity update(DataAuthPrefabricateEntity entity, String scriptContent) {
        Validate.notNull((Object)((Object)entity), (String)"\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u66f4\u65b0\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(entity);
        String account = SecurityUtils.getUserAccount();
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", (Object[])new Object[0]);
        DataAuthPrefabricateEntity exsit = this.dataAuthPrefabricateRepository.findById(entity.getId()).orElse(null);
        Validate.notNull((Object)((Object)exsit), (String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)exsit.getCode().equals(entity.getCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)exsit.getType().equals(entity.getType()), (String)"\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.validateRepeatability(entity, 1);
        exsit.setName(entity.getName());
        exsit.setCustomClass(entity.getCustomClass());
        exsit.setDataType(entity.getDataType());
        exsit.setDataViewFieldCode(entity.getDataViewFieldCode());
        exsit.setServiceName(entity.getServiceName());
        exsit.setTstatus(entity.getTstatus());
        exsit.setRemark(entity.getRemark());
        exsit.setModifyAccount(account);
        exsit.setModifyTime(new Date());
        DataAuthPrefabricateTypeEnum type = DataAuthPrefabricateTypeEnum.valueOfType(entity.getType());
        if (type == DataAuthPrefabricateTypeEnum.GROOVY) {
            Validate.notBlank((CharSequence)scriptContent, (String)"groovy\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ScriptEntity scriptEntity = this.scriptService.findByName(exsit.getScriptName());
            Validate.notNull((Object)((Object)scriptEntity), (String)"\u811a\u672c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
            scriptEntity.setLanguage("groovy");
            String scriptName = exsit.getScriptName();
            scriptEntity.setName(scriptName);
            this.scriptService.update(scriptEntity, scriptContent);
        }
        return (DataAuthPrefabricateEntity)((Object)this.dataAuthPrefabricateRepository.saveAndFlush((Object)exsit));
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"dataAuthPrefabricate"}, allEntries=true)
    public DataAuthPrefabricateEntity updateStatusById(String id, Integer tstatus) {
        Validate.isTrue((tstatus == 1 || tstatus == 0 ? 1 : 0) != 0, (String)"\u72b6\u6001\u53ea\u80fd\u8bbe\u5b9a\u4e3a1\uff08\u6b63\u5e38\uff09\u6216\u80050\uff08\u7981\u7528\uff09", (Object[])new Object[0]);
        DataAuthPrefabricateEntity current = this.dataAuthPrefabricateRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u72b6\u6001\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        String account = SecurityUtils.getUserAccount();
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", (Object[])new Object[0]);
        current.setTstatus(tstatus);
        current.setModifyAccount(account);
        current.setModifyTime(new Date());
        return (DataAuthPrefabricateEntity)((Object)this.dataAuthPrefabricateRepository.saveAndFlush((Object)current));
    }

    @Override
    @CacheEvict(cacheNames={"dataAuthPrefabricate"}, allEntries=true)
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5220\u9664\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthPrefabricateEntity current = this.dataAuthPrefabricateRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String account = SecurityUtils.getUserAccount();
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", (Object[])new Object[0]);
        current.setDelete(true);
        current.setModifyAccount(account);
        current.setModifyTime(new Date());
        this.dataAuthPrefabricateRepository.saveAndFlush((Object)current);
    }

    @Override
    public List<DataAuthPrefabricateEntity> findAllOnlyNotDelete() {
        return this.dataAuthPrefabricateRepository.findAllByProjectNameOnlyNotDelete(this.appName);
    }

    @Override
    @Cacheable(cacheNames={"dataAuthPrefabricate"}, key="'findByCode_' + #code", unless="#result == null")
    public DataAuthPrefabricateEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataAuthPrefabricateRepository.findByCode(code);
    }

    @Override
    public Page<DataAuthPrefabricateEntity> findByConditions(Pageable pageable, String name, String code, Integer type, Integer tstatus) {
        return this.dataAuthPrefabricateRepositoryCustom.findByConditions(pageable, name, code, type, tstatus);
    }

    @Override
    public List<DataAuthPrefabricateEntity> findByNameLikeOnlyExpand(String name) {
        return this.dataAuthPrefabricateRepositoryCustom.findByNameLikeOnlyExpand(name);
    }

    @Override
    public List<DataAuthPrefabricateEntity> findByAuthTypeCodeOnlyEnable(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        return this.dataAuthPrefabricateRepository.findByAuthTypeCodeOnlyEnable(code);
    }

    @Override
    public JSONArray findAll() {
        JSONArray result = new JSONArray();
        result.addAll((Collection)InnerPresetValuesEnum.toJson());
        List<DataAuthPrefabricateEntity> expandEntities = this.dataAuthPrefabricateRepository.findByTstatus();
        for (DataAuthPrefabricateEntity e : expandEntities) {
            JSONObject json = new JSONObject();
            json.put("type", (Object)e.getAuthType().getExpandValue());
            json.put("paramKey", (Object)e.getCode());
            json.put("descr", (Object)e.getName());
            result.add((Object)json);
        }
        return result;
    }

    @Override
    public JSONArray findByAuthTypeInnerValue(Integer innerValue) {
        return InnerPresetValuesEnum.toJson(InnerPresetValuesEnum.valuesOfType(innerValue));
    }

    @Override
    public JSONObject findByParamKey(String paramKey) {
        InnerPresetValuesEnum innerPresetValuesEnum = InnerPresetValuesEnum.valueOfParamKey(paramKey);
        if (innerPresetValuesEnum != null) {
            return InnerPresetValuesEnum.toJson(InnerPresetValuesEnum.valueOfParamKey(paramKey));
        }
        DataAuthPrefabricateEntity entity = this.dataAuthPrefabricateRepository.findByCode(paramKey);
        Validate.notNull((Object)((Object)entity), (String)String.format("\u81ea\u5b9a\u4e49\u9884\u5236\u503c\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5\u3010%s\u3011\u81ea\u5b9a\u4e49\u6269\u5c55", paramKey), (Object[])new Object[0]);
        JSONObject json = new JSONObject();
        json.put("type", (Object)entity.getAuthType().getExpandValue());
        json.put("paramKey", (Object)entity.getCode());
        json.put("descr", (Object)entity.getName());
        return json;
    }

    @Override
    public Set<String> getCurrentPresetValueInnerType(UserVo user, DataAuthTypeEntity dataAuthType) {
        Validate.notNull((Object)((Object)dataAuthType), (String)"\u4f20\u5165\u7684\u5173\u8054\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)user, (String)"\u4f20\u5165\u7684\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getAccount(), (String)"\u4f20\u5165\u7684\u7528\u6237\u8d26\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer authType = dataAuthType.getInnerValue();
        String cacheKey = StringUtils.join((Object[])new Serializable[]{user.getAccount(), ":", authType});
        Object value = this.getCacheValue(cacheKey, "VERTICAL_PRESET_VALUE");
        if (value != null) {
            return (Set)value;
        }
        Set<String> presetValues = new HashSet<String>();
        switch (authType) {
            case 1: {
                presetValues.add(user.getAccount());
                break;
            }
            case 2: {
                List roles = this.roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
                if (CollectionUtils.isEmpty((Collection)roles)) break;
                presetValues = roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet());
                break;
            }
            case 3: {
                PositionVo position = this.positionService.findMainPositionByUserId(user.getId());
                if (position == null) break;
                presetValues.add(position.getCode());
                break;
            }
            case 4: {
                Set groups = this.userGroupService.findByUserId(user.getId());
                if (CollectionUtils.isEmpty((Collection)groups)) break;
                presetValues = groups.stream().map(UserGroupVo::getGroupCode).collect(Collectors.toSet());
                break;
            }
            case 5: {
                Set orgs = this.organizationService.findOrgByUserId(user.getId());
                if (CollectionUtils.isEmpty((Collection)orgs)) break;
                presetValues = orgs.stream().map(OrganizationVo::getCode).collect(Collectors.toSet());
                break;
            }
        }
        this.setCacheValue(cacheKey, presetValues, "VERTICAL_PRESET_VALUE");
        return presetValues;
    }

    @Override
    public Object getCurrentPresetValue(String paramKey, Integer level) {
        if (StringUtils.isBlank((CharSequence)paramKey)) {
            return null;
        }
        UserVo user = SecurityUtils.getCurrentUser();
        Object value = this.getCacheValue(StringUtils.join((Object[])new String[]{user.getAccount(), ":", paramKey}), "HORIZONTAL_PRESET_VALUE");
        if (value != null) {
            return value;
        }
        InnerPresetValuesEnum presetValuesEnum = InnerPresetValuesEnum.valueOfParamKey(paramKey);
        if (presetValuesEnum != null) {
            Validate.notNull((Object)((Object)presetValuesEnum), (String)"\u6839\u636e\u9884\u5236\u503c\u6807\u8bc6paramKey\uff0c\u672a\u80fd\u83b7\u53d6\u9884\u5236\u503c\u4fe1\u606f\uff01", (Object[])new Object[0]);
            switch (presetValuesEnum) {
                case OPT_USER_ID: {
                    value = user.getId();
                    break;
                }
                case OPT_USER_NAME: {
                    value = user.getUserName();
                    break;
                }
                case OPT_USER_ACCOUNT: {
                    value = user.getAccount();
                    break;
                }
                case OPT_USER_CODE: {
                    value = user.getId();
                    break;
                }
                case OPT_USER_PHONE: {
                    value = user.getPhone();
                    break;
                }
                case OPT_USER_STATUS: {
                    value = user.getUseStatus();
                    break;
                }
                case OPT_USER_IDCARD: {
                    value = user.getIdcard();
                    break;
                }
                case OPT_USER_POSITION_ID: 
                case OPT_USER_POSITION: 
                case OPT_USER_POSITION_CODE: 
                case OPT_USER_POSITION_STATUS: {
                    value = this.getPositionPreset(user, presetValuesEnum);
                    break;
                }
                case OPT_USER_ORG_STATUS: 
                case OPT_USER_ORG_DESC: 
                case OPT_USER_ORG_TYPE: 
                case OPT_USER_ORG_ID: 
                case OPT_USER_ORG: 
                case OPT_CUR_ORGS: 
                case OPT_PARENT_ORGS: 
                case OPT_PARENT_ALL_ORGS: 
                case OPT_CHILDREN_ORGS: 
                case OPT_CHILDREN_ALL_ORGS: 
                case OPT_CURRENT_ORG_AND_ALL_CHILDREN: 
                case OPT_PARENT_LEVEL_ORGS: 
                case OPT_CHILDREN_LEVEL_ORGS: {
                    value = this.getOrgPreset(user, presetValuesEnum, level);
                    break;
                }
                case OPT_USER_GROUP: {
                    value = this.getUserGroupPreset(user, presetValuesEnum);
                    break;
                }
                case OPT_USER_ROLE: {
                    value = this.getUserRolePreset(user, presetValuesEnum);
                    break;
                }
                default: {
                    value = this.getOtherPreset(user, presetValuesEnum);
                    break;
                }
            }
        } else {
            DataAuthPrefabricateEntity entity = this.findByCode(paramKey);
            value = this.dataAuthPrefabricateExecutor.executor(entity);
        }
        if (value != null) {
            this.setCacheValue(StringUtils.join((Object[])new String[]{user.getAccount(), ":", paramKey}), value, "HORIZONTAL_PRESET_VALUE");
        }
        return value;
    }

    private void validate(Set<DataAuthPrefabricateEntity> entities) {
        Validate.notEmpty(entities, (String)"\u4f20\u5165\u7684\u9884\u5236\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataAuthPrefabricateEntity entity : entities) {
            this.validate(entity);
        }
    }

    private void validate(DataAuthPrefabricateEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u4f20\u5165\u7684\u9884\u5236\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getName(), (String)"\u540d\u79f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)entity.getAuthType()), (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAuthType().getCode(), (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((entity.getAuthType().getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u5904\u4e8e\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getAuthType().getExpand() == 1 ? 1 : 0) != 0, (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u662f\u5185\u7f6e\u79cd\u7c7b\u72b6\u6001\uff0c\u4e0d\u80fd\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getType(), (String)"\u9884\u5236\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthPrefabricateTypeEnum type = DataAuthPrefabricateTypeEnum.valueOfType(entity.getType());
        switch (type) {
            case IMPLEMENTATION: {
                this.validateImplementation(entity);
                break;
            }
            case DATAVIEW: {
                Validate.notBlank((CharSequence)entity.getDataViewFieldCode(), (String)"\u9009\u62e9\u6570\u636e\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
            case GROOVY: {
                break;
            }
            case SERVICABL: {
                Validate.notBlank((CharSequence)entity.getServiceName(), (String)"\u670d\u52a1\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u9884\u5236\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private void validateImplementation(DataAuthPrefabricateEntity entity) {
        Validate.notBlank((CharSequence)entity.getCustomClass(), (String)"\u9884\u5236\u503c\u81ea\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String clz = null;
        String method = null;
        try {
            clz = StringUtils.substringBeforeLast((String)entity.getCustomClass(), (String)".");
            method = StringUtils.substringAfterLast((String)entity.getCustomClass(), (String)".");
            Class<?> clazz = Class.forName(clz);
            HashSet methods = Sets.newHashSet();
            methods.addAll(Arrays.asList(clazz.getMethods()));
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            String finalMethod = method;
            boolean flag = methods.stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getName(), (CharSequence)finalMethod));
            Validate.isTrue((boolean)flag);
        }
        catch (ClassNotFoundException | SecurityException e2) {
            throw new IllegalArgumentException(String.format("\u9884\u5236\u503c\u4fe1\u606f%s\u7c7b\u4e0d\u5b58\u5728 \u6216 \u4e0d\u662f\u7c7b\u65b9\u6cd5\u5168\u8def\u5f84\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", clz));
        }
        catch (IllegalArgumentException e3) {
            throw new IllegalArgumentException(String.format("\u9884\u5236\u503c\u4fe1\u606f%s\u7c7b %s\u65b9\u6cd5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", clz, method));
        }
        catch (Exception e4) {
            throw new IllegalArgumentException(String.format("\u672a\u77e5\u9519\u8bef\uff0c\u9884\u5236\u503c\u4fe1\u606f%s\u7c7b %s\u65b9\u6cd5\u9a8c\u8bc1\uff0c\u8bf7\u68c0\u67e5\uff01", clz, method));
        }
    }

    private void fillDatas(Set<DataAuthPrefabricateEntity> entities) {
        for (DataAuthPrefabricateEntity entity : entities) {
            this.fillDatas(entity);
        }
    }

    private void fillDatas(DataAuthPrefabricateEntity entity) {
        String account = SecurityUtils.getUserAccount();
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)entity.getCreateAccount())) {
            entity.setCreateAccount(account);
            entity.setCreateTime(now);
        }
        entity.setProjectName(this.appName);
        entity.setModifyAccount(account);
        entity.setModifyTime(now);
        entity.setDelete(false);
        if (entity.getSortIndex() == null) {
            entity.setSortIndex(0);
        }
        if (StringUtils.isBlank((CharSequence)entity.getCode())) {
            entity.setCode(UUID.randomUUID().toString());
        }
    }

    private void validateRepeatability(DataAuthPrefabricateEntity entity, Integer createOrUpdate) {
        DataAuthPrefabricateEntity dbDataAuthPrefabricateEntity = this.dataAuthPrefabricateRepository.findByNameAndProjectName(entity.getName(), entity.getProjectName());
        Validate.isTrue((dbDataAuthPrefabricateEntity == null || StringUtils.equals((CharSequence)dbDataAuthPrefabricateEntity.getId(), (CharSequence)entity.getId()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u9884\u5236\u503c\u540d\u79f0\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{entity.getName()});
        int countByCode = this.dataAuthPrefabricateRepository.countByCode(entity.getCode());
        Validate.isTrue((countByCode <= createOrUpdate ? 1 : 0) != 0, (String)"\u5f53\u524d\u9884\u5236\u503c\u7f16\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{entity.getCode()});
    }

    private Object getOtherPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        Object value;
        switch (presetValuesEnum) {
            case CURRENT_USER_LOGIN_TIME: {
                value = user.getLastloginTime();
                break;
            }
            case NOW_DATE_MONTH: {
                value = new SimpleDateFormat("yyyy-MM").format(new Date());
                break;
            }
            case NOW_DATE_DAY: {
                value = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                break;
            }
            case NOW_DATE_MINUTE: {
                value = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
                break;
            }
            case NOW_DATE_SECOND: {
                value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u9884\u5236\u503c\u7c7b\u522b\uff1a%s", presetValuesEnum.getParamKey()));
            }
        }
        return value;
    }

    private Object getUserRolePreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        List roles = this.roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return Lists.newArrayList((Object[])new String[]{"-0101010101"});
        }
        return roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toList());
    }

    private Object getUserGroupPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        Set groups = this.userGroupService.findByUserId(user.getId());
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return Lists.newArrayList((Object[])new String[]{"-0101010101"});
        }
        return groups.stream().map(UserGroupVo::getGroupCode).collect(Collectors.toList());
    }

    private Object getPositionPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        PositionVo position = this.positionService.findMainPositionByUserId(user.getId());
        if (position == null) {
            return "-0101010101";
        }
        switch (presetValuesEnum) {
            case OPT_USER_POSITION_ID: {
                return position.getId();
            }
            case OPT_USER_POSITION: 
            case OPT_USER_POSITION_CODE: {
                return position.getCode();
            }
            case OPT_USER_POSITION_STATUS: {
                return position.getTstatus();
            }
        }
        return position.getCode();
    }

    private Object getOrgPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum, Integer level) {
        Set<OrganizationVo> orgs = null;
        Function<OrganizationVo, Object> function = null;
        switch (presetValuesEnum) {
            case OPT_USER_ORG_STATUS: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getTstatus;
                break;
            }
            case OPT_USER_ORG_DESC: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getDescription;
                break;
            }
            case OPT_USER_ORG_TYPE: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getType;
                break;
            }
            case OPT_USER_ORG_ID: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = UuidVo::getId;
                break;
            }
            case OPT_USER_ORG: 
            case OPT_CUR_ORGS: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_PARENT_ORGS: {
                orgs = this.findParentOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_PARENT_ALL_ORGS: {
                orgs = this.findAllParentOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CHILDREN_ORGS: {
                orgs = this.findChildrenOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CHILDREN_ALL_ORGS: {
                orgs = this.findAllChildrenOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CURRENT_ORG_AND_ALL_CHILDREN: {
                orgs = this.findCurrentOrgAndAllChildrenByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_PARENT_LEVEL_ORGS: {
                orgs = this.findLevelParentOrgsByUserId(user.getAccount(), level);
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CHILDREN_LEVEL_ORGS: {
                orgs = this.findLevelChildrenOrgsByUserId(user.getAccount(), level);
                function = OrganizationVo::getCode;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u7ec4\u7ec7\u673a\u6784\u9884\u5236\u503c\uff1a%s", presetValuesEnum.getParamKey()));
            }
        }
        if (CollectionUtils.isEmpty(orgs)) {
            return Lists.newArrayList((Object[])new String[]{"-0101010101"});
        }
        return orgs.stream().map(function).collect(Collectors.toList());
    }

    private Set<OrganizationVo> findLevelChildrenOrgsByUserId(String account, Integer level) {
        Set orgs = this.organizationService.findByTypeAndLevel(Integer.valueOf(2), account, level);
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        for (OrganizationVo org : orgs) {
            this.getChlidrenOrgs(org, result);
        }
        return result;
    }

    private void getChlidrenOrgs(OrganizationVo org, Set<OrganizationVo> result) {
        Set children = org.getChild();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        result.addAll(children);
        for (OrganizationVo item : children) {
            this.getChlidrenOrgs(item, result);
        }
    }

    private Set<OrganizationVo> findLevelParentOrgsByUserId(String account, Integer level) {
        Set orgs = this.organizationService.findByTypeAndLevel(Integer.valueOf(1), account, level);
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        for (OrganizationVo org : orgs) {
            this.getParentOrgs(org, result);
        }
        return result;
    }

    private void getParentOrgs(OrganizationVo org, Set<OrganizationVo> result) {
        OrganizationVo parent = org.getParent();
        if (parent == null) {
            return;
        }
        result.add(parent);
        this.getParentOrgs(parent, result);
    }

    private Set<OrganizationVo> findChildrenOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> children = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            List son = this.organizationService.findByParent(org.getId());
            if (CollectionUtils.isEmpty((Collection)son)) continue;
            children.addAll(son);
        }
        return children;
    }

    private Set<OrganizationVo> findAllChildrenOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> children = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findChildrenOrgs(children, org.getId());
        }
        return children;
    }

    private Set<OrganizationVo> findCurrentOrgAndAllChildrenByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> children = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findChildrenOrgs(children, org.getId());
        }
        children.addAll(orgs);
        return children;
    }

    private void findChildrenOrgs(Set<OrganizationVo> orgs, String parentOrgId) {
        List children = this.organizationService.findByParent(parentOrgId);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        orgs.addAll(children);
        for (OrganizationVo org : children) {
            this.findChildrenOrgs(orgs, org.getId());
        }
    }

    private Set<OrganizationVo> findParentOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> parents = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            OrganizationVo parent = this.organizationService.findByChild(org.getId());
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    private Set<OrganizationVo> findAllParentOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> parents = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findParentOrg(this.organizationService, parents, org.getId());
        }
        return parents;
    }

    private void findParentOrg(OrganizationService organizationService, Set<OrganizationVo> orgs, String childOrgId) {
        OrganizationVo parent = organizationService.findByChild(childOrgId);
        if (parent == null) {
            return;
        }
        orgs.add(parent);
        this.findParentOrg(organizationService, orgs, parent.getId());
    }

    private Object getCacheValue(String key, String prefix) {
        RMapCache currentMap = this.redissonClient.getMapCache(prefix);
        if (currentMap == null) {
            return null;
        }
        return currentMap.get((Object)key);
    }

    private void setCacheValue(String key, Object content, String prefix) {
        RMapCache currentMap = this.redissonClient.getMapCache(prefix);
        Validate.notNull((Object)currentMap, (String)"\u9884\u5236\u503c\uff1a\u672a\u83b7\u53d6\u5230redis\u76f8\u5173\u4fe1\u606f\uff01", (Object[])new Object[0]);
        currentMap.put((Object)key, content, (long)SQLPresetValueAnalysis.MAX_CACHE_MIN.intValue(), TimeUnit.MINUTES);
    }
}

