/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.entity.dauth.DataAuthTypeEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthTypeRepository;
import com.bizunited.platform.core.service.dauth.DataAuthTypeEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataAuthTypeEntityServiceImpl")
public class DataAuthTypeEntityServiceImpl
implements DataAuthTypeEntityService {
    @Autowired
    private DataAuthTypeRepository dataAuthTypeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public Set<DataAuthTypeEntity> save(Set<DataAuthTypeEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            String projectName = this.platformContext.getAppName();
            this.dataAuthTypeRepository.deleteAllByProjectNameLogic(projectName);
            return Sets.newHashSet();
        }
        this.validate(entities);
        this.fillDatas(entities);
        List<DataAuthTypeEntity> dbDatas = this.findAllWithoutInnerAuthType();
        HashSet updateDatas = Sets.newHashSet();
        HashSet deleteDatas = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(entities, dbDatas, UuidEntity::getId, (Collection)deleteDatas, (Collection)updateDatas, (Collection)Sets.newHashSet());
        for (Object e2 : deleteDatas) {
            this.updateStatusByCodeAndSortIndex(((DataAuthTypeEntity)((Object)e2)).getCode(), ((DataAuthTypeEntity)((Object)e2)).getSortIndex());
        }
        Map<String, DataAuthTypeEntity> frontDatas = entities.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v));
        for (DataAuthTypeEntity e3 : updateDatas) {
            this.validateRepeatability(e3, 1);
            DataAuthTypeEntity frontData = frontDatas.get(e3.getId());
            e3.setCode(frontData.getCode());
            e3.setExpand(frontData.getExpand());
            e3.setName(frontData.getName());
            e3.setSortIndex(frontData.getSortIndex());
            e3.setTstatus(frontData.getTstatus());
            this.dataAuthTypeRepository.saveAndFlush((Object)e3);
        }
        HashSet results = Sets.newHashSet();
        Set needCreate = entities.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        for (DataAuthTypeEntity e4 : needCreate) {
            this.validateRepeatability(e4, 0);
            this.dataAuthTypeRepository.saveAndFlush((Object)e4);
        }
        results.addAll(needCreate);
        results.addAll(updateDatas);
        return results;
    }

    private void validate(Set<DataAuthTypeEntity> entities) {
        Validate.notEmpty(entities, (String)"\u4f20\u5165\u7684\u79cd\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataAuthTypeEntity entity : entities) {
            Validate.notBlank((CharSequence)entity.getName(), (String)"\u540d\u79f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)entity.getSortIndex(), (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)entity.getExpand(), (String)"\u662f\u5426\u6269\u5c55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)entity.getTstatus(), (String)"\u72b6\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((entity.getExpand() == 1 ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u4fdd\u5b58\u5185\u7f6e\u7684\u5173\u8054\u79cd\u7c7b", (Object[])new Object[0]);
            Validate.notNull((Object)entity.getExpandValue(), (String)"\u6269\u5c55\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((entity.getExpandValue() >= 1000 ? 1 : 0) != 0, (String)"\u6269\u5c55\u503c\u53d6\u503c\u8303\u56f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1000", (Object[])new Object[0]);
        }
    }

    private void fillDatas(Set<DataAuthTypeEntity> entities) {
        String account = SecurityUtils.getUserAccount();
        Date now = new Date();
        for (DataAuthTypeEntity entity : entities) {
            if (StringUtils.isBlank((CharSequence)entity.getCreateAccount())) {
                entity.setCreateAccount(account);
                entity.setCreateTime(now);
            }
            entity.setModifyAccount(account);
            entity.setModifyTime(now);
            entity.setProjectName(this.platformContext.getAppName());
            if (!StringUtils.isBlank((CharSequence)entity.getCode())) continue;
            entity.setCode(UUID.randomUUID().toString());
        }
    }

    private void validateRepeatability(DataAuthTypeEntity entity, Integer createOrUpdate) {
        if (entity.getExpand() == 0) {
            return;
        }
        int countByName = this.dataAuthTypeRepository.countByNameAndProjectName(entity.getName(), entity.getProjectName());
        Validate.isTrue((countByName <= createOrUpdate ? 1 : 0) != 0, (String)"\u5f53\u524d\u5173\u8054\u79cd\u7c7b\u540d\u79f0\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{entity.getName()});
        int countByCode = this.dataAuthTypeRepository.countByCode(entity.getCode());
        Validate.isTrue((countByCode <= createOrUpdate ? 1 : 0) != 0, (String)"\u5f53\u524d\u5173\u8054\u79cd\u7c7b\u7f16\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{entity.getCode()});
        int expandValue = this.dataAuthTypeRepository.countByExpandValue(entity.getExpandValue());
        Validate.isTrue((expandValue <= createOrUpdate ? 1 : 0) != 0, (String)"\u5f53\u524d\u5173\u8054\u79cd\u7c7b\u6269\u5c55\u503c\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (long)entity.getExpandValue().intValue());
    }

    @Override
    public DataAuthTypeEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthTypeRepository.findById(id).orElse(null);
    }

    @Override
    public DataAuthTypeEntity findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.dataAuthTypeRepository.findByNameAndProjectName(name, this.platformContext.getAppName());
    }

    @Override
    public DataAuthTypeEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataAuthTypeRepository.findByCode(code);
    }

    @Override
    @Transactional
    public void updateStatusByCodeAndSortIndex(String code, Integer sortIndex) {
        Validate.notBlank((CharSequence)code, (String)"\u4f20\u5165\u7684\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull((Object)sortIndex, (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthTypeEntity dataAuthTypeEntity = this.findByCode(code);
        Validate.notNull((Object)((Object)dataAuthTypeEntity), (String)"\u6839\u636e\u7f16\u7801\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5173\u8054\u79cd\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((dataAuthTypeEntity.getExpand() == 1 ? 1 : 0) != 0, (String)"\u5185\u7f6e\u5173\u8054\u79cd\u7c7b\u4e0d\u80fd\u88ab\u5220\u9664!!", (Object[])new Object[0]);
        this.dataAuthTypeRepository.updateStatusByCodeAndSortIndex(code, sortIndex);
    }

    @Override
    public List<DataAuthTypeEntity> findAllWithInnerAuthType() {
        String projectName = this.platformContext.getAppName();
        return this.dataAuthTypeRepository.findAll((Specification & Serializable)(root, query, bd) -> {
            Predicate p1 = bd.equal((Expression)root.get("projectName"), (Object)projectName);
            Predicate p2 = bd.lessThanOrEqualTo((Expression)root.get("expand"), (Comparable)Integer.valueOf(1));
            return query.where((Expression)bd.or((Expression)p1, (Expression)p2)).orderBy(new Order[]{bd.asc((Expression)root.get("expand")), bd.asc((Expression)root.get("sortIndex"))}).getRestriction();
        });
    }

    @Override
    public List<DataAuthTypeEntity> findAllWithoutInnerAuthType() {
        String projectName = this.platformContext.getAppName();
        return this.dataAuthTypeRepository.findAll((Specification & Serializable)(root, query, bd) -> {
            Predicate p1 = bd.equal((Expression)root.get("projectName"), (Object)projectName);
            Predicate p2 = bd.equal((Expression)root.get("expand"), (Object)1);
            return query.where((Expression)bd.and((Expression)p1, (Expression)p2)).orderBy(new Order[]{bd.asc((Expression)root.get("expand")), bd.asc((Expression)root.get("sortIndex"))}).getRestriction();
        });
    }

    @Override
    public List<DataAuthTypeEntity> findAllInnerAuthType() {
        return this.dataAuthTypeRepository.findAll((Specification & Serializable)(root, query, bd) -> {
            Predicate p1 = bd.equal((Expression)root.get("expand"), (Object)0);
            return query.where((Expression)p1).orderBy(new Order[]{bd.asc((Expression)root.get("sortIndex"))}).getRestriction();
        });
    }
}

