/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.service.CodeRuleService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="CodeRuleInitProcess")
public class CodeRuleInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeRuleInitProcess.class);
    @Autowired
    private CodeRuleService codeRuleService;
    @Autowired
    private ApplicationContext applicationContext;

    public boolean doProcess() {
        return true;
    }

    public void init() {
        try {
            Object[] resources = this.applicationContext.getResources("classpath*:/coderules/**.json");
            if (ArrayUtils.isEmpty((Object[])resources)) {
                return;
            }
            for (Object resource : resources) {
                try (InputStream is = resource.getInputStream();){
                    this.initCodeRules(is);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("\u8bfb\u53d6\u7f16\u7801\u89c4\u5219\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6");
        }
    }

    private void initCodeRules(InputStream inputStream) throws IOException {
        int line;
        Validate.notNull((Object)inputStream, (String)"\u7f16\u7801\u89c4\u5219\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[512];
        while ((line = inputStream.read(buffer, 0, buffer.length)) != -1) {
            sb.append(new String(buffer, 0, line, StandardCharsets.UTF_8));
        }
        String json = sb.toString();
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.warn("\u521d\u59cb\u5316\u7f16\u7801\u89c4\u5219json\u4e3a\u7a7a\uff01\uff01");
            return;
        }
        List codeRuleEntities = JSONArray.parseArray((String)json, CodeRuleEntity.class);
        codeRuleEntities.forEach(codeRule -> {
            CodeRuleEntity codeRuleEntity = this.codeRuleService.findByRuleCode(codeRule.getRuleCode());
            if (codeRuleEntity == null) {
                codeRule.setCreateAccount("admin");
                codeRule.setModifyAccount("admin");
                this.codeRuleService.create((CodeRuleEntity)((Object)codeRule));
            }
        });
    }
}

