/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.repository.script.ScriptRepository;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.script.persistent.PeristentGroovyClassService;
import com.bizunited.platform.core.service.script.persistent.SimplePersistentGroovyServiceFactory;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ScriptServiceImpl")
public class ScriptServiceImpl
implements ScriptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptServiceImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private ScriptRepository scriptRepository;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserService userService;
    @Autowired
    private SimplePersistentGroovyServiceFactory simplePersistentGroovyServiceFactory;
    @Autowired
    private PlatformContext platformContext;
    private static Map<Integer, ReentrantLock> scriptExecuteLocks = new ConcurrentHashMap<Integer, ReentrantLock>();

    @Override
    public Page<ScriptEntity> findByConditions(Pageable pageable, String name, String language) {
        Validate.notNull((Object)pageable, (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            conditions.put("language", language);
        }
        conditions.put("projectName", this.platformContext.getAppName());
        return this.scriptRepository.queryPage(pageable, conditions);
    }

    @Override
    public ScriptEntity findById(String scriptId) {
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return null;
        }
        Optional scriptEntity = this.scriptRepository.findById(scriptId);
        return scriptEntity.orElse(null);
    }

    @Override
    public ScriptEntity findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.scriptRepository.findByName(name);
    }

    @Override
    public String findContentByName(String scriptName) {
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            return null;
        }
        ScriptEntity currentScript = this.findByName(scriptName);
        if (currentScript == null) {
            return null;
        }
        return this.findContentById(currentScript.getId());
    }

    @Override
    public String findContentById(String scriptId) {
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return null;
        }
        Optional scriptEntity = this.scriptRepository.findById(scriptId);
        if (!scriptEntity.isPresent()) {
            return null;
        }
        byte[] content = this.venusFileService.readFileContent(((ScriptEntity)((Object)scriptEntity.get())).getFileCode(), ((ScriptEntity)((Object)scriptEntity.get())).getFileName());
        return new String(content, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public ScriptEntity update(ScriptEntity scriptEntity, String scriptContent) {
        Validate.notNull((Object)((Object)scriptEntity), (String)"\u811a\u672c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scriptEntity.getLanguage(), (String)"\u811a\u672c\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getName(), (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((scriptEntity.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getId(), (String)"\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.scriptRepository.findById(scriptEntity.getId());
        ScriptEntity existEntity = op.orElse(null);
        Validate.notNull((Object)((Object)existEntity), (String)"\u67e5\u8be2\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo modifyUser = SecurityUtils.getCurrentUser();
        String[] fileinfo = this.saveScriptContent(scriptContent);
        existEntity.setFileName(fileinfo[0]);
        existEntity.setFileCode(fileinfo[1]);
        existEntity.setModifyTime(new Date());
        existEntity.setModifyAccount(modifyUser.getAccount());
        existEntity.setLanguage(scriptEntity.getLanguage());
        existEntity.setName(scriptEntity.getName());
        existEntity.setDescription(scriptEntity.getDescription());
        try {
            ScriptEntity scriptEntity2 = (ScriptEntity)((Object)this.scriptRepository.save((Object)existEntity));
            return scriptEntity2;
        }
        finally {
            PeristentGroovyClassService peristentGroovyClassService = this.simplePersistentGroovyServiceFactory.createPeristentGroovyClassService();
            peristentGroovyClassService.delete(existEntity.getId());
        }
    }

    private String[] saveScriptContent(String scriptContent) {
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + ".txt";
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/groovyScript/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] scriptContentByte = scriptContent.getBytes(StandardCharsets.UTF_8);
        this.venusFileService.saveFile(relativePath, fileRename, fileRename, scriptContentByte);
        return new String[]{fileRename, relativePath};
    }

    @Override
    @Transactional
    public ScriptEntity create(ScriptEntity scriptEntity, String scriptContent) {
        Validate.notNull((Object)((Object)scriptEntity), (String)"\u811a\u672c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scriptEntity.getLanguage(), (String)"\u811a\u672c\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getName(), (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ScriptEntity existEntity = this.scriptRepository.findByName(scriptEntity.getName());
        Validate.isTrue((null == existEntity ? 1 : 0) != 0, (String)"\u811a\u672c\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)scriptEntity.getCreateAccount()) || StringUtils.isBlank((CharSequence)scriptEntity.getModifyAccount())) {
            UserVo userVo = SecurityUtils.getCurrentUser();
            scriptEntity.setCreateAccount(userVo.getAccount());
            scriptEntity.setModifyAccount(userVo.getAccount());
        }
        String[] fileinfo = this.saveScriptContent(scriptContent);
        scriptEntity.setFileName(fileinfo[0]);
        scriptEntity.setFileCode(fileinfo[1]);
        scriptEntity.setCreateTime(new Date());
        scriptEntity.setModifyTime(new Date());
        scriptEntity.setProjectName(this.platformContext.getAppName());
        return (ScriptEntity)((Object)this.scriptRepository.save((Object)scriptEntity));
    }

    @Override
    @NebulaServiceMethod(name="scriptService.invoke", desc="\u6267\u884c\u4e00\u4e2a\u6216\u8005\u591a\u4e2agroovy\u811a\u672c\u6267\u884c\u5668\u7684\u8c03\u7528")
    public Map<String, Object> invoke(@ServiceMethodParam(name="scriptIds") String[] scriptIds, Map<String, Object> params) throws InvokeProxyException {
        Validate.notNull((Object)scriptIds, (String)"\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\u811a\u672c\u5185\u5bb9\u7f16\u53f7", (Object[])new Object[0]);
        Validate.isTrue((scriptIds.length >= 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\u811a\u672c\u5185\u5bb9\u7f16\u53f7", (Object[])new Object[0]);
        Map<String, Object> currentParams = params;
        if (currentParams == null) {
            currentParams = new HashMap<String, Object>();
        }
        ArrayList<ScriptEntity> scriptEntities = new ArrayList<ScriptEntity>();
        for (String scriptId : scriptIds) {
            Validate.notBlank((CharSequence)scriptId, (String)"\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional op = this.scriptRepository.findById(scriptId);
            ScriptEntity scriptEntity = op.orElse(null);
            Validate.notNull((Object)((Object)scriptEntity), (String)"[%s]\u5bf9\u5e94\u7684\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{scriptId});
            scriptEntities.add(scriptEntity);
        }
        for (ScriptEntity scriptItem : scriptEntities) {
            Map<String, Object> result = this.invokeOne(scriptItem, currentParams);
            if (CollectionUtils.isEmpty(result)) continue;
            currentParams.putAll(result);
        }
        return currentParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Map<String, Object> invokeOne(ScriptEntity scriptItem, Map<String, Object> params) throws InvokeProxyException {
        PeristentGroovyClassService peristentGroovyClassService = this.simplePersistentGroovyServiceFactory.createPeristentGroovyClassService();
        Script groovyScript = (Script)peristentGroovyClassService.findByClassName(scriptItem.getId());
        Integer idHashcode = scriptItem.getId().hashCode();
        if (groovyScript == null) {
            Class<ScriptService> clazz = ScriptService.class;
            // MONITORENTER : com.bizunited.platform.core.service.ScriptService.class
            groovyScript = (Script)peristentGroovyClassService.findByClassName(scriptItem.getId());
            if (groovyScript == null) {
                byte[] scriptContent = this.venusFileService.readFileContent(scriptItem.getFileCode(), scriptItem.getFileName());
                String groovyStr = new String(scriptContent);
                LOGGER.info("\u6b63\u5728\u8fdb\u884cgroovy\u811a\u672c\u7f16\u8bd1\uff0c\u811a\u672cid = " + idHashcode);
                GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.applicationContext.getClassLoader());
                GroovyShell shell = new GroovyShell((ClassLoader)groovyClassLoader);
                try {
                    groovyScript = shell.parse(groovyStr);
                    peristentGroovyClassService.save(scriptItem.getId(), groovyScript);
                    if (scriptExecuteLocks.get(idHashcode) == null) {
                        scriptExecuteLocks.put(idHashcode, new ReentrantLock());
                    }
                }
                catch (CompilationFailedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u7f16\u8bd1groovy\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            // MONITOREXIT : clazz
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ReentrantLock reentrantLock = null;
        try {
            reentrantLock = scriptExecuteLocks.get(idHashcode);
            reentrantLock.lock();
            Binding binding = this.bindingScriptVars(params);
            groovyScript.setBinding(binding);
            groovyScript.run();
            Map bindingParams = binding.getVariables();
            if (CollectionUtils.isEmpty((Map)bindingParams)) return result;
            Iterator iterator = bindingParams.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                result.put(key, binding.getVariable(key));
            }
            return result;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (reentrantLock != null) {
                reentrantLock.unlock();
            }
        }
    }

    private Binding bindingScriptVars(Map<String, Object> params) {
        Binding binding = new Binding();
        binding.setVariable("userService", (Object)this.userService);
        binding.setVariable("roleService", (Object)this.roleService);
        binding.setVariable("positionService", (Object)this.positionService);
        binding.setVariable("organizationService", (Object)this.organizationService);
        if (this.redisMutexService != null) {
            binding.setVariable("redisMutexService", (Object)this.redisMutexService);
        }
        binding.setVariable("ctx", (Object)this.applicationContext);
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> item : params.entrySet()) {
                binding.setVariable(item.getKey(), item.getValue());
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(String scriptContent, Map<String, Object> params) {
        Validate.notBlank((CharSequence)scriptContent, (String)"\u5fc5\u987b\u8981\u6709\u9700\u8981\u6267\u884c\u7684\u811a\u672c\u5185\u5bb9", (Object[])new Object[0]);
        Map<String, Object> currentParams = params;
        if (currentParams == null) {
            currentParams = new HashMap<String, Object>();
        }
        byte[] contxts = scriptContent.getBytes(StandardCharsets.UTF_8);
        String conextBase64 = Base64.getEncoder().encodeToString(contxts);
        Integer idHashcode = conextBase64.hashCode();
        PeristentGroovyClassService peristentGroovyClassService = this.simplePersistentGroovyServiceFactory.createPeristentGroovyClassService();
        Script groovyScript = (Script)peristentGroovyClassService.findByClassName(conextBase64);
        if (groovyScript == null) {
            Class<ScriptService> clazz = ScriptService.class;
            // MONITORENTER : com.bizunited.platform.core.service.ScriptService.class
            groovyScript = (Script)peristentGroovyClassService.findByClassName(conextBase64);
            if (groovyScript == null) {
                GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.applicationContext.getClassLoader());
                GroovyShell shell = new GroovyShell((ClassLoader)groovyClassLoader);
                try {
                    LOGGER.info("\u6b63\u5728\u8fdb\u884cgroovy\u811a\u672c\u7f16\u8bd1\uff0c\u811a\u672cid = " + conextBase64);
                    groovyScript = shell.parse(scriptContent);
                    peristentGroovyClassService.save(conextBase64, groovyScript);
                    if (scriptExecuteLocks.get(idHashcode) == null) {
                        scriptExecuteLocks.put(idHashcode, new ReentrantLock());
                    }
                }
                catch (CompilationFailedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u7f16\u8bd1groovy\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            // MONITOREXIT : clazz
        }
        Object returnValue = null;
        ReentrantLock reentrantLock = null;
        try {
            reentrantLock = scriptExecuteLocks.get(idHashcode);
            reentrantLock.lock();
            Binding binding = this.bindingScriptVars(currentParams);
            groovyScript.setBinding(binding);
            returnValue = groovyScript.run();
            Map variables = binding.getVariables();
            if (variables == null) return returnValue;
            Set entrySet = variables.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                currentParams.put((String)entry.getKey(), entry.getValue());
            }
            return returnValue;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (reentrantLock != null) {
                reentrantLock.unlock();
            }
        }
    }
}

