/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.entity.SystemThemeEntity;
import com.bizunited.platform.core.repository.SystemThemeRepository;
import com.bizunited.platform.core.service.SystemThemeService;
import com.bizunited.platform.venus.common.service.file.FileRelativeTemplate;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.bizunited.platform.venus.common.service.image.FileUpdateService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.transaction.Transactional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="SystemThemeServiceImpl")
public class SystemThemeServiceImpl
implements SystemThemeService {
    @Value(value="${venus.file.fileRoot}")
    private String fileRoot;
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemThemeServiceImpl.class);
    private static final String THEME_FILE_NAME = "theme.json";
    private static final String MESS_FIELD_NAME = "fileName";
    private static final String MESS_RELATIVE_LOCAL = "relativeLocal";
    private static final String MESS_THEME = "theme";
    private static final String UNDEFINED = "undefined/undefined";
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private SystemThemeRepository systemThemeRepository;
    @Autowired
    private FileRelativeTemplate fileRelativeTemplate;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public OrdinaryFileVo uploadLogo(MultipartFile file, Principal principal) {
        String account = this.validatePrincipal(principal);
        Validate.notNull((Object)file, (String)"logo\u56fe\u7247\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List logos = this.fileUpdateService.fileUpload("logo", account, null, new MultipartFile[]{file});
        Validate.notEmpty((Collection)logos, (String)"logo\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!logos.isEmpty() ? 1 : 0) != 0, (String)"logo\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return (OrdinaryFileVo)logos.get(0);
    }

    @Override
    @Transactional
    public SystemThemeEntity save(JSONObject theme, Principal principal) {
        SystemThemeEntity entity;
        String projectName;
        List<SystemThemeEntity> themes;
        String renameFile;
        String account = this.validatePrincipal(principal);
        Validate.notEmpty((Map)theme, (String)"\u7cfb\u7edf\u4e3b\u9898\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, String> themePath = this.resolveThemePath(theme);
        String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String relativePath = themePath.get(MESS_RELATIVE_LOCAL);
        if (StringUtils.isBlank((CharSequence)relativePath)) {
            relativePath = "/theme/" + folderName;
            JSONObject themePathObject = theme.getJSONObject(MESS_THEME);
            themePathObject.put(MESS_RELATIVE_LOCAL, (Object)relativePath);
        }
        if (StringUtils.isBlank((CharSequence)(renameFile = themePath.get(MESS_FIELD_NAME)))) {
            renameFile = UUID.randomUUID().toString() + ".json";
            JSONObject themePathObject = theme.getJSONObject(MESS_THEME);
            themePathObject.put(MESS_FIELD_NAME, (Object)renameFile);
        }
        Validate.isTrue(((themes = this.findByProjectName(projectName = this.platformContext.getAppName())) == null || themes.size() <= 1 ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u6709\u591a\u6761\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date now = new Date();
        if (themes == null || themes.isEmpty()) {
            this.saveThemeFile(renameFile, relativePath, theme);
            entity = new SystemThemeEntity();
            entity.setCommitUser(account);
            entity.setUpdateUser(account);
            entity.setCreateTime(now);
            entity.setUpdateTime(now);
            entity.setProjectName(projectName);
            entity.setFileName(renameFile);
            entity.setOriginalName(THEME_FILE_NAME);
            entity.setRelativeLocal(relativePath);
        } else {
            entity = themes.get(0);
            Validate.notNull((Object)((Object)entity), (String)"\u6839\u636e\u4e3b\u9898\u4fe1\u606f\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u4e3b\u9898\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            entity.setUpdateTime(now);
            entity.setUpdateUser(account);
            entity.setFileName(renameFile);
            entity.setOriginalName(THEME_FILE_NAME);
            entity.setRelativeLocal(relativePath);
            this.saveThemeFile(renameFile, relativePath, theme);
        }
        this.systemThemeRepository.save((Object)entity);
        return entity;
    }

    private List<SystemThemeEntity> findByProjectName(String projectName) {
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            return this.systemThemeRepository.findByProjectName(projectName);
        }
        return this.systemThemeRepository.findByBlankProjectName();
    }

    @Override
    public JSONObject findTheme() {
        String projectName = this.platformContext.getAppName();
        List<SystemThemeEntity> themes = this.findByProjectName(projectName);
        if (CollectionUtils.isEmpty(themes)) {
            return null;
        }
        Validate.isTrue((themes.size() <= 1 ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u6709\u591a\u6761\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SystemThemeEntity theme = themes.get(0);
        byte[] content = this.venusFileService.readFileContent(theme.getRelativeLocal(), theme.getFileName());
        if (ArrayUtils.isEmpty((byte[])content)) {
            LOGGER.warn("\u672a\u80fd\u53d1\u73b0\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        String jsonStr = new String(content, StandardCharsets.UTF_8);
        return JSON.parseObject((String)jsonStr);
    }

    private String validatePrincipal(Principal principal) {
        Validate.notNull((Object)principal, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return account;
    }

    private Map<String, String> resolveThemePath(JSONObject theme) {
        Validate.notNull((Object)theme, (String)"\u7cfb\u7edf\u4e3b\u9898\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashMap<String, String> themePathMap = new HashMap<String, String>();
        JSONObject themeJson = theme.getJSONObject(MESS_THEME);
        if (themeJson == null || themeJson.size() == 0) {
            return themePathMap;
        }
        String relativeLocal = themeJson.getString(MESS_RELATIVE_LOCAL);
        String fileName = themeJson.getString(MESS_FIELD_NAME);
        Validate.notBlank((CharSequence)relativeLocal, (String)"\u7cfb\u7edf\u4e3b\u9898\u4e2d\uff0c\u7ed9\u5b9a\u7684\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u7cfb\u7edf\u4e3b\u9898\u4e2d\uff0c\u7ed9\u5b9a\u7684\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        themePathMap.put(MESS_FIELD_NAME, fileName);
        themePathMap.put(MESS_RELATIVE_LOCAL, relativeLocal);
        return themePathMap;
    }

    private void saveThemeFile(String renameFile, String relativePath, JSONObject theme) {
        byte[] content;
        Validate.notEmpty((Map)theme, (String)"\u4f20\u5165\u7684\u4e3b\u9898json\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        try {
            content = theme.toJSONString().getBytes("utf-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u4e3b\u9898\u6570\u636e\u8f6c\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!");
        }
        this.venusFileService.saveFile(relativePath, THEME_FILE_NAME, renameFile, content);
    }

    @Override
    public byte[] export() {
        byte[] fullZipBytes;
        List<SystemThemeEntity> themes = this.findByProjectName(this.platformContext.getAppName());
        Validate.isTrue((themes.size() == 1 ? 1 : 0) != 0, (String)"\u83b7\u53d6\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SystemThemeEntity theme = themes.get(0);
        try (ByteArrayOutputStream fullZipOutputStream = new ByteArrayOutputStream();
             ZipOutputStream zipOutputStream = new ZipOutputStream(fullZipOutputStream);){
            this.handleTheme(zipOutputStream, theme);
            zipOutputStream.finish();
            fullZipBytes = fullZipOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return fullZipBytes;
    }

    private void handleTheme(ZipOutputStream zipf, SystemThemeEntity theme) {
        Validate.notNull((Object)((Object)theme), (String)"\u4e3b\u9898\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String fileName = theme.getFileName();
        Validate.notBlank((CharSequence)fileName, (String)"\u672a\u627e\u5230\u4e3b\u9898\u7684\u6587\u4ef6\u540d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String relativeLocal = theme.getRelativeLocal();
        Validate.notBlank((CharSequence)relativeLocal, (String)"\u672a\u627e\u5230\u4e3b\u9898\u7684\u76f8\u5bf9\u8def\u5f84\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        byte[] themeByte = this.venusFileService.readFileContent(relativeLocal, fileName);
        Validate.isTrue((themeByte != null && themeByte.length != 0 ? 1 : 0) != 0, (String)"theme.json\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String jsonStr = new String(themeByte, StandardCharsets.UTF_8);
        Object logo = JSON.parseObject((String)jsonStr).get((Object)"logo");
        Object systemIcon = JSON.parseObject((String)jsonStr).get((Object)"system_icon");
        Object smallLogo = JSON.parseObject((String)jsonStr).get((Object)"small_logo");
        try {
            if (logo != null && !UNDEFINED.equals(logo)) {
                String logoFileName;
                String logoRelativeLocal = this.getRelativeLocal(logo.toString());
                byte[] logoByte = this.venusFileService.readFileContent(logoRelativeLocal, logoFileName = this.getFileName(logo.toString()));
                Validate.isTrue((logoByte != null && logoByte.length != 0 ? 1 : 0) != 0, (String)"logo\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                this.writeZipFile(zipf, "logo.png", logoByte);
            }
            if (systemIcon != null && !UNDEFINED.equals(systemIcon)) {
                String systemIconFileName;
                String systemIconRelativeLocal = this.getRelativeLocal(systemIcon.toString());
                byte[] systemIconByte = this.venusFileService.readFileContent(systemIconRelativeLocal, systemIconFileName = this.getFileName(systemIcon.toString()));
                Validate.isTrue((systemIconByte != null && systemIconByte.length != 0 ? 1 : 0) != 0, (String)"icon\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                this.writeZipFile(zipf, "system_icon.png", systemIconByte);
            }
            if (smallLogo != null && !UNDEFINED.equals(smallLogo)) {
                String smallLogoFileName;
                String smallLogoRelativeLocal = this.getRelativeLocal(smallLogo.toString());
                byte[] smallLogoByte = this.venusFileService.readFileContent(smallLogoRelativeLocal, smallLogoFileName = this.getFileName(smallLogo.toString()));
                Validate.isTrue((smallLogoByte != null && smallLogoByte.length != 0 ? 1 : 0) != 0, (String)"small_logo\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                this.writeZipFile(zipf, "small_logo.png", smallLogoByte);
            }
            this.writeZipFile(zipf, THEME_FILE_NAME, themeByte);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private String getFileName(String str) {
        Validate.notBlank((CharSequence)str, (String)"\u6587\u4ef6\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return str.substring(str.lastIndexOf("/") + 1);
    }

    private String getRelativeLocal(String str) {
        Validate.notBlank((CharSequence)str, (String)"\u6587\u4ef6\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return str.substring(0, str.lastIndexOf("/"));
    }

    private void writeZipFile(ZipOutputStream zipf, String zipFileName, byte[] bosBytes) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipFileName);
        zipf.putNextEntry(zipEntry);
        int maxLen = 9060;
        byte[] fileContents = new byte[maxLen];
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bosBytes);){
            int realLen;
            while ((realLen = bis.read(fileContents, 0, maxLen)) != -1) {
                zipf.write(fileContents, 0, realLen);
            }
        }
    }

    @Override
    public SystemThemeEntity importTheme(Principal currentUser, MultipartFile file) {
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)currentUser, (String)"\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SystemThemeEntity themeEntity = null;
        try {
            byte[] bytes;
            File tempFile = new File(file.getName());
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)tempFile);
            ZipFile zipFile = new ZipFile(tempFile);
            ZipEntry theme = zipFile.getEntry(THEME_FILE_NAME);
            ZipEntry logo = zipFile.getEntry("logo.png");
            ZipEntry icon = zipFile.getEntry("system_icon.png");
            ZipEntry smallLogo = zipFile.getEntry("small_logo.png");
            String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String logoStr = "";
            if (logo != null) {
                byte[] bytes2 = this.zipEntryToByte(zipFile, logo);
                String logoRelativePath = this.fileRelativeTemplate.generatRelativePath("logo", null);
                String logoName = UUID.randomUUID().toString() + ".png";
                logoStr = logoRelativePath + "/" + logoName;
                this.venusFileService.saveFile(logoRelativePath, "logo.png", logoName, bytes2);
            }
            String iconStr = "";
            if (icon != null) {
                byte[] bytes3 = this.zipEntryToByte(zipFile, icon);
                String iconRelativePath = this.fileRelativeTemplate.generatRelativePath("system_icon", null);
                String iconName = UUID.randomUUID().toString() + ".png";
                iconStr = iconRelativePath + "/" + iconName;
                this.venusFileService.saveFile(iconRelativePath, "system_icon.png", iconName, bytes3);
            }
            String smallLogoStr = "";
            if (smallLogo != null) {
                bytes = this.zipEntryToByte(zipFile, smallLogo);
                String smallLogoRelativePath = this.fileRelativeTemplate.generatRelativePath("small_logo", null);
                String smallLogoName = UUID.randomUUID().toString() + ".png";
                smallLogoStr = smallLogoRelativePath + "/" + smallLogoName;
                this.venusFileService.saveFile(smallLogoRelativePath, "small_logo.png", smallLogoName, bytes);
            }
            if (theme != null) {
                bytes = this.zipEntryToByte(zipFile, theme);
                String jsonStr = new String(bytes, StandardCharsets.UTF_8);
                JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                if (StringUtils.isNotBlank((CharSequence)logoStr)) {
                    jsonObject.put("logo", (Object)logoStr);
                }
                if (StringUtils.isNotBlank((CharSequence)iconStr)) {
                    jsonObject.put("system_icon", (Object)iconStr);
                }
                if (StringUtils.isNotBlank((CharSequence)smallLogoStr)) {
                    jsonObject.put("small_logo", (Object)smallLogoStr);
                }
                String themeRelativePath = "/theme/" + folderName;
                String themeName = UUID.randomUUID().toString() + ".json";
                String originalName = THEME_FILE_NAME;
                JSONObject object = (JSONObject)JSON.toJSON((Object)jsonObject.get((Object)MESS_THEME));
                object.put(MESS_FIELD_NAME, (Object)themeName);
                object.put(MESS_RELATIVE_LOCAL, (Object)themeRelativePath);
                byte[] rbytes = jsonObject.toString().getBytes();
                this.venusFileService.saveFile(themeRelativePath, originalName, themeName, rbytes);
                String projectName = this.platformContext.getAppName();
                List<SystemThemeEntity> themes = this.findByProjectName(projectName);
                Validate.isTrue((themes.size() <= 1 ? 1 : 0) != 0, (String)"\u83b7\u53d6\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                if (themes.size() == 1) {
                    themeEntity = themes.get(0);
                } else {
                    themeEntity = new SystemThemeEntity();
                    themeEntity.setCommitUser(currentUser.getName());
                    themeEntity.setCreateTime(new Date());
                    themeEntity.setProjectName(projectName);
                }
                themeEntity.setFileName(themeName);
                themeEntity.setOriginalName(originalName);
                themeEntity.setRelativeLocal(themeRelativePath);
                themeEntity.setUpdateTime(new Date());
                themeEntity.setUpdateUser(currentUser.getName());
                this.systemThemeRepository.save((Object)themeEntity);
            }
            return themeEntity;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private byte[] zipEntryToByte(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        InputStream is = zipFile.getInputStream(zipEntry);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = is.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

