/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.invoke;

import com.bizunited.platform.core.service.invoke.DefaultHandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.invoke.binding.InvokeRequestHandleBinding;
import com.bizunited.platform.core.service.invoke.binding.InvokeResponseHandleBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class InvokeProxyBuilder {
    private List<? super Object> invokeRequestHandleCredentials = new ArrayList<Object>(16);
    private List<? super Object> invokeResponseHandleCredentials = new ArrayList<Object>(16);
    private ClassLoader classLoader;
    private InvokeRequestHandleBinding invokeRequestHandleBinding;
    private InvokeResponseHandleBinding invokeResponseHandleBinding;

    public InvokeProxy build() {
        ClassLoader currentClassLoader = this.classLoader;
        if (currentClassLoader == null) {
            currentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.invokeRequestHandleCredentials.isEmpty() && this.invokeResponseHandleCredentials.isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u53d1\u73b0\u8c03\u7528\u4e2d\u5b58\u5728\u4efb\u4f55\u7684Request Handle\u548cResponse Handle\uff0c\u8bf7\u68c0\u67e5!!");
        }
        ArrayList<InvokeRequestHandle> requestHandles = new ArrayList<InvokeRequestHandle>(16);
        for (Object object : this.invokeRequestHandleCredentials) {
            if (object instanceof InvokeRequestHandle) {
                requestHandles.add((InvokeRequestHandle)object);
            }
            if (!(object instanceof Class)) continue;
            Validate.notNull((Object)this.invokeRequestHandleBinding, (String)"\u6839\u636e\u8bbe\u5b9a\uff0c\u9700\u8981\u8fdb\u884cInvokeRequestHandle Class\u7684\u7ed1\u5b9a\u64cd\u4f5c\uff0c\u4f46\u662f\u672a\u53d1\u73b0\u4efb\u4f55invokeRequestHandleBinding\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            requestHandles.add(this.invokeRequestHandleBinding.binding((Class)object));
        }
        ArrayList<InvokeResponseHandle> responseHandles = new ArrayList<InvokeResponseHandle>(16);
        for (Object object : this.invokeResponseHandleCredentials) {
            if (object instanceof InvokeResponseHandle) {
                responseHandles.add((InvokeResponseHandle)object);
            }
            if (!(object instanceof Class)) continue;
            Validate.notNull((Object)this.invokeResponseHandleBinding, (String)"\u6839\u636e\u8bbe\u5b9a\uff0c\u9700\u8981\u8fdb\u884cInvokeResponseHandle Class\u7684\u7ed1\u5b9a\u64cd\u4f5c\uff0c\u4f46\u662f\u672a\u53d1\u73b0\u4efb\u4f55invokeResponseHandleBinding\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            responseHandles.add(this.invokeResponseHandleBinding.binding((Class)object));
        }
        DefaultHandleChain defaultHandleChain = new DefaultHandleChain();
        defaultHandleChain.setInvokeRequestHandles(requestHandles);
        defaultHandleChain.setInvokeResponseHandles(responseHandles);
        InvokeProxy invokeProxy = new InvokeProxy();
        invokeProxy.setTargetHandleChain(defaultHandleChain);
        return invokeProxy;
    }

    public InvokeProxyBuilder copy(InvokeProxyBuilder source) {
        if (source.invokeRequestHandleCredentials != null && source.invokeRequestHandleCredentials.size() > 0) {
            this.invokeRequestHandleCredentials.addAll(source.invokeRequestHandleCredentials);
        }
        if (source.invokeResponseHandleCredentials != null && source.invokeResponseHandleCredentials.size() > 0) {
            this.invokeResponseHandleCredentials.addAll(source.invokeResponseHandleCredentials);
        }
        return this;
    }

    public InvokeProxyBuilder addClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public InvokeProxyBuilder addInvokeResponseFilter(InvokeResponseHandle ... responses) {
        Arrays.stream(responses).forEach(filter -> this.invokeResponseHandleCredentials.add(filter));
        return this;
    }

    public InvokeProxyBuilder addInvokeResponseTypeFilter(Class<? extends InvokeResponseHandle> ... responseTypes) {
        Arrays.stream(responseTypes).forEach(filter -> this.invokeResponseHandleCredentials.add(filter));
        return this;
    }

    public InvokeProxyBuilder addInvokeRequestFilter(InvokeRequestHandle ... requests) {
        Arrays.stream(requests).forEach(filter -> this.invokeRequestHandleCredentials.add(filter));
        return this;
    }

    public InvokeProxyBuilder addInvokeRequestTypeFilter(Class<? extends InvokeRequestHandle> ... requestTypes) {
        Arrays.stream(requestTypes).forEach(filter -> this.invokeRequestHandleCredentials.add(filter));
        return this;
    }

    public InvokeProxyBuilder setInvokeRequestHandleBinding(InvokeRequestHandleBinding invokeRequestHandleBinding) {
        this.invokeRequestHandleBinding = invokeRequestHandleBinding;
        return this;
    }

    public InvokeProxyBuilder setInvokeResponseHandleBinding(InvokeResponseHandleBinding invokeResponseHandleBinding) {
        this.invokeResponseHandleBinding = invokeResponseHandleBinding;
        return this;
    }
}

