/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import com.bizunited.platform.core.repository.log.LoggerTemplateEntityRepository;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.log.LoggerNotifyService;
import com.bizunited.platform.core.service.log.LoggerValidator;
import com.bizunited.platform.core.service.log.pojo.LoggerNotifyPojo;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserVo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaLoggerHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaLoggerHandle.class);
    @Autowired
    @Lazy
    private LoggerTemplateEntityRepository loggerTemplateRepository;
    @Autowired
    @Lazy
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    @Lazy
    private ApplicationContext applicationContext;
    @Autowired
    private PositionService positionService;
    @Autowired(required=false)
    private List<LoggerValidator> loggerValidators;
    @Autowired
    private LoggerNotifyService loggerNotifyService;

    public Object handLogger(LoggerTemplateEntity target, MethodInvocation methodInvocation) {
        this.validate(target);
        String expression = target.getExpression();
        Integer methodParamIndex = target.getMethodParamIndex();
        if (methodParamIndex == null) {
            methodParamIndex = 0;
        }
        Boolean compare = target.getCompare();
        String account = "\u533f\u540d\u7528\u6237";
        String position = "";
        UserVo user = SecurityUtils.getCurrentUser();
        if (user != null) {
            account = user.getAccount();
            PositionVo mainPosition = this.positionService.findMainPositionByUserId(user.getId());
            if (mainPosition != null) {
                position = mainPosition.getName();
            }
        }
        String preQueryComponent = target.getPreQueryComponent();
        String preQueryMethod = target.getPreQueryMethod();
        String preReturnFilter = target.getPreReturnFilter();
        Object[] args = methodInvocation.getArguments();
        Method targetMethod = methodInvocation.getMethod();
        Object inputParam = args[methodParamIndex];
        Validate.notNull((Object)inputParam, (String)"\u9519\u8bef\u7684\u5165\u53c2\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u8c03\u7528\u7684\u7b2c[%d]\u4e2a\u5165\u53c2\u4fe1\u606f\uff0c", (Object[])new Object[]{methodParamIndex});
        String methodParamProperty = target.getMethodParamProperty();
        if (StringUtils.isNotBlank((CharSequence)methodParamProperty)) {
            inputParam = this.analysisValueByField(inputParam, methodParamProperty);
        }
        Object preObject = null;
        if (StringUtils.isNotBlank((CharSequence)preQueryComponent) && StringUtils.isNotBlank((CharSequence)preQueryMethod) && inputParam != null) {
            preObject = this.invokeComponent(preQueryComponent, preQueryMethod, preReturnFilter, inputParam);
        }
        Object obj = null;
        Object lastObject = null;
        Date opTime = new Date();
        try {
            obj = methodInvocation.proceed();
            if (!CollectionUtils.isEmpty(this.loggerValidators)) {
                for (LoggerValidator loggerValidator : this.loggerValidators) {
                    if (loggerValidator.validate(obj, target, targetMethod, args)) continue;
                    return obj;
                }
            }
            this.loggerTemplateRepository.flush();
            inputParam = methodInvocation.getArguments()[methodParamIndex];
            if (StringUtils.isNotBlank((CharSequence)methodParamProperty)) {
                inputParam = this.analysisValueByField(inputParam, methodParamProperty);
            }
            if (inputParam == null && obj != null) {
                inputParam = this.analysisValueByField(obj, methodParamProperty);
            }
            String lastQueryComponent = target.getLastQueryComponent();
            String lastQueryMethod = target.getLastQueryMethod();
            String lastReturnFilter = target.getLastReturnFilter();
            if (StringUtils.isNotBlank((CharSequence)lastQueryComponent) && StringUtils.isNotBlank((CharSequence)lastQueryMethod) && inputParam != null) {
                lastObject = this.invokeComponent(lastQueryComponent, lastQueryMethod, lastReturnFilter, inputParam);
            }
            String expressionValue = this.analysisExpression(expression, account, position, opTime, preObject, lastObject);
            Object pkValue = null;
            if (lastObject != null) {
                pkValue = this.analysisValueByField(lastObject, "id");
            }
            if (pkValue == null && preObject != null) {
                pkValue = this.analysisValueByField(preObject, "id");
            }
            if (pkValue == null) {
                pkValue = inputParam;
            }
            Validate.notNull((Object)pkValue, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u552f\u4e00\u503c\u4f9d\u636e(\u4e00\u822c\u4e0d\u53ef\u80fd\u51fa\u73b0)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            LoggerNotifyPojo loggerNotifyPojo = new LoggerNotifyPojo();
            loggerNotifyPojo.setAccount(account);
            loggerNotifyPojo.setPosition(position);
            loggerNotifyPojo.setOpTime(opTime);
            loggerNotifyPojo.setMsg(expressionValue);
            loggerNotifyPojo.setOpId(pkValue.toString());
            loggerNotifyPojo.setPreObject(preObject);
            loggerNotifyPojo.setLastObject(lastObject);
            loggerNotifyPojo.setCode(target.getCode());
            loggerNotifyPojo.setCompare(compare);
            loggerNotifyPojo.setExpression(target.getExpression());
            loggerNotifyPojo.setModule(target.getModule());
            loggerNotifyPojo.setName(target.getName());
            loggerNotifyPojo.setType(target.getType());
            this.loggerNotifyService.notify(loggerNotifyPojo);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable thr) {
            Rethrower.rethrow(thr);
        }
        return obj;
    }

    private void validate(LoggerTemplateEntity target) {
        String code = target.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u65e5\u5fd7\u6a21\u677f\u7684\u4e1a\u52a1\u7f16\u7801\u5fc5\u987b\u586b\u5199(code)", (Object[])new Object[0]);
        String type = target.getType();
        Validate.notBlank((CharSequence)type, (String)"\u65e5\u5fd7\u64cd\u4f5c\u7c7b\u578b\u5fc5\u987b\u586b\u5199[%s]!!", (Object[])new Object[]{code});
        String module = target.getModule();
        Validate.notBlank((CharSequence)module, (String)"\u65e5\u5fd7\u64cd\u4f5c\u6a21\u5757\u5fc5\u987b\u8bbe\u5b9a[%s]!!", (Object[])new Object[]{code});
        String methodName = target.getMethodName();
        Validate.notBlank((CharSequence)methodName, (String)"\u5fc5\u987b\u8bbe\u5b9a\u65e5\u5fd7\u7684\u64cd\u4f5c\u65b9\u6cd5[%s]", (Object[])new Object[]{code});
        String expression = target.getExpression();
        Validate.notBlank((CharSequence)expression, (String)"\u65e5\u5fd7\u8868\u8fbe\u5f0f\u5fc5\u987b\u586b\u5199[%s]", (Object[])new Object[]{code});
        Boolean compare = target.getCompare();
        String preQueryComponent = target.getPreQueryComponent();
        String preQueryMethod = target.getPreQueryMethod();
        String preReturnFilter = target.getPreReturnFilter();
        String lastQueryComponent = target.getLastQueryComponent();
        String lastQueryMethod = target.getLastQueryMethod();
        String lastReturnFilter = target.getLastReturnFilter();
        if (compare.booleanValue()) {
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)preQueryComponent) && StringUtils.isNotBlank((CharSequence)preQueryMethod) && StringUtils.isNotBlank((CharSequence)preReturnFilter) ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6a21\u677f[%s]\u8bbe\u5b9a\u4e86\u9700\u8981\u8fdb\u884c\u53d8\u5316\u660e\u7ec6\u6bd4\u5bf9\uff0c\u4f46\u662f\u5176\u524d\u7f6e\u67e5\u8be2\u8bbe\u5b9a\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)lastQueryComponent) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lastQueryMethod}) && StringUtils.isNotBlank((CharSequence)lastReturnFilter) ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6a21\u677f[%s]\u8bbe\u5b9a\u4e86\u9700\u8981\u8fdb\u884c\u53d8\u5316\u660e\u7ec6\u6bd4\u5bf9\uff0c\u4f46\u662f\u5176\u540e\u7f6e\u67e5\u8be2\u8bbe\u5b9a\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        }
    }

    private Object invokeComponent(String queryComponent, String queryMethod, String returnFilter, Object inputParam) {
        Object targetBean = null;
        Class<?> sourceClass = null;
        boolean hasBean = true;
        try {
            targetBean = this.applicationContext.getBean(queryComponent);
        }
        catch (NoSuchBeanDefinitionException e) {
            hasBean = false;
        }
        if (hasBean) {
            sourceClass = ClassUtils.getUserClass((Object)targetBean);
        } else {
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            try {
                sourceClass = classLoader.loadClass(queryComponent);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            targetBean = this.applicationContext.getBean(sourceClass);
        }
        Validate.notNull((Object)targetBean, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684spring bean\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull(sourceClass, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684source class\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Method targetMethod = BeanUtils.findMethodWithMinimalParameters(sourceClass, (String)queryMethod);
        Validate.notNull((Object)targetMethod, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u65b9\u6cd5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u540d[%s]\u7684\u8bbe\u5b9a", (Object[])new Object[]{queryMethod});
        Object value = null;
        try {
            value = targetMethod.invoke(targetBean, inputParam);
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (value == null) {
            return null;
        }
        Class sourceUserClass = ClassUtils.getUserClass(value.getClass());
        Validate.isTrue((!Iterable.class.isAssignableFrom(sourceUserClass) ? 1 : 0) != 0, (String)"\u76ee\u524d\u65e5\u5fd7\u64cd\u4f5c\u914d\u7f6e\u4e0d\u652f\u6301\u5bf9\u96c6\u5408\u6027\u8d28\u7684\u6279\u91cf\u64cd\u4f5c\u65b9\u6cd5\u8fdb\u884c\u65e5\u5fd7\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (Object[])new Object[0]);
        Object copyValue = null;
        copyValue = !this.allowCopyObject(value.getClass()) ? value : (StringUtils.isBlank((CharSequence)returnFilter) ? this.nebulaToolkitService.copyObjectByWhiteList(value, sourceUserClass, HashSet.class, ArrayList.class, new String[0]) : this.nebulaToolkitService.copyObjectByWhiteList(value, sourceUserClass, HashSet.class, ArrayList.class, StringUtils.split((String)returnFilter, (String)",")));
        return copyValue;
    }

    private String analysisExpression(String expression, String account, String position, Date opTime, Object preObject, Object lastObject) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String opTimeValue = simpleDateFormat.format(opTime);
        String expressionResult = null;
        expressionResult = StringUtils.replace((String)expression, (String)"{user}", (String)account);
        expressionResult = StringUtils.replace((String)expressionResult, (String)"{position}", (String)position);
        expressionResult = StringUtils.replace((String)expressionResult, (String)"{time}", (String)opTimeValue);
        Matcher preMatcher = Pattern.compile("\\{pre\\.\\w*\\}").matcher(expression);
        Matcher lastMatcher = Pattern.compile("\\{last\\.\\w*\\}").matcher(expression);
        while (preMatcher.find()) {
            String preIncludeExpression;
            String preExpression = (preIncludeExpression = preMatcher.group()).replace("{pre.", "").replace("}", "");
            Object preExpressionValue = this.analysisValueByField(preObject, preExpression);
            expressionResult = StringUtils.replace((String)expressionResult, (String)preIncludeExpression, (String)(preExpressionValue == null ? "null" : preExpressionValue.toString()));
        }
        while (lastMatcher.find()) {
            String lastIncludeExpression;
            String lastExpression = (lastIncludeExpression = lastMatcher.group()).replace("{last.", "").replace("}", "");
            Object lastExpressionValue = this.analysisValueByField(lastObject, lastExpression);
            expressionResult = StringUtils.replace((String)expressionResult, (String)lastIncludeExpression, (String)(lastExpressionValue == null ? "null" : lastExpressionValue.toString()));
        }
        return expressionResult;
    }

    private Object analysisValueByField(Object currentObject, String fieldNames) {
        if (currentObject == null) {
            return null;
        }
        return this.analysisValueByField(currentObject, StringUtils.split((String)fieldNames, (String)"."), 0);
    }

    private Object analysisValueByField(Object currentObject, String[] fieldNames, int index) {
        InvokeParams invokeParams;
        JSONObject jsonData;
        Validate.isTrue((index < fieldNames.length ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5c5e\u6027\u987a\u5e8f\u7d22\u5f15\u4f4d\u7f6e!!", (Object[])new Object[0]);
        String currentFieldName = fieldNames[index];
        Class<?> currentObjectClass = currentObject.getClass();
        Validate.isTrue((!Collection.class.isAssignableFrom(currentObjectClass) ? 1 : 0) != 0, (String)"\u8868\u5355\u5f0f\u4e2d\u7684\u5bf9\u8c61\u63cf\u8ff0\u4e0d\u652f\u6301\u201c\u96c6\u5408\u201d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (currentObject instanceof InvokeParams && (jsonData = (invokeParams = (InvokeParams)currentObject).getJsonData()) != null) {
            return jsonData.get((Object)"id");
        }
        if (this.baseForProperty(currentObject.getClass())) {
            return currentObject;
        }
        Object currentValue = null;
        try {
            char[] chars = currentFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            Method getMethod = currentObjectClass.getMethod("get" + String.valueOf(chars), new Class[0]);
            currentValue = getMethod.invoke(currentObject, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            LOGGER.error(e.getMessage());
            throw new IllegalArgumentException(e.getMessage());
        }
        if (index == fieldNames.length - 1 || currentValue == null) {
            return currentValue;
        }
        return this.analysisValueByField(currentValue, fieldNames, index + 1);
    }

    private boolean allowCopyObject(Class<?> objectClass) {
        if (objectClass.isPrimitive() || objectClass == Byte.class || objectClass == Short.class || objectClass == Integer.class || objectClass == Long.class || objectClass == Float.class || objectClass == Double.class || objectClass == Character.class || objectClass == Boolean.class || objectClass.isArray()) {
            return false;
        }
        if (CharSequence.class.isAssignableFrom(objectClass) || Date.class.isAssignableFrom(objectClass) || Temporal.class.isAssignableFrom(objectClass) || objectClass.isEnum() || JSON.class.isAssignableFrom(objectClass)) {
            return false;
        }
        String fieldTypeName = objectClass.getName();
        return !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.lang.") && !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.math.") && !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.io.") && !StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.text.");
    }

    private boolean baseForProperty(Class<?> fieldItemClass) {
        if (fieldItemClass.isPrimitive() || fieldItemClass == Byte.TYPE || fieldItemClass == Short.TYPE || fieldItemClass == Integer.TYPE || fieldItemClass == Long.TYPE || fieldItemClass == Float.TYPE || fieldItemClass == Double.TYPE || fieldItemClass == Character.TYPE || fieldItemClass == Boolean.TYPE || fieldItemClass == Byte.class || fieldItemClass == Short.class || fieldItemClass == Integer.class || fieldItemClass == Long.class || fieldItemClass == Float.class || fieldItemClass == Double.class || fieldItemClass == Character.class || fieldItemClass == Boolean.class) {
            return true;
        }
        String fieldTypeName = fieldItemClass.getName();
        if ((StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"javax.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"org.springframework.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"org.apache.")) && !Iterable.class.isAssignableFrom(fieldItemClass)) {
            return true;
        }
        return JSON.class.isAssignableFrom(fieldItemClass);
    }

    private static class Rethrower {
        private Rethrower() {
        }

        public static void rethrow(Throwable exception) {
            class CheckedExceptionRethrower<T extends Throwable> {
                CheckedExceptionRethrower() {
                }

                private void rethrow(Throwable exception) throws T {
                    throw exception;
                }
            }
            new CheckedExceptionRethrower().rethrow(exception);
        }
    }
}

