/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.bizunited.platform.core.entity.log.LoggerInfoEntity;
import com.bizunited.platform.core.service.LoggerInfoEntityService;
import com.bizunited.platform.core.service.log.LoggerHandler;
import com.bizunited.platform.core.service.log.aspect.NebulaLoggerHandle;
import com.bizunited.platform.core.service.log.pojo.LoggerNotifyPojo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class LoggerHandleRunnable
implements LoggerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaLoggerHandle.class);
    private static final String SPECIAL_EXPRESSION = "$[?(@.id = '";
    private LoggerNotifyPojo loggerNotifyPojo;
    private String opAccount;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    @Lazy
    private LoggerInfoEntityService loggerInfoService;

    @Override
    public void run() {
        Object preObject = this.loggerNotifyPojo.getPreObject();
        Object lastObject = this.loggerNotifyPojo.getLastObject();
        String type = this.loggerNotifyPojo.getType();
        String module = this.loggerNotifyPojo.getModule();
        LoggerInfoEntity loggerInfo = new LoggerInfoEntity();
        loggerInfo.setAccount(this.loggerNotifyPojo.getAccount());
        loggerInfo.setPosition(this.loggerNotifyPojo.getPosition());
        loggerInfo.setModule(module);
        loggerInfo.setType(type);
        loggerInfo.setMsg(this.loggerNotifyPojo.getMsg());
        loggerInfo.setOpId(this.loggerNotifyPojo.getOpId());
        loggerInfo.setOpTime(this.loggerNotifyPojo.getOpTime());
        loggerInfo.setCreateAccount(this.opAccount);
        if (this.loggerNotifyPojo.getCompare().booleanValue()) {
            this.doCompare(loggerInfo, preObject, lastObject, module, this.loggerNotifyPojo.getOpId());
        }
        this.loggerInfoService.create(loggerInfo);
    }

    private void doCompare(LoggerInfoEntity loggerInfo, Object preObject, Object lastObject, String module, Object pkValue) {
        JSONArray compareResults;
        JSONObject preJsonObject = null;
        if (preObject != null) {
            preJsonObject = (JSONObject)JSONObject.toJSON((Object)preObject);
        }
        Class<?> c = lastObject.getClass();
        Field[] fs = c.getDeclaredFields();
        try {
            for (Field f : fs) {
                f.setAccessible(true);
                Object o = f.get(lastObject);
                if (!(o instanceof Date)) continue;
                f.set(lastObject, new Timestamp(((Date)o).getTime()));
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        JSONObject lastJsonObject = null;
        if (lastObject != null) {
            lastJsonObject = (JSONObject)JSONObject.toJSON((Object)lastObject);
        }
        if ((compareResults = LoggerHandleRunnable.analysisProperties(preJsonObject, lastJsonObject)) == null) {
            compareResults = new JSONArray();
        }
        byte[] contents = null;
        try {
            contents = compareResults.toJSONString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        String fileName = StringUtils.join((Object[])new Object[]{"_op_log_", module, "_", pkValue, ".txt"});
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/oplog/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        this.venusFileService.saveFile(relativePath, fileName, fileName, contents);
        loggerInfo.setRelativePath(relativePath);
        loggerInfo.setFileName(fileName);
    }

    private static JSONArray analysisProperties(JSONObject preObject, JSONObject lastObject) {
        Set lastEntris;
        Set lastProperties;
        Set lastKeys;
        Set preEntris = preObject == null ? new HashSet() : preObject.entrySet();
        Set preProperties = preEntris.stream().filter(item -> {
            Object value = item.getValue();
            return value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray);
        }).collect(Collectors.toSet());
        Set preKeys = preProperties.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        if (preKeys == null) {
            preKeys = new HashSet();
        }
        if ((lastKeys = (lastProperties = (lastEntris = lastObject == null ? new HashSet() : lastObject.entrySet()).stream().filter(item -> {
            Object value = item.getValue();
            return value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray);
        }).collect(Collectors.toSet())).stream().map(Map.Entry::getKey).collect(Collectors.toSet())) == null) {
            lastKeys = new HashSet();
        }
        JSONArray properties = new JSONArray();
        Sets.SetView createKeys = Sets.difference(lastKeys, preKeys);
        for (Object createKey : createKeys) {
            JSONObject createProperty = new JSONObject();
            Object createPropertyValue = lastObject.get(createKey);
            createProperty.put("name", createKey);
            createProperty.put("changeType", (Object)"ADD");
            createProperty.put("beforeValue", null);
            createProperty.put("afterValue", (Object)(createPropertyValue == null ? null : createPropertyValue.toString()));
            properties.add((Object)createProperty);
        }
        Sets.SetView deleteKeys = Sets.difference(preKeys, lastKeys);
        for (Object deleteKey : deleteKeys) {
            JSONObject deleteProperty = new JSONObject();
            Object deletePropertyValue = preObject.get(deleteKey);
            deleteProperty.put("name", deleteKey);
            deleteProperty.put("changeType", (Object)"DELETE");
            deleteProperty.put("beforeValue", (Object)(deletePropertyValue == null ? null : deletePropertyValue.toString()));
            deleteProperty.put("afterValue", null);
            properties.add((Object)deleteProperty);
        }
        Sets.SetView maybeModifyKeys = Sets.intersection(preKeys, lastKeys);
        for (String maybeModifyKey : maybeModifyKeys) {
            Object lastValue;
            String preValue = preObject == null ? null : preObject.getString(maybeModifyKey);
            if (StringUtils.equals((CharSequence)preValue, (CharSequence)(lastValue = lastObject == null ? null : lastObject.getString(maybeModifyKey)))) continue;
            JSONObject modifyProperty = new JSONObject();
            modifyProperty.put("name", (Object)maybeModifyKey);
            modifyProperty.put("changeType", (Object)"MODIFY");
            modifyProperty.put("beforeValue", (Object)preValue);
            modifyProperty.put("afterValue", lastValue);
            properties.add((Object)modifyProperty);
        }
        Set preItems = preEntris.stream().filter(item -> {
            Object value = item.getValue();
            return value != null && value instanceof JSONObject;
        }).collect(Collectors.toSet());
        preKeys.clear();
        preKeys = preItems.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        Set lastItems = lastEntris.stream().filter(item -> {
            Object value = item.getValue();
            return value != null && value instanceof JSONObject;
        }).collect(Collectors.toSet());
        lastKeys.clear();
        lastKeys = lastItems.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        Sets.SetView createItemKeys = Sets.difference(lastKeys, preKeys);
        for (Object createItemKey : createItemKeys) {
            if (lastObject == null) continue;
            JSONObject createItem = new JSONObject();
            JSONObject createItemObject = lastObject.getJSONObject((String)createItemKey);
            if (createItemObject == null || createItemObject.getString("id") == null) continue;
            createItem.put("name", createItemKey);
            createItem.put("changeType", (Object)"ADD");
            createItem.put("values", (Object)LoggerHandleRunnable.analysisProperties(null, createItemObject));
            properties.add((Object)createItem);
        }
        Sets.SetView deleteItemKeys = Sets.difference(preKeys, lastKeys);
        for (Object deleteItemKey : deleteItemKeys) {
            if (preObject == null) continue;
            JSONObject deleteItem = new JSONObject();
            JSONObject deleteItemObject = preObject.getJSONObject((String)deleteItemKey);
            if (deleteItemObject == null || deleteItemObject.getString("id") == null) continue;
            deleteItem.put("name", deleteItemKey);
            deleteItem.put("changeType", (Object)"DELETE");
            deleteItem.put("beforeValue", null);
            deleteItem.put("values", (Object)LoggerHandleRunnable.analysisProperties(deleteItemObject, null));
            properties.add((Object)deleteItem);
        }
        Sets.SetView maybeModifyItemKeys = Sets.intersection(preKeys, lastKeys);
        for (String maybeModifyItemKey : maybeModifyItemKeys) {
            Object lastValue;
            JSONObject preValue = preObject == null ? new JSONObject() : preObject.getJSONObject(maybeModifyItemKey);
            Object object = lastValue = lastObject == null ? new JSONObject() : lastObject.getJSONObject(maybeModifyItemKey);
            if (StringUtils.equals((CharSequence)preValue.toJSONString(), (CharSequence)lastValue.toJSONString())) continue;
            JSONObject modifyProperty = new JSONObject();
            modifyProperty.put("name", (Object)maybeModifyItemKey);
            modifyProperty.put("changeType", (Object)"MODITY");
            modifyProperty.put("values", (Object)LoggerHandleRunnable.analysisProperties(preValue, (JSONObject)lastValue));
            properties.add((Object)modifyProperty);
        }
        Set preArrays = preEntris.stream().filter(item -> {
            Object value = item.getValue();
            return value != null && value instanceof JSONArray;
        }).collect(Collectors.toSet());
        preKeys.clear();
        preKeys = preArrays.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        Set lastArrays = lastEntris.stream().filter(item -> {
            Object value = item.getValue();
            return value != null && value instanceof JSONArray;
        }).collect(Collectors.toSet());
        lastKeys.clear();
        lastKeys = lastArrays.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        Sets.SetView createArrayKeys = Sets.difference(lastKeys, preKeys);
        for (Object createArrayKey : createArrayKeys) {
            if (lastObject == null) continue;
            JSONObject createItem = new JSONObject();
            JSONArray createItemObjects = lastObject.getJSONArray((String)createArrayKey);
            if (createItemObjects == null || CollectionUtils.isEmpty((Collection)createItemObjects)) continue;
            createItem.put("name", createArrayKey);
            createItem.put("changeType", (Object)"ADD");
            createItem.put("values", (Object)LoggerHandleRunnable.analysisArrays(new JSONArray(), createItemObjects));
            properties.add((Object)createItem);
        }
        Sets.SetView deleteArrayKeys = Sets.difference(preKeys, lastKeys);
        for (String deleteArrayKey : deleteArrayKeys) {
            if (preObject == null) continue;
            JSONObject deleteItem = new JSONObject();
            JSONArray deleteItemObjects = preObject.getJSONArray(deleteArrayKey);
            if (deleteItemObjects == null || CollectionUtils.isEmpty((Collection)deleteItemObjects)) continue;
            deleteItem.put("name", (Object)deleteArrayKey);
            deleteItem.put("changeType", (Object)"DELETE");
            deleteItem.put("values", (Object)LoggerHandleRunnable.analysisArrays(deleteItemObjects, new JSONArray()));
            properties.add((Object)deleteItem);
        }
        Sets.SetView maybeModifyArrayKeys = Sets.intersection(preKeys, lastKeys);
        for (String maybeModifyArrayKey : maybeModifyArrayKeys) {
            JSONArray lastValue;
            JSONArray preValue = preObject == null ? new JSONArray() : preObject.getJSONArray(maybeModifyArrayKey);
            JSONArray jSONArray = lastValue = lastObject == null ? new JSONArray() : lastObject.getJSONArray(maybeModifyArrayKey);
            if (StringUtils.equals((CharSequence)preValue.toJSONString(), (CharSequence)lastValue.toJSONString())) continue;
            JSONObject modifyProperty = new JSONObject();
            modifyProperty.put("name", (Object)maybeModifyArrayKey);
            modifyProperty.put("changeType", (Object)"MODITY");
            modifyProperty.put("values", (Object)LoggerHandleRunnable.analysisArrays(preValue, lastValue));
            properties.add((Object)modifyProperty);
        }
        return properties;
    }

    private static JSONArray analysisArrays(JSONArray beforeItems, JSONArray afterItems) {
        String id;
        HashSet beforeItemIdArrays = Sets.newHashSet();
        HashSet afterItemIdArrays = Sets.newHashSet();
        if (beforeItems != null) {
            Object beforeItemArrayValue = JSONPath.eval((Object)beforeItems, (String)"$['id']");
            JSONArray beforeItemArray = null;
            if (beforeItemArrayValue instanceof JSONArray) {
                beforeItemArray = (JSONArray)beforeItemArrayValue;
            }
            HashSet hashSet = beforeItemIdArrays = beforeItemArray != null ? Sets.newHashSet((Object[])beforeItemArray.toArray(new Object[0])) : Sets.newHashSet();
        }
        if (afterItems != null) {
            Object afterItemArrayObject = JSONPath.eval((Object)afterItems, (String)"$['id']");
            JSONArray afterItemArray = null;
            if (afterItemArrayObject instanceof JSONArray) {
                afterItemArray = (JSONArray)afterItemArrayObject;
            }
            afterItemIdArrays = afterItemArray != null ? Sets.newHashSet((Object[])afterItemArray.toArray(new Object[0])) : Sets.newHashSet();
        }
        Sets.SetView deleteIds = Sets.difference((Set)beforeItemIdArrays, (Set)afterItemIdArrays);
        LinkedHashSet deleteItems = Sets.newLinkedHashSet();
        if (deleteIds != null && !deleteIds.isEmpty()) {
            deleteIds.stream().forEach(itemId -> {
                JSONArray items = (JSONArray)JSONPath.eval((Object)beforeItems, (String)(SPECIAL_EXPRESSION + itemId + "')]"));
                deleteItems.add(items.getJSONObject(0));
            });
        }
        Sets.SetView newIds = Sets.difference((Set)afterItemIdArrays, (Set)beforeItemIdArrays);
        LinkedHashSet newItems = Sets.newLinkedHashSet();
        if (newIds != null && !newIds.isEmpty()) {
            newIds.stream().forEach(itemId -> {
                JSONArray items = (JSONArray)JSONPath.eval((Object)afterItems, (String)(SPECIAL_EXPRESSION + itemId + "')]"));
                newItems.add(items.getJSONObject(0));
            });
        }
        Sets.SetView updateIds = Sets.intersection((Set)afterItemIdArrays, (Set)beforeItemIdArrays);
        LinkedHashSet updateItems = Sets.newLinkedHashSet();
        if (updateIds != null && !updateIds.isEmpty()) {
            updateIds.stream().forEach(itemId -> {
                JSONArray items = (JSONArray)JSONPath.eval((Object)afterItems, (String)(SPECIAL_EXPRESSION + itemId + "')]"));
                updateItems.add(items.getJSONObject(0));
            });
        }
        JSONArray datas = new JSONArray();
        if (deleteItems != null && !deleteItems.isEmpty()) {
            for (JSONObject deleteItem : deleteItems) {
                JSONObject deleteChange = new JSONObject();
                id = deleteItem.getString("id");
                deleteChange.put("id", (Object)id);
                deleteChange.put("changeType", (Object)"DELETE");
                JSONArray deletePropertiesChanges = LoggerHandleRunnable.analysisProperties(deleteItem, new JSONObject());
                deleteChange.put("properties", (Object)deletePropertiesChanges);
                datas.add((Object)deleteChange);
            }
        }
        if (newItems != null && !newItems.isEmpty()) {
            for (JSONObject newItem : newItems) {
                JSONObject newChange = new JSONObject();
                id = newItem.getString("id");
                newChange.put("id", (Object)id);
                newChange.put("changeType", (Object)"NEW");
                JSONArray newPropertiesChanges = LoggerHandleRunnable.analysisProperties(new JSONObject(), newItem);
                newChange.put("properties", (Object)newPropertiesChanges);
                datas.add((Object)newChange);
            }
        }
        if (updateItems != null && !updateItems.isEmpty()) {
            for (JSONObject updateItem : updateItems) {
                JSONObject updateChange = new JSONObject();
                id = updateItem.getString("id");
                JSONArray beforeUpdateItems = (JSONArray)JSONPath.eval((Object)beforeItems, (String)(SPECIAL_EXPRESSION + id + "')]"));
                updateChange.put("id", (Object)id);
                updateChange.put("changeType", (Object)"MODIFY");
                JSONArray updatePropertiesChanges = LoggerHandleRunnable.analysisProperties(beforeUpdateItems.getJSONObject(0), updateItem);
                updateChange.put("properties", (Object)updatePropertiesChanges);
                if (CollectionUtils.isEmpty((Collection)updatePropertiesChanges)) continue;
                datas.add((Object)updateChange);
            }
        }
        return datas;
    }

    @Override
    public void setOpAccount(String opAccount) {
        this.opAccount = opAccount;
    }

    @Override
    public void setLoggerNotifyPojo(LoggerNotifyPojo loggerNotifyPojo) {
        this.loggerNotifyPojo = loggerNotifyPojo;
    }
}

