/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.serviceable.template.AbstractObjectValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.Principal;
import java.time.temporal.Temporal;
import java.util.Date;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ObjectDataValueMappingTemplate
extends AbstractObjectValueMappingTemplate {
    @Override
    public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
        Class<?> parameterType = parameter.getType();
        boolean isArray = parameterType.isArray();
        if (isArray) {
            return false;
        }
        ServiceMethodParam serviceMethodParam = parameter.getAnnotation(ServiceMethodParam.class);
        if (serviceMethodParam != null) {
            return false;
        }
        if (JSON.class.isAssignableFrom(parameterType)) {
            return false;
        }
        if (parameterType == InvokeProxyContext.class || parameterType == InvokeParams.class || Principal.class.isAssignableFrom(parameterType) || Pageable.class.isAssignableFrom(parameterType) || Date.class.isAssignableFrom(parameterType) || Number.class.isAssignableFrom(parameterType) || Temporal.class.isAssignableFrom(parameterType)) {
            return false;
        }
        return !parameterType.isPrimitive();
    }

    @Override
    public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams) {
        JSONObject jsonObject = invokeParams.getJsonData();
        if (jsonObject == null) {
            return null;
        }
        Class<?> parameterClass = parameter.getType();
        try {
            return this.mappingObject(jsonObject, parameterClass);
        }
        catch (RuntimeException e) {
            String[] megs = e.getMessage().split(",");
            throw new JSONException(String.format("\u3010%s\u3011\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", megs[megs.length - 2]));
        }
    }
}

