/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.serviceable.template.AbstractObjectValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.Principal;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ObjectDataValueParamMappingTemplate
extends AbstractObjectValueMappingTemplate {
    @Override
    public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
        Class<?> parameterType = parameter.getType();
        boolean isArray = parameterType.isArray();
        if (isArray) {
            return false;
        }
        ServiceMethodParam serviceMethodParam = parameter.getAnnotation(ServiceMethodParam.class);
        if (serviceMethodParam == null) {
            return false;
        }
        if (JSON.class.isAssignableFrom(parameterType)) {
            return false;
        }
        if (parameterType == InvokeProxyContext.class || parameterType == InvokeParams.class || Principal.class.isAssignableFrom(parameterType) || Pageable.class.isAssignableFrom(parameterType) || Date.class.isAssignableFrom(parameterType) || Number.class.isAssignableFrom(parameterType) || Temporal.class.isAssignableFrom(parameterType) || CharSequence.class.isAssignableFrom(parameterType)) {
            return false;
        }
        return !parameterType.isPrimitive();
    }

    @Override
    public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams) {
        Object values = invokeParams.getInvokeParam(parameterName);
        if (values == null) {
            return null;
        }
        if (!(values instanceof Map)) {
            return null;
        }
        Map mapping = (Map)values;
        JSONObject jsonObject = new JSONObject(mapping);
        Class<?> parameterClass = parameter.getType();
        return this.mappingObject(jsonObject, parameterClass);
    }
}

