/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.log.LoggerHandler;
import com.bizunited.platform.core.service.log.aspect.AnnotationLoggerAroundAdvice;
import com.bizunited.platform.core.service.log.aspect.AnnotationLoggerDynamicPointcut;
import com.bizunited.platform.core.service.log.internal.LoggerHandleRunnable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(value="LoggerConfig")
public class LoggerConfig {
    @Bean(value={"AnnotationLoggerAroundAdvice"})
    public AnnotationLoggerAroundAdvice getAnnotationLoggerAroundAdvice() {
        return new AnnotationLoggerAroundAdvice();
    }

    @Bean(value={"AnnotationLoggerDynamicPointcut"})
    public AnnotationLoggerDynamicPointcut getAnnotationLoggerDynamicPointcut() {
        return new AnnotationLoggerDynamicPointcut();
    }

    @Bean
    public DefaultPointcutAdvisor getDefaultPointcutAdvisor(@Qualifier(value="AnnotationLoggerAroundAdvice") AnnotationLoggerAroundAdvice methodLoggerAroundAdvice, @Qualifier(value="AnnotationLoggerDynamicPointcut") AnnotationLoggerDynamicPointcut annotationLoggerDynamicPointcut) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Pointcut)annotationLoggerDynamicPointcut, (Advice)methodLoggerAroundAdvice);
        return advisor;
    }

    @Bean(value={"loggerTaskExecutor"})
    public ThreadPoolExecutor taskExecutor() {
        ThreadPoolExecutor taskExecutor = new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        return taskExecutor;
    }

    @Bean
    @ConditionalOnMissingBean(value={LoggerHandler.class})
    @Scope(value="prototype")
    public LoggerHandleRunnable loggerHandleRunnable() {
        return new LoggerHandleRunnable();
    }
}

