/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.annotations.DynamicTaskService;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.service.DynamicTaskSchedulerService;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.scheduler.DynamicTaskNotifyMaster;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Configuration
@EnableAsync
@Component(value="_schedulerConfig")
public class SchedulerConfig
implements CommandLineRunner {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicTaskNotifyMaster dynamicTaskNotifyMaster;
    private ClassPool pool = ClassPool.getDefault();
    @Autowired
    private DynamicTaskSchedulerService dynamicTaskSchedulerService;
    @Value(value="${spring.application.name:default}")
    private String applicationName;

    @Bean(value={"platform_dynamicTaskScheduler"})
    public ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName("platform_dynamicTaskScheduler");
        scheduler.setDaemon(false);
        scheduler.setPoolSize(50);
        scheduler.setThreadFactory(this.getThreadFactory());
        scheduler.setThreadNamePrefix("platform_");
        return scheduler;
    }

    private ThreadFactory getThreadFactory() {
        ThreadFactory dynamicTaskSchedulerFactory = new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                ClassLoader classLoader = SchedulerConfig.this.applicationContext.getClassLoader();
                currentThread.setDaemon(false);
                currentThread.setName("dynamicTask_" + this.count.getAndIncrement());
                currentThread.setContextClassLoader(classLoader);
                return currentThread;
            }
        };
        return dynamicTaskSchedulerFactory;
    }

    public void run(String ... args) throws Exception {
        this.start();
    }

    private void start() throws Exception {
        String[] definitionNames = this.applicationContext.getBeanDefinitionNames();
        ArrayList currentScanTasks = Lists.newArrayList();
        for (String definitionName : definitionNames) {
            ArrayList nebulaServiceMethods = Lists.newArrayList();
            Class beanClass = this.applicationContext.getType(definitionName);
            String beanClassName = Objects.requireNonNull(beanClass).getName();
            if (beanClassName.contains("$")) {
                beanClassName = beanClassName.substring(0, beanClassName.indexOf("$"));
            }
            if (StringUtils.isBlank((CharSequence)beanClassName)) continue;
            CtClass beanCtClass = null;
            try {
                beanCtClass = this.pool.get(beanClassName);
            }
            catch (NotFoundException e) {
                continue;
            }
            Arrays.stream(beanCtClass.getDeclaredMethods()).filter(item -> item.hasAnnotation(DynamicTaskService.class)).forEach(nebulaServiceMethods::add);
            if (nebulaServiceMethods.isEmpty()) continue;
            currentScanTasks.addAll(this.analysisMethods(nebulaServiceMethods, definitionName));
        }
        this.dynamicTaskSchedulerService.updateExsitReflexTasks(currentScanTasks);
        this.dynamicTaskNotifyMaster.notifyMaster();
    }

    private List<DynamicTaskSchedulerEntity> analysisMethods(List<CtMethod> nebulaServiceMethods, String definitionName) throws ClassNotFoundException, NotFoundException {
        ArrayList currentScanTasks = Lists.newArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (CtMethod ctMethod : nebulaServiceMethods) {
            DynamicTaskService dynamicTaskService = (DynamicTaskService)ctMethod.getAnnotation(DynamicTaskService.class);
            if (dynamicTaskService == null) continue;
            String cornExpression = dynamicTaskService.cornExpression();
            String executePoint = dynamicTaskService.executePoint();
            String taskDesc = dynamicTaskService.taskDesc();
            String validityPoint = dynamicTaskService.validityPoint();
            boolean onlyOnce = dynamicTaskService.onlyOnce();
            String methodName = ctMethod.getName();
            String methodLongName = ctMethod.getLongName();
            CtClass[] parameterTypes = ctMethod.getParameterTypes();
            DynamicTaskSchedulerEntity currentTask = new DynamicTaskSchedulerEntity();
            Validate.isTrue((parameterTypes == null || parameterTypes.length == 0 || parameterTypes.length == 1 && parameterTypes[0] == this.pool.getCtClass(InvokeProxyContext.class.getName()) ? 1 : 0) != 0, (String)"\u4f7f\u7528DynamicTaskService\u6ce8\u89e3\u7684\u65b9\u6cd5\uff0c\u5fc5\u987b\u6258\u7ba1\u7ed9Spring\uff0c\u5e76\u4e14\u76ee\u524d\u53ea\u5141\u8bb8\u6ca1\u6709\u5165\u53c2\u6216\u8005\u5165\u53c2\u4e3acom.bizunited.platform.core.service.invoke.InvokeProxyContext\u7684\u65b9\u6cd5\uff0c\u8bf7\u68c0\u67e5%s", (Object[])new Object[]{methodLongName});
            Validate.notBlank((CharSequence)taskDesc, (String)"\u57fa\u4e8eDynamicTaskService\u6ce8\u89e3\u7684\u5b9a\u65f6\u5668\u4efb\u52a1\u5e76\u6ca1\u6709\u8bf4\u660e\u5176\u4e1a\u52a1\u610f\u4e49\uff08expressionDesc\uff09\uff0c\u8bf7\u68c0\u67e5%s!", (Object[])new Object[]{methodLongName});
            if (onlyOnce) {
                if (!StringUtils.isBlank((CharSequence)executePoint)) {
                    Date executePointTime = null;
                    try {
                        executePointTime = dateFormat.parse(executePoint);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(String.format("\u4e00\u6b21\u6027\u5b9a\u65f6\u4efb\u52a1%s\u8bbe\u5b9a\u7684\u65e5\u671f\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
                    }
                    currentTask.setExecutePoint(executePointTime);
                    Date validityTime = DateUtils.addMinutes((Date)executePointTime, (int)60);
                    currentTask.setValidityTime(validityTime);
                } else if (!StringUtils.isBlank((CharSequence)cornExpression)) {
                    try {
                        new CronTrigger(cornExpression);
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(String.format("\u4e00\u6b21\u6027\u4efb\u52a1%s\u8bbe\u5b9a\u7684corn\u8868\u8fbe\u662f\u5b58\u5728\u683c\u5f0f\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
                    }
                    currentTask.setExecuteExpression(cornExpression);
                    currentTask.setExpressionDesc(cornExpression);
                } else {
                    throw new IllegalArgumentException(String.format("\u5f53\u4efb\u52a1\u662f\u4e00\u6b21\u6027\u6267\u884c\u4efb\u52a1\u65f6\uff0c\u8981\u4e48\u8bbe\u5b9acorn\u8868\u8fbe\u5f0f\uff08cornExpression\uff09\uff0c\u8981\u4e48\u8bbe\u5b9a\u786e\u5b9a\u7684\u6267\u884c\u65f6\u95f4\u70b9\uff08executePoint\uff09\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1%s", methodLongName));
                }
                currentTask.setTaskType(1);
            } else {
                if (!StringUtils.isBlank((CharSequence)cornExpression)) {
                    try {
                        new CronTrigger(cornExpression);
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(String.format("\u5468\u671f\u6027\u6267\u884c\u4efb\u52a1%s\u8bbe\u5b9a\u7684corn\u8868\u8fbe\u662f\u5b58\u5728\u683c\u5f0f\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
                    }
                } else {
                    throw new IllegalArgumentException(String.format("\u5f53\u4efb\u52a1\u662f\u5468\u671f\u6027\u6267\u884c\u4efb\u52a1\u65f6\uff0c\u8981\u8bbe\u5b9acorn\u8868\u8fbe\u5f0f\uff08cornExpression\uff09\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1%s", methodLongName));
                }
                currentTask.setExecuteExpression(cornExpression);
                currentTask.setExpressionDesc(cornExpression);
                currentTask.setTaskType(2);
            }
            if (!StringUtils.isBlank((CharSequence)validityPoint)) {
                Date validityPointTime = null;
                try {
                    validityPointTime = dateFormat.parse(validityPoint);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("\u5b9a\u65f6\u4efb\u52a1%s\u8bbe\u5b9a\u7684\u5931\u6548\u65f6\u95f4\u65e5\u671f\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
                }
                currentTask.setValidityTime(validityPointTime);
            }
            currentTask.setTaskDesc(taskDesc);
            currentTask.setInvokeType(2);
            currentTask.setTaskCode(methodLongName);
            currentTask.setScriptName("");
            currentTask.setInvokeBeanName(definitionName);
            currentTask.setInvokeMethod(methodName);
            currentTask.setProxyContextParam(parameterTypes != null && parameterTypes.length == 1);
            currentTask.setApplicationName(this.applicationName);
            currentScanTasks.add(currentTask);
        }
        return currentScanTasks;
    }
}

