/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(entityManagerFactoryRef="entityManagerFactoryPrimary", transactionManagerRef="transactionManagerPrimary")
public class PrimaryJpaConfig
implements BeanFactoryAware {
    @Autowired
    private JpaProperties jpaProperties;
    @Autowired
    private HibernateProperties hibernateProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="primaryDataSource")
    private DruidDataSource primaryDataSource;
    private ConfigurableListableBeanFactory beanFactory;

    @Primary
    @Bean(name={"entityManager"})
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        EntityManager entityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.entityManagerFactoryPrimary(builder).getObject());
        return entityManager;
    }

    @Primary
    @Bean(name={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryPrimary(EntityManagerFactoryBuilder builder) {
        String[] entityPackages;
        Map dataSourceMap = this.applicationContext.getBeansOfType(DataSource.class);
        Validate.notEmpty((Map)dataSourceMap, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e\u6e90", (Object[])new Object[0]);
        int datasourceCount = dataSourceMap.size();
        if (datasourceCount > 1) {
            entityPackages = new String[]{"com.bizunited.platform.rbac.server.vo", "com.bizunited.platform.core.entity", "com.bizunited.platform.kuiper.entity", "com.bizunited.platform.kuiper.vo", "com.bizunited.platform.user.service.local.entity", "com.bizunited.platform.rbac.server.starter.entity", "com.bizunited.platform.titan.starter.entity", "com.bizunited.platform.dictionary.service.local.entity", "com.bizunited.platform.venus.service.local.entity", "com.bizunited.platform.mars.entity"};
        } else {
            List packages = EntityScanPackages.get((BeanFactory)this.beanFactory).getPackageNames();
            if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
            }
            entityPackages = StringUtils.toStringArray((Collection)packages);
        }
        return builder.dataSource((DataSource)this.primaryDataSource).properties(this.jpaProperties.getProperties()).properties(this.getVendorProperties()).packages(entityPackages).persistenceUnit("primaryPersistenceUnit").build();
    }

    private Map<String, ?> getVendorProperties() {
        return this.hibernateProperties.determineHibernateProperties(this.jpaProperties.getProperties(), new HibernateSettings());
    }

    @Primary
    @Bean(name={"transactionManager"})
    public PlatformTransactionManager transactionManagerPrimary(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(this.entityManagerFactoryPrimary(builder).getObject());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

