/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.MigrateExportEntity;
import com.bizunited.platform.core.service.migrate.MigrateExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="MigrateExportController")
@RestController
@RequestMapping(value={"/v1/nebula/migrateExports"})
public class MigrateExportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportController.class);
    @Autowired
    private MigrateExportService migrateExportService;

    @GetMapping(value={"findDetailsByDataType"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u7c7b\u578b\u67e5\u8be2\u5bfc\u51fa\u65e5\u5fd7")
    public ResponseModel findDetailsByDataType(Integer dataType) {
        try {
            List<MigrateExportEntity> exports = this.migrateExportService.findDetailsByDataType(dataType);
            return this.buildHttpResultW(exports, new String[]{"createUser"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"exportDataView"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u89c6\u56fe\u7684\u8bbe\u8ba1\u6a21\u578b", notes="\u4f20\u5165\u5bfc\u51fa\u7684\u6570\u636eID\u5219\u6309\u7167\u4f20\u5165\u7684\u6570\u636eID\u6765\u5bfc\u51fa\uff0c\u5426\u5219\u5bfc\u51fa\u5168\u90e8")
    public void exportDataView(@RequestParam(required=false) @ApiParam(value="\u7b5b\u9009\u7684\u6570\u636eID") String[] ids, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportDataView(ids);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u6570\u636e\u89c6\u56fe-", time, ".", "zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @GetMapping(value={"exportRemoteService"})
    @ApiOperation(value="\u5bfc\u51fa\u8fdc\u7aef\u8c03\u7528\u7684\u8bbe\u8ba1\u6a21\u578b", notes="\u4f20\u5165\u5bfc\u51fa\u7684\u6570\u636eID\u5219\u6309\u7167\u4f20\u5165\u7684\u6570\u636eID\u6765\u5bfc\u51fa\uff0c\u5426\u5219\u5bfc\u51fa\u5168\u90e8")
    public void exportRemoteService(@RequestParam(required=false) @ApiParam(value="\u7b5b\u9009\u7684\u6570\u636eID") String[] ids, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportRemoteService(ids);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u8fdc\u7aef\u5730\u5740-", time, ".", "zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u7f16\u53f7\u7684\u4e1a\u52a1\u7f16\u7801", notes="\u4f20\u5165\u5bfc\u51fa\u7684\u6570\u636eID\u5219\u6309\u7167\u4f20\u5165\u7684\u6570\u636eID\u6765\u5bfc\u51fa\uff0c\u5426\u5219\u5bfc\u51fa\u5168\u90e8")
    @GetMapping(value={"/exportCodeRule"})
    public void exportCodeRule(@RequestParam(required=false) @ApiParam(value="\u7b5b\u9009\u7684\u6570\u636eID") String[] codeRuleIds, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportCodeRule(codeRuleIds);
            Validate.isTrue((bytes != null && bytes.length != 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u7f16\u7801\u89c4\u5219-", time, ".zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u7f16\u53f7\u7684\u5168\u5c40\u53d8\u91cf", notes="\u4f20\u5165\u5bfc\u51fa\u7684\u6570\u636eID\u5219\u6309\u7167\u4f20\u5165\u7684\u6570\u636eID\u6765\u5bfc\u51fa\uff0c\u5426\u5219\u5bfc\u51fa\u5168\u90e8")
    @GetMapping(value={"/exportEnv"})
    public void exportEnv(@RequestParam(required=false) @ApiParam(value="\u7b5b\u9009\u7684\u6570\u636eID") String[] envIds, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportEnv(envIds);
            Validate.isTrue((bytes != null && bytes.length != 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u5168\u5c40\u53c2\u6570-", time, ".zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }
}

