/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ServicableMethodController", tags={"\u5411\u5916\u754c\u66b4\u9732\u7684\u670d\u52a1\u6e90\u63a5\u53e3\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/nebula/servicableMethods"})
public class ServicableMethodController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicableMethodController.class);
    @Autowired
    private ServicableMethodService servicableMethodService;

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u53ef\u7528\u670d\u52a1\u6e90\u5217\u8868\uff0c\u652f\u6301\u5206\u9875\u4f46\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(name="name", value="\u53ef\u80fd\u7684\u670d\u52a1\u6e90\u6807\u8bc6\u540d\u79f0", required=false) @RequestParam(required=false, name="name") String name, @ApiParam(name="description", value="\u65b9\u6cd5\u4e2d\u6587\u63cf\u8ff0\uff08\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09", required=false) @RequestParam(required=false, name="description") String description, @ApiParam(name="interfaceName", value="\u53ef\u80fd\u7684\u670d\u52a1\u6e90\u5b8c\u6574\u63a5\u53e3\u7c7b\u540d\u67e5\u8be2\u6761\u4ef6", required=false) @RequestParam(required=false, name="interfaceName") String interfaceName, @ApiParam(name="simpleMethodName", value="\u53ef\u80fd\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d\u7b80\u79f0\u67e5\u8be2\u6761\u4ef6", required=false) @RequestParam(required=false, name="simpleMethodName") String simpleMethodName, @ApiParam(name="returnClassName", value="\u53ef\u80fd\u7684\u8fd4\u56declassname\uff08\u5168\u540d\uff09\u4f5c\u4e3a\u67e5\u8be2\u6761\u4ef6", required=false) @RequestParam(required=false, name="returnClassName") String returnClassName, @ApiParam(name="usedScope", value="\u670d\u52a1\u6e90\u65b9\u6cd5\u7684\u5e94\u7528\u8303\u56f4\uff1a\u76ee\u524d\u652f\u6301\uff1a\u8bfb\u64cd\u4f5c(READ)\uff0c\u5199\u64cd\u4f5c(WRITE)", required=false) @RequestParam(required=false, value="usedScope") String usedScope, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<JSONObject> page = this.servicableMethodService.findByConditions(pageable, name, description, interfaceName, simpleMethodName, returnClassName, usedScope);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6240\u66b4\u9732\u7684\u670d\u52a1\u6e90\uff0c\u7528\u52a8\u6001\u4ee3\u7406\u7684\u65b9\u5f0f\u8c03\u7528\u63a5\u53e3\uff0c\u8be5\u529f\u80fd\u4f1a\u4f7f\u7528\u7f13\u5b58\u673a\u5236", notes="\u8be5\u65b9\u6cd5\u5fc5\u987b\u5305\u542bserviceName\u7684\u503c\uff0c\u4ee5\u53ca\u975e\u5fc5\u586b\u53c2\u6570dataAuthCode\uff08\u6570\u636e\u6743\u9650\u7f16\u7801\uff09\u3002model\u53c2\u6570\u5305\u542b4\u90e8\u5206\uff1aserviceName\u670d\u52a1\u540d(\u5fc5\u4f20)\uff0cparams\u662fk-v\u7ed3\u6784\u7684\uff0ccustomData\u4e5f\u662fk-v\u7ed3\u6784\uff0cformData\u662f\u8868\u5355\u6570\u636e\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="model", value="\u5c01\u88c5\u7684\u4f20\u5165\u53c2\u6570\uff08serviceName\u5fc5\u4f20\uff09", required=true)})
    @PostMapping(value={"/servicableMethodInvoke"})
    public ResponseModel invoke(HttpServletRequest request, @RequestParam(value="serviceName") String serviceName, @RequestParam(name="dataAuthCode", required=false) String dataAuthCode, @RequestParam(name="competenceId", required=false) String competenceId, @RequestBody InvokeParams invokeParams) {
        InvokeParams currentInvokeParams = invokeParams;
        ServicableMethodInfo servicableMethodInfo = null;
        try {
            Validate.notBlank((CharSequence)serviceName, (String)"\u670d\u52a1\u6e90\u540d\u79f0serviceName\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            servicableMethodInfo = this.servicableMethodService.findDetailsByName(serviceName);
            Validate.notNull((Object)servicableMethodInfo, (String)"\u6839\u636e\u670d\u52a1\u540d%s\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u670d\u52a1\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{serviceName});
            if (currentInvokeParams == null) {
                currentInvokeParams = new InvokeParams();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
        Object result = null;
        try {
            Map parameterMaps = request.getParameterMap();
            if (parameterMaps != null) {
                Set parameterSets = parameterMaps.entrySet();
                for (Map.Entry parameterItem : parameterSets) {
                    String key = (String)parameterItem.getKey();
                    String[] values = (String[])parameterItem.getValue();
                    currentInvokeParams.putInvokeParam(key, values.length == 1 ? values[0] : values);
                }
            }
            result = StringUtils.isBlank((CharSequence)dataAuthCode) ? this.servicableMethodService.invoke(serviceName, competenceId, currentInvokeParams) : this.servicableMethodService.invoke(serviceName, dataAuthCode, currentInvokeParams);
            return this.wrapResult(result, servicableMethodInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u6e90\u8be6\u60c5", notes="\u8be5\u65b9\u6cd5\u5fc5\u987b\u5305\u542bserviceName\u7684\u503c\u3002")
    @GetMapping(value={"/findDetailsByName"})
    public ResponseModel findDetailsByName(@RequestParam(value="serviceName") String serviceName) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this.servicableMethodService.findDetailJsonByName(serviceName);
            return this.buildHttpResultW(jsonObject, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private ResponseModel wrapResult(Object result, ServicableMethodInfo servicableMethodInfo) {
        boolean doFilterB;
        if (result == null) {
            return this.buildHttpResult();
        }
        String returnPropertiesFilter = servicableMethodInfo.getReturnPropertiesFilter();
        String returnPropertiesFilterB = servicableMethodInfo.getReturnPropertiesFilterB();
        boolean doFilter = !StringUtils.equals((CharSequence)returnPropertiesFilter, (CharSequence)"_");
        boolean bl = doFilterB = !StringUtils.equals((CharSequence)returnPropertiesFilterB, (CharSequence)"_");
        if (!doFilter && !doFilterB) {
            if (Page.class.isAssignableFrom(result.getClass())) {
                Page yourPage = (Page)result;
                return this.buildHttpResultW(yourPage, new String[0]);
            }
            if (Iterable.class.isAssignableFrom(result.getClass())) {
                Iterable iterable = (Iterable)result;
                return this.buildHttpResultW(iterable, new String[0]);
            }
            return this.buildHttpResultW(result, new String[0]);
        }
        if (doFilter) {
            if (Page.class.isAssignableFrom(result.getClass())) {
                Page yourPage = (Page)result;
                return this.buildHttpResultW(yourPage, returnPropertiesFilter.split(","));
            }
            if (Iterable.class.isAssignableFrom(result.getClass())) {
                Iterable iterable = (Iterable)result;
                return this.buildHttpResultW(iterable, returnPropertiesFilter.split(","));
            }
            return this.buildHttpResultW(result, returnPropertiesFilter.split(","));
        }
        if (Page.class.isAssignableFrom(result.getClass())) {
            Page yourPage = (Page)result;
            return this.buildHttpResultB((Iterable)yourPage, returnPropertiesFilterB.split(","));
        }
        if (Iterable.class.isAssignableFrom(result.getClass())) {
            Iterable iterable = (Iterable)result;
            return this.buildHttpResultB(iterable, returnPropertiesFilterB.split(","));
        }
        return this.buildHttpResultB(result, returnPropertiesFilterB.split(","));
    }
}

