/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.core.entity.SystemThemeEntity;
import com.bizunited.platform.core.service.SystemThemeService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="SystemThemeController")
@RestController
@RequestMapping(value={"/v1/nebula/theme"})
public class SystemThemeController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemThemeController.class);
    private static final String LOCK_THEME = "theme";
    @Autowired
    private SystemThemeService systemThemeService;
    @Autowired
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406\u65f6\uff0c\u4e0a\u4f20logo\u5e76\u4fdd\u5b58(\u66f4\u65b0)\u4e3b\u9898")
    @RequestMapping(value={"/uploadLogo"}, method={RequestMethod.POST})
    public ResponseModel uploadLogo(@RequestParam(value="file") @ApiParam(name="file", value="\u6587\u4ef6\u5185\u5bb9") MultipartFile file) {
        try {
            Principal opUser = this.getPrincipal();
            OrdinaryFileVo theme = this.systemThemeService.uploadLogo(file, opUser);
            return this.buildHttpResultW(theme, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406\u65f6\uff0c\u4fdd\u5b58(\u66f4\u65b0)\u4e3b\u9898")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel save(@RequestBody @ApiParam(name="jsonTheme", value="\u7cfb\u7edf\u4e3b\u9898json\u683c\u5f0f\u6570\u636e") JSONObject jsonTheme) {
        try {
            this.redisMutexService.lock(LOCK_THEME);
            Principal opUser = this.getPrincipal();
            SystemThemeEntity theme = this.systemThemeService.save(jsonTheme, opUser);
            ResponseModel responseModel = this.buildHttpResultW((Object)theme, new String[0]);
            return responseModel;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = this.buildHttpResultForException(e);
            return responseModel;
        }
        finally {
            this.redisMutexService.unlock(LOCK_THEME);
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406\u65f6\uff0c\u6839\u636e\u7528\u6237\u4fe1\u606f\uff0c\u52a0\u8f7d\u4e3b\u9898")
    @RequestMapping(value={"/findTheme"}, method={RequestMethod.GET})
    public ResponseModel findTheme() {
        try {
            JSONObject theme = this.systemThemeService.findTheme();
            return this.buildHttpResultW(theme, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u4e3b\u9898\u4fe1\u606f")
    @GetMapping(value={"/export"})
    public void exportTheme(HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = this.systemThemeService.export();
            if (result == null || result.length == 0) {
                throw new IllegalArgumentException("\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!");
            }
            String fileName = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".zip"});
            this.writeResponseFile(request, response, result, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printErrorMessage(this.buildHttpResultForException(e), response);
        }
    }

    private void printErrorMessage(ResponseModel errorMessage, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(JSON.toJSONString((Object)errorMessage).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u4e3b\u9898\u4fe1\u606f")
    @PostMapping(value={"/import"})
    public ResponseModel importTheme(@RequestParam(name="file", required=true) @ApiParam(required=true, name="file", value="\u5bfc\u5165\u4e3b\u9898\u4fe1\u606f") MultipartFile file, Principal currentUser) {
        try {
            SystemThemeEntity entity = this.systemThemeService.importTheme(currentUser, file);
            return this.buildHttpResultW((Object)entity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

