/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.ExcelExportTemplate;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.vo.dataview.DataviewExportExcelFieldVo;
import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dataViews"})
public class DataViewController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewController.class);
    private static final String DATASOURCE_PARAM_NAME = "dataSource";
    private static final String GROUP_PARAM_NAME = "dataViewGroup";
    private static final String FIELDS_PARAM_NAME = "fields";
    private static final String FILTERS_PARAM_NAME = "filters";
    private static final String SYSTEM_PARAM_NAME = "systemFilters";
    private static final String[] FIELD_FILTERS = new String[]{"dataSource", "dataViewGroup", "fields", "filters", "systemFilters"};
    private static final String[] FIELD_FILTERS_F = new String[]{"dataSource", "dataViewGroup", "fields", "filters", "filters.field", "systemFilters"};
    @Autowired
    private DataViewService dataViewEntityService;
    @Autowired
    private ExcelExportTemplate excelExportTemplate;

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efadataViewEntity\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9dataViewEntity\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="dataViewEntity", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efadataViewEntity\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9dataViewEntity\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") DataViewEntity dataViewEntity) {
        try {
            DataViewEntity current = this.dataViewEntityService.create(dataViewEntity, false);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="dataViewEntity", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") DataViewEntity dataViewEntity) {
        try {
            DataViewEntity current = this.dataViewEntityService.update(dataViewEntity);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6e90code\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="dataSourceCode", value="\u6309\u7167\u6570\u636e\u6e90ID\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByDataSourceCode"}, method={RequestMethod.GET})
    public ResponseModel findByDataSourceCode(@RequestParam(required=false) @ApiParam(value="\u6570\u636e\u6e90code") String dataSourceCode) {
        try {
            JSONArray jsonArr = this.dataViewEntityService.findByDataSourceCode(dataSourceCode);
            return this.buildHttpResultW((Iterable)jsonArr, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6e90ID\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="dataSourceId", value="\u6309\u7167\u6570\u636e\u6e90ID\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByDataSource"}, method={RequestMethod.GET})
    public ResponseModel findByDataSource(@RequestParam(value="dataSourceId") @ApiParam(value="\u6570\u636e\u6e90ID") String dataSourceId) {
        try {
            List<DataViewEntity> result = this.dataViewEntityService.findByDataSource(dataSourceId);
            return this.buildHttpResultW(result, new String[]{DATASOURCE_PARAM_NAME});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u5e93\u5206\u7ec4\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="dataViewGroupId", value="\u6309\u7167\u6570\u636e\u5e93\u5206\u7ec4\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByDataViewGroup"}, method={RequestMethod.GET})
    public ResponseModel findByDataViewGroup(@RequestParam(value="dataViewGroupId") @ApiParam(value="\u6570\u636e\u5e93\u5206\u7ec4") String dataViewGroupId) {
        try {
            List<DataViewEntity> result = this.dataViewEntityService.findByDataViewGroup(dataViewGroupId);
            return this.buildHttpResultW(result, new String[]{GROUP_PARAM_NAME});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ed3\u6784\u5b57\u6bb5\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="filtersId", value="\u6309\u7167\u7ed3\u6784\u5b57\u6bb5\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByFields"}, method={RequestMethod.GET})
    public ResponseModel findByFields(@RequestParam(value="fieldsId") @ApiParam(value="\u7ed3\u6784\u5b57\u6bb5") String fieldsId) {
        try {
            DataViewEntity result = this.dataViewEntityService.findByFields(fieldsId);
            return this.buildHttpResultW((Object)result, new String[]{FIELDS_PARAM_NAME});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u8fc7\u6ee4\u7b5b\u9009\u5b57\u6bb5\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="filtersId", value="\u6309\u7167\u8fc7\u6ee4\u7b5b\u9009\u5b57\u6bb5\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByFilters"}, method={RequestMethod.GET})
    public ResponseModel findByFilters(@RequestParam(value="filtersId") @ApiParam(value="\u8fc7\u6ee4\u7b5b\u9009\u5b57\u6bb5") String filtersId) {
        try {
            DataViewEntity result = this.dataViewEntityService.findByFilters(filtersId);
            return this.buildHttpResultW((Object)result, new String[]{FILTERS_PARAM_NAME});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7cfb\u7edf\u67e5\u8be2\u5b57\u6bb5\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="systemFiltersId", value="\u6309\u7167\u7cfb\u7edf\u67e5\u8be2\u5b57\u6bb5\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findBySystemFilters"}, method={RequestMethod.GET})
    public ResponseModel findBySystemFilters(@RequestParam(value="systemFiltersId") @ApiParam(value="\u7cfb\u7edf\u67e5\u8be2\u5b57\u6bb5") String systemFiltersId) {
        try {
            DataViewEntity result = this.dataViewEntityService.findBySystemFilters(systemFiltersId);
            return this.buildHttpResultW((Object)result, new String[]{SYSTEM_PARAM_NAME});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u89c6\u56fe\u7684\u552f\u4e00\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u89c6\u56fe\u7684\u552f\u4e00\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") String code) {
        try {
            DataViewEntity result = this.dataViewEntityService.findDetailsByCode(code);
            return this.buildHttpResultW((Object)result, FIELD_FILTERS_F);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u8bed\u53e5\u8f93\u51fa\u5206\u6790")
    @RequestMapping(value={"/sqlAnalysis"}, method={RequestMethod.PATCH})
    public ResponseModel sqlAnalysis(@RequestParam(value="dataSourceCode") @ApiParam(value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801") String dataSourceCode, @RequestBody @ApiParam DataViewEntity dataView) {
        try {
            DataViewEntity result = this.dataViewEntityService.executeResource(dataSourceCode, dataView);
            return this.buildHttpResultW((Object)result, FIELD_FILTERS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e3b\u6570\u636e\u6e90\u8bed\u53e5\u8f93\u51fa\u5206\u6790")
    @RequestMapping(value={"/mainSqlAnalysis"}, method={RequestMethod.PATCH})
    public ResponseModel mainSqlAnalysis(@RequestBody @ApiParam DataViewEntity dataView) {
        try {
            DataViewEntity result = this.dataViewEntityService.executeResource(dataView);
            return this.buildHttpResultW((Object)result, FIELD_FILTERS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"executeQuery"})
    @ApiOperation(value="\u6267\u884c\u6570\u636e\u89c6\u56fe")
    public ResponseModel executeQuery(@RequestBody @ApiParam ExecuteParamModel executeParam) {
        try {
            List<JSONObject> list = this.dataViewEntityService.executeQuery(executeParam);
            return this.buildHttpResult(list);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"executePageQuery"})
    @ApiOperation(value="\u6267\u884c\u6570\u636e\u89c6\u56fe\u5206\u9875\u67e5\u8be2")
    public ResponseModel executePageQuery(@RequestBody @ApiParam ExecuteParamModel executeParam) {
        try {
            Page<JSONObject> page = this.dataViewEntityService.executePageQuery(executeParam);
            return this.buildHttpResult(page);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u5230excel")
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="executeParam") String executeParamJson, @RequestParam(value="exportExcelParams") String exportExcelParamsJson) {
        try {
            Principal principal = this.getPrincipal();
            ExecuteParamModel executeParam = null;
            if (StringUtils.isNotBlank((CharSequence)executeParamJson)) {
                executeParam = (ExecuteParamModel)JsonUtils.json2Obj((String)executeParamJson, ExecuteParamModel.class);
            }
            List excelFields = (List)JsonUtils.json2Obj((String)exportExcelParamsJson, (TypeReference)new TypeReference<List<DataviewExportExcelFieldVo>>(){});
            byte[] bytes = this.dataViewEntityService.exportExcel(executeParam, principal, excelFields);
            String fileName = this.excelExportTemplate.fileName(executeParam);
            fileName = StringUtils.join((Object[])new String[]{fileName, ".xlsx"});
            super.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u5c06\u67d0\u89c6\u56fe\u79fb\u52a8\u81f3\u65b0\u7684\u5206\u7ec4\u4e0b")
    @RequestMapping(value={"/moveGroup"}, method={RequestMethod.PATCH})
    public ResponseModel moveGroup(@RequestParam(value="dataViewId") @ApiParam(value="\u6570\u636e\u89c6\u56feID") String dataViewId, @RequestParam(value="dataViewGroupId") @ApiParam(value="\u79fb\u81f3\u5206\u7ec4ID") String dataViewGroupId) {
        try {
            this.dataViewEntityService.moveGroup(dataViewId, dataViewGroupId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findFieldsByCodeAndAuthCode"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89c6\u56fe\u548c\u6307\u5b9a\u6743\u9650\u9884\u8a00\u6267\u884c\u7ed3\u679c\u7684\u5b57\u6bb5", notes="\u6743\u9650\u7f16\u7801\u4e0d\u4f20\u6216\u4f20\u7a7a\u5219\u8fd4\u56de\u6570\u636e\u89c6\u56fe\u7684\u6240\u6709\u5b57\u6bb5")
    public ResponseModel findFieldsByCodeAndAuthCode(@RequestParam @ApiParam(value="\u6570\u636e\u89c6\u56fe\u7f16\u7801", required=true) String code, @RequestParam(required=false) @ApiParam(value="\u6743\u9650\u7f16\u7801") String authCode) {
        try {
            Set<String> fields = this.dataViewEntityService.findFieldsByCodeAndAuthCode(code, authCode);
            return this.buildHttpResultW(fields, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

