/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dauth;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u6570\u636e\u6743\u9650")
@RequestMapping(value={"/v1/nebula/dataAuths"})
public class DataAuthController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAuthController.class);
    private static final String[] WHITE_DETAILS = new String[]{"dataView", "horizontalAuths", "horizontalAuths.authRelations", "verticalAuths.authRelations.relation", "verticalAuths", "verticalAuths.authRelations", "horizontalAuths.authRelations.relation", "interceptors", "preAuths"};
    @Autowired
    private DataAuthService dataAuthService;
    @Autowired
    private ServicableMethodService servicableMethodService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u6743\u9650")
    public ResponseModel create(@RequestBody DataAuthEntity dataAuth) {
        try {
            DataAuthEntity result = this.dataAuthService.create(dataAuth);
            return this.buildHttpResultW((Object)result, WHITE_DETAILS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u6743\u9650")
    public ResponseModel update(@RequestBody DataAuthEntity dataAuth) {
        try {
            DataAuthEntity result = this.dataAuthService.update(dataAuth);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCode"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u7f16\u7801\u83b7\u53d6\u6743\u9650\u8be6\u60c5")
    public ResponseModel findDetailsByCode(@RequestParam @ApiParam(value="\u6743\u9650\u7f16\u7801") String code) {
        try {
            DataAuthEntity auth = this.dataAuthService.findDetailsByCode(code);
            return this.buildHttpResultW((Object)auth, WHITE_DETAILS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCodeWithServicable"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u7f16\u7801\u83b7\u53d6\u6743\u9650\u8be6\u60c5\uff08\u542b\u670d\u52a1\u6e90\u4fe1\u606f\uff09")
    public ResponseModel findDetailsByCodeWithServicable(@RequestParam @ApiParam(value="\u6743\u9650\u7f16\u7801") String code) {
        try {
            DataAuthEntity auth = this.dataAuthService.findDetailsByCode(code);
            ResponseModel responseModel = this.buildHttpResultW((Object)auth, WHITE_DETAILS);
            Object data = responseModel.getData();
            if (data == null) {
                return responseModel;
            }
            String jsonStr = JSONObject.toJSONString((Object)data);
            JSONObject jsonResult = JSONObject.parseObject((String)jsonStr);
            if (StringUtils.isNotBlank((CharSequence)auth.getSerivceableName())) {
                ServicableMethodInfo info = this.servicableMethodService.findDetailsByName(auth.getSerivceableName());
                jsonResult.put("returnClass", (Object)info.getReturnClass().getName());
                responseModel.setData((Object)jsonResult);
            }
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByDataView"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89c6\u56fe\u7f16\u7801\u83b7\u53d6\u6743\u9650")
    public ResponseModel findByDataViewCode(@RequestParam @ApiParam(value="\u6570\u636e\u89c6\u56fe\u7f16\u7801") String dataViewCode) {
        try {
            Set<DataAuthEntity> auths = this.dataAuthService.findByDataViewCode(dataViewCode);
            return this.buildHttpResultW(auths, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByServiceableName"})
    @ApiOperation(value="\u636e\u670d\u52a1\u6e90\u540d\u79f0\u83b7\u53d6\u6743\u9650")
    public ResponseModel findByServiceableName(@RequestParam @ApiParam(value="\u670d\u52a1\u6e90\u540d\u79f0") String serviceableName) {
        try {
            Set<DataAuthEntity> auths = this.dataAuthService.findByServiceableName(serviceableName);
            return this.buildHttpResultW(auths, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664")
    @DeleteMapping(value={"deleteById"})
    public ResponseModel deleteById(@RequestParam @ApiParam(value="\u4e3b\u952eID") String id) {
        try {
            this.dataAuthService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }
}

