/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dauth;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dataAuthPreRuleEntitys"})
public class DataAuthPreRuleEntityController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAuthPreRuleEntityController.class);
    @Autowired
    private DataAuthPreRuleEntityService dataAuthPreRuleEntityService;
    private static final String[] COMMON_PROPS = new String[]{"dataAuth", "preAuthItems", "preAuthItems.authType"};
    private static final String[] DETAILS_PROPS = new String[]{"dataAuth", "preAuthItems", "preAuthItems.authType", "preAuthItems.values"};

    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u6743\u9650\u524d\u7f6e\u89c4\u5219")
    @PostMapping(value={""})
    public ResponseModel save(@RequestParam(value="dataAuthCode") String dataAuthCode, @RequestBody @ApiParam(name="dataAuthPreRuleEntity", value="\u521b\u5efa\u6570\u636e\u6743\u9650\u524d\u7f6e\u89c4\u5219") Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        try {
            Set<DataAuthPreRuleEntity> current = this.dataAuthPreRuleEntityService.save(dataAuthCode, dataAuthPreRules);
            return this.buildHttpResultW(current, DETAILS_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167DataAuthPreRuleEntity\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            DataAuthPreRuleEntity result = this.dataAuthPreRuleEntityService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, COMMON_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167DataAuthPreRuleEntity\u5b9e\u4f53\u4e2d\u7684\uff08code\uff09\u7f16\u7801\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") @ApiParam(value="\u7f16\u7801code") String code) {
        try {
            DataAuthPreRuleEntity result = this.dataAuthPreRuleEntityService.findDetailsByCode(code);
            return this.buildHttpResultW((Object)result, COMMON_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167DataAuthPreRuleEntity\u5b9e\u4f53\u4e2d\u7684\uff08name\uff09\u524d\u7f6e\u89c4\u5219\u540d\u79f0\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findByNameAndAuthCode"}, method={RequestMethod.GET})
    public ResponseModel findByNameAndAuthCode(@RequestParam(value="name") @ApiParam(value="\u524d\u7f6e\u89c4\u5219\u540d\u79f0") String name, @RequestParam(value="authCode") @ApiParam(value="\u6570\u636e\u6743\u9650code") String authCode) {
        try {
            DataAuthPreRuleEntity result = this.dataAuthPreRuleEntityService.findByNameAndAuthCode(name, authCode);
            return this.buildHttpResultW((Object)result, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167DataAuthPreRuleEntity\u5b9e\u4f53\u4e2d\u7684\uff08code\uff09\u524d\u7f6e\u89c4\u5219code\u7f16\u7801\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(value="code") @ApiParam(value="\u524d\u7f6e\u89c4\u5219code\u7f16\u7801") String code) {
        try {
            DataAuthPreRuleEntity result = this.dataAuthPreRuleEntityService.findByCode(code);
            return this.buildHttpResultW((Object)result, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167DataAuthPreRuleEntity\u5b9e\u4f53\u4e2d\u7684\u6570\u636e\u6743\u9650\uff08code\uff09\u6570\u636e\u6743\u9650code\u7f16\u7801\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findByDataViewAuthCode"}, method={RequestMethod.GET})
    public ResponseModel findByDataAuthCode(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u6743\u9650code\u7f16\u7801") String code) {
        try {
            Set<DataAuthPreRuleEntity> results = this.dataAuthPreRuleEntityService.findByDataAuthCode(code);
            return this.buildHttpResultW(results, new String[]{"dataAuth"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167DataAuthPreRuleEntity\u5b9e\u4f53\u4e2d\u7684\u6570\u636e\u6743\u9650\uff08code\uff09\u6570\u636e\u6743\u9650code\u7f16\u7801\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findDetailsByDataViewAuthCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByDataAuthCode(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u6743\u9650code\u7f16\u7801") String code) {
        try {
            Set<DataAuthPreRuleEntity> results = this.dataAuthPreRuleEntityService.findDetailsByDataAuthCode(code);
            return this.buildHttpResultW(results, DETAILS_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

