/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dataAuthPrefabricate"})
public class DataAuthPrefabricateEntityController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAuthPrefabricateEntityController.class);
    private static final String[] COMMON_PORPS = new String[]{"authType"};
    @Autowired
    private DataAuthPrefabricateEntityService dataAuthPrefabricateEntityService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8fd4\u56de\u7c7b\u578b")
    @GetMapping(value={"/findDataType"})
    public ResponseModel findDataType(@ApiParam(name="\u9884\u5236\u503c\u7c7b\u578b") @RequestParam(value="type") Integer type, @ApiParam(name="\u9884\u5236\u503c\u503c") @RequestParam(value="value") String value) {
        try {
            String returnType = this.dataAuthPrefabricateEntityService.findDataType(type, value);
            return this.buildHttpResult(returnType);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u65b0\u5efa\u9884\u5236\u503c\u4fe1\u606f")
    @PostMapping(value={""})
    public ResponseModel create(@ApiParam(name="\u65b0\u5efa\u9884\u5236\u503c\u4fe1\u606f") @RequestParam String entityStr, @ApiParam(name="groovy\u811a\u672c") @RequestParam(required=false) String scriptContent) {
        try {
            DataAuthPrefabricateEntity entity = (DataAuthPrefabricateEntity)((Object)JSON.parseObject((String)entityStr, DataAuthPrefabricateEntity.class));
            DataAuthPrefabricateEntity result = this.dataAuthPrefabricateEntityService.create(entity, scriptContent);
            return this.buildHttpResultW((Object)result, COMMON_PORPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u9884\u5236\u503c\u4fe1\u606f")
    @PutMapping(value={""})
    public ResponseModel update(@ApiParam(name="\u66f4\u65b0\u9884\u5236\u503c\u4fe1\u606f") @RequestParam String entityStr, @ApiParam(name="groovy\u811a\u672c") @RequestParam(required=false) String scriptContent) {
        try {
            DataAuthPrefabricateEntity entity = (DataAuthPrefabricateEntity)((Object)JSON.parseObject((String)entityStr, DataAuthPrefabricateEntity.class));
            DataAuthPrefabricateEntity result = this.dataAuthPrefabricateEntityService.update(entity, scriptContent);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u9884\u5236\u503c\u4fe1\u606f")
    @DeleteMapping(value={""})
    public ResponseModel delete(@ApiParam(name="\u5220\u9664\u9884\u5236\u503c\u4fe1\u606f") @RequestParam(value="id") String id) {
        try {
            this.dataAuthPrefabricateEntityService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u72b6\u6001\u542f\u7528\u4e0e\u7981\u7528")
    @PutMapping(value={"/updateStatusById"})
    public ResponseModel updateStatusById(@ApiParam(name="\u66f4\u65b0\u72b6\u6001\u542f\u7528\u4e0e\u7981\u7528") @RequestParam(value="id") String id, @ApiParam(name="tstatus", value="\u72b6\u6001\u7b261\uff1a\u6b63\u5e38\uff1b0\uff1a\u7981\u7528/\u5e9f\u9664") @RequestParam(name="tstatus") Integer tstatus) {
        try {
            DataAuthPrefabricateEntity result = this.dataAuthPrefabricateEntityService.updateStatusById(id, tstatus);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u9884\u5236\u503c\u540d\u79f0\u67e5\u8be2\u4fe1\u606f\uff08\u6a21\u7cca\u67e5\u8be2\uff09\uff0c\u53ea\u663e\u793a\u6269\u5c55\u4fe1\u606f")
    @GetMapping(value={"/findByNameLikeOnlyExpand"})
    public ResponseModel findByNameLikeOnlyExpand(@ApiParam(name="\u6309\u9884\u5236\u503c\u540d\u79f0\u67e5\u8be2\u4fe1\u606f\uff08\u6a21\u7cca\u67e5\u8be2\uff09\uff0c\u53ea\u663e\u793a\u6269\u5c55\u4fe1\u606f") @RequestParam(value="name", required=false) String name) {
        try {
            List<DataAuthPrefabricateEntity> results = this.dataAuthPrefabricateEntityService.findByNameLikeOnlyExpand(name);
            return this.buildHttpResultW(results, COMMON_PORPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u5173\u8054\u79cd\u7c7bcode\u4fe1\u606f\u67e5\u8be2\u4fe1\u606f\uff0c\u53ea\u663e\u793a\u542f\u7528\u72b6\u6001\u7684\u4fe1\u606f")
    @GetMapping(value={"/findByAuthTypeCodeOnlyEnable"})
    public ResponseModel findByAuthTypeCodeOnlyEnable(@ApiParam(name="\u6309\u7167\u5173\u8054\u79cd\u7c7bcode\u4fe1\u606f\u67e5\u8be2\u4fe1\u606f\uff0c\u53ea\u663e\u793a\u542f\u7528\u72b6\u6001\u7684\u4fe1\u606f") @RequestParam(value="code") String code) {
        try {
            List<DataAuthPrefabricateEntity> results = this.dataAuthPrefabricateEntityService.findByAuthTypeCodeOnlyEnable(code);
            return this.buildHttpResultW(results, COMMON_PORPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6269\u5c55\u7684\u9884\u5236\u503c\u4fe1\u606f")
    @GetMapping(value={"/findPrefabricate"})
    public ResponseModel findByConditions(@ApiParam(name="name", value="\u6269\u5c55\u9884\u5236\u503c\u540d\u79f0", required=false) @RequestParam(required=false, name="name") String name, @ApiParam(name="code", value="\u6269\u5c55\u9884\u5236\u503c\u7f16\u53f7", required=false) @RequestParam(required=false, name="code") String code, @ApiParam(name="type", value="\u7c7b\u578b", required=false) @RequestParam(required=false, name="type") Integer type, @ApiParam(name="tstatus", value="\u72b6\u6001", required=false) @RequestParam(required=false, name="tstatus") Integer tstatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<DataAuthPrefabricateEntity> results = this.dataAuthPrefabricateEntityService.findByConditions(pageable, name, code, type, tstatus);
            return this.buildHttpResultW(results, COMMON_PORPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5185\u7f6e\u548c\u6269\u5c55\u7684\u9884\u5236\u503c\u4fe1\u606f")
    @GetMapping(value={"/findAll"})
    public ResponseModel findAll() {
        try {
            JSONArray result = this.dataAuthPrefabricateEntityService.findAll();
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5173\u8054\u79cd\u7c7binnerValue\uff0c\u83b7\u53d6\u5185\u7f6e\u9884\u5236\u503c\u4fe1\u606f")
    @GetMapping(value={"/findByAuthTypeInnerValue"})
    public ResponseModel findByAuthTypeInnerValue(@ApiParam(name="\u6839\u636e\u5173\u8054\u79cd\u7c7binnerValue\uff0c\u83b7\u53d6\u5185\u7f6e\u9884\u5236\u503c\u4fe1\u606f") @RequestParam(value="innerValue") Integer innerValue) {
        try {
            JSONArray result = this.dataAuthPrefabricateEntityService.findByAuthTypeInnerValue(innerValue);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u9884\u5236\u503cparamKey\u6807\u8bc6\uff0c\u83b7\u53d6\u6269\u5c55\u9884\u5236\u503c\u4fe1\u606f")
    @GetMapping(value={"/findByParamKey"})
    public ResponseModel findByParamKey(@ApiParam(name="\u6839\u636e\u9884\u5236\u503cparamKey\u6807\u8bc6\uff0c\u83b7\u53d6\u6269\u5c55\u9884\u5236\u503c\u4fe1\u606f") @RequestParam(value="paramKey") String paramKey) {
        try {
            JSONObject result = this.dataAuthPrefabricateEntityService.findByParamKey(paramKey);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

