/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.service.dataview.model.SortModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

class SQLOrderbyAnalysis {
    private SQLOrderbyAnalysis() {
        throw new IllegalStateException("\u9759\u6001\u7c7b\u4e0d\u80fd\u8fdb\u884c\u5b9e\u4f8b\u5316");
    }

    public static void buildOrderBy(ExecuteContextModel executeContext) {
        ExecuteParamModel executeParam = executeContext.getExecuteParam();
        SortModel sort = executeParam.getSort();
        if (sort == null) {
            return;
        }
        List<SortModel.OrderModel> orders = sort.getOrders();
        if (CollectionUtils.isEmpty(orders)) {
            return;
        }
        Set<DataViewFieldEntity> fields = executeContext.getDataViewFields();
        Validate.notNull(fields, (String)"\u6570\u636e\u89c6\u56fe\u7684\u5b57\u6bb5\u4e3a\u7a7a", (Object[])new Object[0]);
        Set fieldSet = fields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet());
        ArrayList<String> orderBys = new ArrayList<String>();
        String sqlAlias = executeContext.getWrapperSqlAlias();
        for (SortModel.OrderModel order : orders) {
            String property = order.getProperty();
            Validate.notBlank((CharSequence)property, (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)fieldSet.contains(property), (String)"\u672a\u627e\u5230\u6392\u5e8f\u5b57\u6bb5\uff1a%s", (Object[])new Object[]{property});
            Sort.Direction direction = order.getDirection();
            if (direction == null) {
                direction = Sort.Direction.ASC;
            }
            orderBys.add(String.format(" %s.%s %s ", sqlAlias, property, direction.name()));
        }
        String sorts = StringUtils.join(orderBys, (String)",");
        String orderBy = String.format(" order by %s ", sorts);
        executeContext.appendExecuteSql(orderBy);
    }
}

