/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.common.enums.ClassTypeNameEnum;
import com.bizunited.platform.core.repository.dataview.analysis.Constants;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class SqlParamFormater {
    private SqlParamFormater() {
        throw new IllegalStateException("\u9759\u6001\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static Object format(String paramType, Object value) {
        if (value == null) {
            return value;
        }
        if (StringUtils.isBlank((CharSequence)paramType)) {
            return SqlParamFormater.defaulFormat(value);
        }
        ClassTypeNameEnum classType = ClassTypeNameEnum.valueOfClassName((String)paramType);
        if (classType == null) {
            return SqlParamFormater.defaulFormat(value);
        }
        try {
            switch (classType) {
                case STRING: {
                    return value.toString();
                }
                case INT: 
                case INTEGER: {
                    if (value instanceof Integer) break;
                    return Integer.valueOf(value.toString());
                }
                case DOUBLE: 
                case DOUBLE_PACK: {
                    if (value instanceof Double) break;
                    return Double.valueOf(value.toString());
                }
                case FLOAT: 
                case FLOAT_PACK: {
                    if (value instanceof Float) break;
                    return Float.valueOf(value.toString());
                }
                case LONG: 
                case LONG_PACK: {
                    if (value instanceof Long) break;
                    return Long.valueOf(value.toString());
                }
                case SHORT: 
                case SHORT_PACK: {
                    if (value instanceof Short) break;
                    return Short.valueOf(value.toString());
                }
                case BYTE: 
                case BYTE_PACK: {
                    if (value instanceof Byte) break;
                    return Byte.valueOf(value.toString());
                }
                case BOOLEAN: 
                case BOOLEAN_PACK: {
                    if (value instanceof Boolean) break;
                    return Boolean.valueOf(value.toString());
                }
                case CHAR: 
                case CHAR_PACK: {
                    if (value instanceof Character) break;
                    return value.toString();
                }
                case DATE: {
                    if (Date.class.isAssignableFrom(value.getClass())) break;
                    return SqlParamFormater.formatDate(value);
                }
                case TIMESTAMP: {
                    if (value instanceof Timestamp) break;
                    return SqlParamFormater.formatDate(value);
                }
                case BIG_DECIMAL: {
                    if (BigDecimal.class.isAssignableFrom(value.getClass())) break;
                    return new BigDecimal(value.toString());
                }
            }
            return value;
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new NumberFormatException(String.format("\u4f20\u5165\u53c2\u6570\u9519\u8bef\uff1a\u3010%s\u3011", value));
        }
    }

    public static Object defaulFormat(Object value) {
        if (value == null) {
            return value;
        }
        String className = value.getClass().getName();
        if (!Constants.ALL_SUPPORT_CLASS.contains(className)) {
            return value.toString();
        }
        if (ClassTypeNameEnum.DATE.getClassName().equalsIgnoreCase(className)) {
            return SqlParamFormater.formatDate(value);
        }
        return value;
    }

    public static Object formatDate(Object value) {
        if (value == null) {
            return value;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        return value.toString();
    }
}

