/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.repository.internal.DynamicTaskSchedulerLogRepositoryCustom;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="DynamicTaskSchedulerLogRepositoryImpl")
public class DynamicTaskSchedulerLogRepositoryImpl
implements DynamicTaskSchedulerLogRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;
    private static final String TASK_ID = "taskId";
    private static final String SUCCESS = "success";

    @Override
    public Page<DynamicTaskSchedulerLogEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object logtime;
        String hql = "from DynamicTaskSchedulerLogEntity dtl inner join fetch dtl.dynamicTaskScheduler dt where 1 = 1";
        String countSql = "select count(*) from engine_dynamic_task_log dtl where 1 = 1";
        Object taskId = conditions.get(TASK_ID);
        Validate.notNull((Object)taskId, (String)"\u8fdb\u884c\u67e5\u8be2\u662f\uff0c\u4efb\u52a1id\u7f16\u53f7\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        hql = hql + " AND dtl.projectName=:projectName";
        countSql = countSql + " AND dtl.project_name=:projectName ";
        hql = hql + " AND dt.id = :taskId ";
        countSql = countSql + " AND dtl.dynamic_task = :taskId ";
        Object success = conditions.get(SUCCESS);
        if (success != null) {
            hql = hql + " AND dtl.success = :success ";
            countSql = countSql + " AND dtl.is_success = :success ";
        }
        if ((logtime = conditions.get("logtime")) != null) {
            hql = hql + " AND dtl.startTime >= :startTime AND dtl.startTime <= :endTime ";
            countSql = countSql + " AND dtl.start_time >= :startTime AND dtl.start_time <= :endTime ";
        }
        hql = hql + " order by dtl.startTime desc ";
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        query.setParameter(TASK_ID, taskId);
        countQuery.setParameter(TASK_ID, taskId);
        query.setParameter("projectName", (Object)this.platformContext.getAppName());
        countQuery.setParameter("projectName", (Object)this.platformContext.getAppName());
        if (success != null) {
            Boolean currentSuccess = Boolean.valueOf(success.toString());
            query.setParameter(SUCCESS, (Object)currentSuccess);
            countQuery.setParameter(SUCCESS, (Object)(Boolean.TRUE.equals(currentSuccess) ? 1 : 0));
        }
        if (logtime != null) {
            Date endTime;
            Date startTime;
            String logtimeValue = logtime.toString();
            String startTimeValue = StringUtils.join((Object[])new String[]{logtimeValue, " 00:00:00"});
            String endTimeValue = StringUtils.join((Object[])new String[]{logtimeValue, " 23:59:59"});
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                startTime = dataFormat.parse(startTimeValue);
                endTime = dataFormat.parse(endTimeValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
            query.setParameter("startTime", (Object)startTime);
            countQuery.setParameter("startTime", (Object)startTime);
            query.setParameter("endTime", (Object)endTime);
            countQuery.setParameter("endTime", (Object)endTime);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List results = query.getResultList();
        BigInteger count = (BigInteger)countQuery.getResultList().get(0);
        return new PageImpl(results, pageable, count.longValue());
    }
}

