/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.executor;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.enums.ClassTypeNameEnum;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.DataSourceTypeEnum;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.MysqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.OracleSqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.service.dauth.internal.DataAuthPreAuthDecisionService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataViewExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewExecutor.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private DataAuthPreAuthDecisionService dataAuthPreAuthDecisionService;
    @Autowired
    private DataAuthService dataAuthService;
    @Autowired
    private DynamicDataSourceManager dataSourceManager;
    @Autowired
    private EntityManager entityManager;

    public ExecuteContextModel buildContext(ExecuteParamModel executeParam) {
        Validate.notNull((Object)executeParam, (String)"\u6267\u884c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)executeParam.getDataViewCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewEntity dataView = this.dataViewService.findDetailsByCode(executeParam.getDataViewCode());
        Validate.notNull((Object)((Object)dataView), (String)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe\uff1a%s", (Object[])new Object[]{executeParam.getDataViewCode()});
        DataSourceEntity dataSource = dataView.getDataSource();
        DataSourceTypeEnum dataSourceType = this.getDataSourceType(dataSource, this.dataSourceProperties);
        SQLPresetValueAnalysis sqlPresetValueAnalysis = (SQLPresetValueAnalysis)this.applicationContext.getBean(SQLPresetValueAnalysis.class);
        DataAuthEntity auth = null;
        DataAuthPreRuleEntity preRule = null;
        ExecuteContextModel executeContext = new ExecuteContextModel();
        executeContext.setSession(executeParam.getSession());
        boolean hasAdmin = this.dataAuthPreAuthDecisionService.hasAdminRole();
        if (hasAdmin) {
            executeContext.setAdmin(true);
        }
        if (StringUtils.isNotBlank((CharSequence)executeParam.getAuthCode()) && !hasAdmin) {
            preRule = this.dataAuthPreAuthDecisionService.decision(executeParam.getAuthCode());
            auth = preRule == null ? this.dataAuthService.findDetailsByDataViewCodeAndAuthCode(dataView.getCode(), executeParam.getAuthCode()) : this.dataAuthService.findDetailsByDataViewCodeAndAuthCodeAndPreRule(dataView.getCode(), executeParam.getAuthCode(), preRule.getCode());
            Validate.notNull((Object)((Object)auth), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u6743\u9650:%s", (Object[])new Object[]{executeParam.getAuthCode()});
        }
        executeContext.setApplicationContext(this.applicationContext);
        executeContext.setExecuteParam(executeParam);
        executeContext.setDataView(dataView);
        executeContext.setPreRule(preRule);
        executeContext.setDataSourceType(dataSourceType);
        executeContext.setDataSource(dataSource);
        executeContext.setDataViewFields(dataView.getFields());
        executeContext.setSqlPresetValueAnalysis(sqlPresetValueAnalysis);
        executeContext.setWrapperSqlAlias("s01y01s01");
        executeContext.setDataViewFilters(dataView.getFilters());
        executeContext.setSystemFilters(dataView.getSystemFilters());
        executeContext.setDataAuth(auth);
        AbstractSqlAnalysis sqlAnalysis = this.getSqlAnalysis(dataSourceType);
        executeContext.setSqlAnalysis(sqlAnalysis);
        sqlAnalysis.analysis(executeContext);
        return executeContext;
    }

    private AbstractSqlAnalysis getSqlAnalysis(DataSourceTypeEnum dataSourceType) {
        if (dataSourceType.equals((Object)DataSourceTypeEnum.MYSQL)) {
            return (AbstractSqlAnalysis)ApplicationContextUtils.getApplicationContext().getBean(MysqlAnalysis.class);
        }
        if (dataSourceType.equals((Object)DataSourceTypeEnum.ORACLE)) {
            return (AbstractSqlAnalysis)ApplicationContextUtils.getApplicationContext().getBean(OracleSqlAnalysis.class);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
    }

    private DataSourceTypeEnum getDataSourceType(DataSourceEntity dataSource, DataSourceProperties dataSourceProperties) {
        if (dataSource == null) {
            DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.valueOfDriver(dataSourceProperties.getDriverClassName());
            Validate.notNull((Object)((Object)dataSourceTypeEnum), (String)String.format("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u9a71\u52a8\u7c7b\uff1a%s", dataSourceProperties.getDriverClassName()), (Object[])new Object[0]);
            return dataSourceTypeEnum;
        }
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.valueOfDatabase(dataSource.getType());
        Validate.notNull((Object)((Object)dataSourceTypeEnum), (String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (Object[])new Object[]{dataSource.getType()});
        return dataSourceTypeEnum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<JSONObject> executeQuery(ExecuteContextModel executeContext) {
        SessionFactory sessionFactory = this.getSessionFactory(executeContext);
        try (Connection conn = Objects.requireNonNull(SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory)).getConnection();){
            List<JSONObject> list = this.executeQuery(conn, executeContext.getExecuteSql(), executeContext.getExecuteSqlParameters());
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u6267\u884csql\u51fa\u9519\uff1a%s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page<JSONObject> executePageQuery(ExecuteContextModel executeContext) {
        PageableModel pageable = executeContext.getExecuteParam().getPageable();
        Validate.notNull((Object)pageable, (String)"\u672a\u627e\u5230\u5206\u9875\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570", (Object[])new Object[0]);
        SessionFactory sessionFactory = this.getSessionFactory(executeContext);
        try (Connection conn = Objects.requireNonNull(SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory)).getConnection();){
            List<JSONObject> resultList = this.executeQuery(conn, executeContext.getExecuteSql(), executeContext.getExecuteSqlParameters());
            List<JSONObject> countResult = this.executeQuery(conn, executeContext.getExecuteCountSql(), executeContext.getExecuteCountSqlParameters());
            long count = this.getCount(countResult);
            PageImpl pageImpl = new PageImpl(resultList, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize()), count);
            return pageImpl;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u6267\u884csql\u51fa\u9519\uff1a%s", e.getMessage()));
        }
    }

    private long getCount(List<JSONObject> countResult) {
        if (CollectionUtils.isEmpty(countResult)) {
            return 0L;
        }
        JSONObject jsonObject = countResult.get(0);
        Iterator iterator = jsonObject.keySet().iterator();
        return iterator.hasNext() ? jsonObject.getLongValue((String)iterator.next()) : 0L;
    }

    /*
     * Exception decompiling
     */
    private List<JSONObject> executeQuery(Connection conn, String sql, List<Object> parameters) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<JSONObject> getResultList(ResultSet resultSet) throws SQLException {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        while (resultSet.next()) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            JSONObject jsonObject = new JSONObject();
            for (int i = 1; i <= columnCount; ++i) {
                jsonObject.put(metaData.getColumnLabel(i), resultSet.getObject(i));
            }
            list.add(jsonObject);
        }
        return list;
    }

    private SessionFactory getSessionFactory(ExecuteContextModel executeContext) {
        if (executeContext.getSession() != null) {
            Session session = executeContext.getSession();
            return session.getSessionFactory();
        }
        if (executeContext.getDataSource() == null) {
            Session session = (Session)this.entityManager.getDelegate();
            return session.getSessionFactory();
        }
        SessionFactory sessionFactory = this.dataSourceManager.getCurrentSessionFactory(executeContext.getDataSource().getCode());
        if (sessionFactory == null) {
            throw new NullPointerException(String.format("\u672a\u627e\u5230\u6570\u636e\u6e90\uff1a%s", executeContext.getDataSource().getCode()));
        }
        return sessionFactory;
    }

    private void setStatementParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        block13: for (int i = 0; i < parameters.size(); ++i) {
            int index = i + 1;
            Object value = parameters.get(i);
            if (value == null) {
                preparedStatement.setObject(index, value);
                continue;
            }
            ClassTypeNameEnum classTypeName = ClassTypeNameEnum.valueOfClassName((String)value.getClass().getName());
            if (classTypeName == null) {
                preparedStatement.setObject(index, value);
                continue;
            }
            switch (classTypeName) {
                case STRING: {
                    preparedStatement.setString(index, value.toString());
                    continue block13;
                }
                case INT: 
                case INTEGER: {
                    preparedStatement.setInt(index, (Integer)value);
                    continue block13;
                }
                case DOUBLE: 
                case DOUBLE_PACK: {
                    preparedStatement.setDouble(index, (Double)value);
                    continue block13;
                }
                case FLOAT: 
                case FLOAT_PACK: {
                    preparedStatement.setFloat(index, ((Float)value).floatValue());
                    continue block13;
                }
                case LONG: 
                case LONG_PACK: {
                    preparedStatement.setLong(index, (Long)value);
                    continue block13;
                }
                case SHORT: 
                case SHORT_PACK: {
                    preparedStatement.setShort(index, (Short)value);
                    continue block13;
                }
                case BYTE: 
                case BYTE_PACK: {
                    preparedStatement.setByte(index, (Byte)value);
                    continue block13;
                }
                case BOOLEAN: 
                case BOOLEAN_PACK: {
                    preparedStatement.setBoolean(index, (Boolean)value);
                    continue block13;
                }
                case CHAR: 
                case CHAR_PACK: {
                    preparedStatement.setString(index, value.toString());
                    continue block13;
                }
                case DATE: {
                    Date date = (Date)value;
                    Timestamp timestamp = new Timestamp(date.getTime());
                    preparedStatement.setTimestamp(index, timestamp);
                    continue block13;
                }
                case BIG_DECIMAL: {
                    preparedStatement.setString(index, value.toString());
                    continue block13;
                }
                default: {
                    preparedStatement.setObject(index, value);
                }
            }
        }
    }
}

