/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.entity.dauth.DataAuthHorizontalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthHorizontalRelationEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthHorizontalRelationRepository;
import com.bizunited.platform.core.service.dataview.internal.DataViewAuthRelationService;
import com.bizunited.platform.core.service.dauth.DataAuthHorizontalRelationService;
import com.bizunited.platform.core.service.dauth.DataAuthHorizontalService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataAuthHorizontalRelationServiceImpl")
public class DataAuthHorizontalRelationServiceImpl
implements DataAuthHorizontalRelationService {
    @Autowired
    private DataAuthHorizontalRelationRepository dataAuthHorizontalRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DataAuthHorizontalService dataAuthHorizontalService;
    @Autowired
    private DataViewAuthRelationService dataViewAuthRelationService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public Set<DataAuthHorizontalRelationEntity> findDetailsByAuthHorizontal(String authHorizontal) {
        if (StringUtils.isBlank((CharSequence)authHorizontal)) {
            return Sets.newHashSet();
        }
        DataAuthHorizontalEntity horizontal = this.dataAuthHorizontalService.findById(authHorizontal);
        if (horizontal == null) {
            return Sets.newHashSet();
        }
        Set<DataAuthHorizontalRelationEntity> relations = this.dataAuthHorizontalRelationRepository.findDetailsByAuthHorizontal(authHorizontal);
        if (CollectionUtils.isEmpty(relations)) {
            return relations;
        }
        for (DataAuthHorizontalRelationEntity relation : relations) {
            UuidVo relationObj = this.dataViewAuthRelationService.findRelation(relation.getAuthRelationIds(), horizontal.getAuthType());
            relation.setRelation(relationObj);
        }
        return relations;
    }

    @Override
    public DataAuthHorizontalRelationEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthHorizontalRelationRepository.findDetailsById(id);
    }

    @Override
    public DataAuthHorizontalRelationEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthHorizontalRelationRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataAuthHorizontalRelationRepository.findById(id);
        op.ifPresent(dataAuthHorizontalRelationEntity -> this.dataAuthHorizontalRelationRepository.delete(dataAuthHorizontalRelationEntity));
    }

    @Override
    @Transactional
    public void deleteByAuthHorizontal(String authHorizontal) {
        Validate.notBlank((CharSequence)authHorizontal, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f!", (Object[])new Object[0]);
        this.dataAuthHorizontalRelationRepository.deleteByAuthHorizontal(authHorizontal);
    }

    @Override
    @Transactional
    public Set<DataAuthHorizontalRelationEntity> save(DataAuthHorizontalEntity authHorizontal, Set<DataAuthHorizontalRelationEntity> authRelations) {
        this.saveValidation(authHorizontal, authRelations);
        if (authRelations == null) {
            authRelations = Sets.newHashSet();
        }
        Map<String, DataAuthHorizontalRelationEntity> authRelationsMap = authRelations.stream().collect(Collectors.toMap(UuidEntity::getId, r -> r, (r1, r2) -> r1));
        Set<DataAuthHorizontalRelationEntity> dbAuthRelations = this.dataAuthHorizontalRelationRepository.findDetailsByAuthHorizontal(authHorizontal.getId());
        HashSet deletes = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet creates = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)authRelations, dbAuthRelations, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataAuthHorizontalRelationEntity delete : deletes) {
            this.dataAuthHorizontalRelationRepository.delete((Object)delete);
        }
        for (DataAuthHorizontalRelationEntity update : updates) {
            DataAuthHorizontalRelationEntity relation = authRelationsMap.get(update.getId());
            update.setAuthRelationIds(relation.getAuthRelationIds());
            update.setSortIndex(relation.getSortIndex());
            update.setProjectName(this.platformContext.getAppName());
            this.dataAuthHorizontalRelationRepository.save((Object)update);
        }
        for (DataAuthHorizontalRelationEntity create : creates) {
            create.setAuthHorizontal(authHorizontal);
            create.setProjectName(this.platformContext.getAppName());
            this.dataAuthHorizontalRelationRepository.save((Object)create);
        }
        updates.addAll(creates);
        return updates;
    }

    private void saveValidation(DataAuthHorizontalEntity authHorizontal, Set<DataAuthHorizontalRelationEntity> relations) {
        Validate.notNull((Object)((Object)authHorizontal), (String)"\u6a2a\u5411\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)authHorizontal.getId(), (String)"\u6a2a\u5411\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthHorizontalEntity horizontal = this.dataAuthHorizontalService.findById(authHorizontal.getId());
        Validate.notNull((Object)((Object)horizontal), (String)"\u672a\u627e\u5230\u6a2a\u5411\u6743\u9650\uff1a%s", (Object[])new Object[]{authHorizontal.getId()});
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        for (DataAuthHorizontalRelationEntity authRelation : relations) {
            Validate.notBlank((CharSequence)authRelation.getAuthRelationIds(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)authRelation.getSortIndex(), (String)"\u6743\u9650\u503c\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

