/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthHorizontalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthInterceptorEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalRelationEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthRepository;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dauth.DataAuthHorizontalService;
import com.bizunited.platform.core.service.dauth.DataAuthInterceptorService;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleEntityService;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.service.dauth.DataAuthVerticalService;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataAuthServiceImpl")
public class DataAuthServiceImpl
implements DataAuthService {
    @Autowired
    private DataAuthRepository dataAuthRepository;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private DataAuthVerticalService dataAuthVerticalService;
    @Autowired
    private DataAuthHorizontalService dataAuthHorizontalService;
    @Autowired
    private DataAuthInterceptorService dataAuthInterceptorService;
    @Autowired
    private DataAuthPreRuleEntityService dataAuthPreRuleEntityService;
    @Autowired
    private PlatformContext platformContext;
    @Autowired
    private ServicableMethodService servicableMethodService;

    @Override
    @Transactional
    public DataAuthEntity create(DataAuthEntity dataAuth) {
        this.createValidation(dataAuth);
        UserVo userVo = SecurityUtils.getCurrentUser();
        dataAuth.setCreateAccount(userVo.getAccount());
        dataAuth.setModifyAccount(userVo.getAccount());
        dataAuth.setCreateTime(new Date());
        dataAuth.setProjectName(this.platformContext.getAppName());
        return (DataAuthEntity)((Object)this.dataAuthRepository.save((Object)dataAuth));
    }

    private void createValidation(DataAuthEntity dataAuth) {
        Validate.notNull((Object)((Object)dataAuth), (String)"\u4f20\u5165\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dataAuth.getDataView() == null || !StringUtils.isNotBlank((CharSequence)dataAuth.getSerivceableName()) ? 1 : 0) != 0, (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u548c\u670d\u52a1\u6e90\u4e0d\u80fd\u540c\u65f6\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((dataAuth.getDataView() != null || StringUtils.isNotBlank((CharSequence)dataAuth.getSerivceableName()) ? 1 : 0) != 0, (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u6216\u670d\u52a1\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (dataAuth.getDataView() != null) {
            String dataViewId = dataAuth.getDataView().getId();
            Validate.notBlank((CharSequence)dataViewId, (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            DataViewEntity dataView = this.dataViewService.findById(dataViewId);
            Validate.notNull((Object)((Object)dataView), (String)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe:%s", (Object[])new Object[]{dataViewId});
        } else {
            ServicableMethodInfo servicableMethodInfo = this.servicableMethodService.findDetailsByName(dataAuth.getSerivceableName());
            Validate.notNull((Object)servicableMethodInfo, (String)"\u6839\u636e\u670d\u52a1\u540d%s\u672a\u80fd\u83b7\u53d6\u5230\u670d\u52a1\u6e90\u4fe1\u606f", (Object[])new Object[]{dataAuth.getSerivceableName()});
        }
        Validate.notBlank((CharSequence)dataAuth.getCode(), (String)"\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataAuth.getName(), (String)"\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataAuth.getId()), (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4f20\u5165ID", (Object[])new Object[0]);
        long count = this.dataAuthRepository.countByCode(dataAuth.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u6743\u9650\u7f16\u7801\uff1a%s", (Object[])new Object[]{dataAuth.getCode()});
    }

    private void updateValidation(DataAuthEntity dataAuth) {
        Validate.notNull((Object)((Object)dataAuth), (String)"\u4f20\u5165\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dataAuth.getDataView() == null || !StringUtils.isNotBlank((CharSequence)dataAuth.getSerivceableName()) ? 1 : 0) != 0, (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u548c\u670d\u52a1\u6e90\u4e0d\u80fd\u540c\u65f6\u6709\u503c", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataAuth.getCode(), (String)"\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataAuth.getName(), (String)"\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataAuth.getId(), (String)"\u66f4\u65b0\u6570\u636e\u5fc5\u987b\u4f20\u5165ID", (Object[])new Object[0]);
        long count = this.dataAuthRepository.countByCodeExcludeId(dataAuth.getCode(), dataAuth.getId());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u6743\u9650\u7f16\u7801\uff1a%s", (Object[])new Object[]{dataAuth.getCode()});
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"dataAuth"}, allEntries=true)
    public DataAuthEntity update(DataAuthEntity dataAuth) {
        this.updateValidation(dataAuth);
        DataAuthEntity dbAuth = this.dataAuthRepository.findById(dataAuth.getId()).orElse(null);
        Validate.notNull((Object)((Object)dbAuth), (String)"\u66f4\u65b0\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((dbAuth.getDataView() != null || StringUtils.isNotBlank((CharSequence)dbAuth.getSerivceableName()) ? 1 : 0) != 0, (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u6216\u670d\u52a1\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dbAuth.setCode(dataAuth.getCode());
        dbAuth.setName(dataAuth.getName());
        dbAuth.setProjectName(this.platformContext.getAppName());
        return (DataAuthEntity)((Object)this.dataAuthRepository.save((Object)dbAuth));
    }

    @Override
    public DataAuthEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthRepository.findById(id).orElse(null);
    }

    @Override
    public DataAuthEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        DataAuthEntity auth = this.dataAuthRepository.findDetailsByCode(code);
        if (auth == null) {
            return auth;
        }
        Set<DataAuthVerticalEntity> verticals = this.dataAuthVerticalService.findDetailsByAuthId(auth.getId());
        Set<DataAuthHorizontalEntity> horizontals = this.dataAuthHorizontalService.findDetailsByAuthId(auth.getId());
        Set<DataAuthInterceptorEntity> interceptors = this.dataAuthInterceptorService.findByAuthId(auth.getId());
        Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findByDataAuthCode(code);
        auth.setVerticalAuths(verticals);
        auth.setHorizontalAuths(horizontals);
        auth.setInterceptors(interceptors);
        auth.setPreAuths(preRules);
        return auth;
    }

    @Override
    public Set<DataAuthEntity> findByDataViewCode(String dataViewCode) {
        if (StringUtils.isBlank((CharSequence)dataViewCode)) {
            return Sets.newHashSet();
        }
        return this.dataAuthRepository.findByDataViewCode(dataViewCode);
    }

    @Override
    public Set<DataAuthEntity> findByServiceableName(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            return Sets.newHashSet();
        }
        return this.dataAuthRepository.findByServiceableName(serviceName);
    }

    @Override
    @Cacheable(cacheNames={"dataAuth"}, key="'findDetailsByDataViewCodeAndAuthCode_' + #dataViewCode + '_' + #authCode", unless="#result == null")
    public DataAuthEntity findDetailsByDataViewCodeAndAuthCode(String dataViewCode, String authCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataViewCode, authCode})) {
            return null;
        }
        return this.dataAuthRepository.findDetailsByDataViewCodeAndAuthCode(dataViewCode, authCode);
    }

    @Override
    @Cacheable(cacheNames={"dataAuth"}, key="'findDetailsByDataViewCodeAndAuthCodeAndPreRule_' + #dataViewCode + '_' + #authCode + '_' + #preRuleCode", unless="#result == null")
    public DataAuthEntity findDetailsByDataViewCodeAndAuthCodeAndPreRule(String dataViewCode, String authCode, String preRuleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataViewCode, authCode, preRuleCode})) {
            return null;
        }
        DataAuthEntity dataAuthEntity = this.dataAuthRepository.findDetailsByDataViewCodeAndAuthCode(dataViewCode, authCode);
        if (dataAuthEntity == null) {
            return null;
        }
        Set<DataAuthHorizontalEntity> horizontalEntities = this.dataAuthHorizontalService.findByPreRuleCode(preRuleCode);
        Set<DataAuthVerticalEntity> verticalEntities = this.dataAuthVerticalService.findByPreRuleCode(preRuleCode);
        dataAuthEntity.setHorizontalAuths(horizontalEntities);
        dataAuthEntity.setVerticalAuths(verticalEntities);
        return dataAuthEntity;
    }

    @Override
    @Cacheable(cacheNames={"dataAuth"}, key="'findDetailsByServicableNameAndAuthCodeAndPreRule_' + #servicableName + '_' + #authCode + '_' + #preRuleCode", unless="#result == null")
    public DataAuthEntity findDetailsByServicableNameAndAuthCodeAndPreRule(String servicableName, String authCode, String preRuleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{servicableName, authCode, preRuleCode})) {
            return null;
        }
        DataAuthEntity dataAuthEntity = this.dataAuthRepository.findDetailsByServicableNameAndAuthCode(servicableName, authCode);
        if (dataAuthEntity == null) {
            return null;
        }
        Set<DataAuthHorizontalEntity> horizontalEntities = this.dataAuthHorizontalService.findByPreRuleCode(preRuleCode);
        Set<DataAuthVerticalEntity> verticalEntities = this.dataAuthVerticalService.findByPreRuleCode(preRuleCode);
        dataAuthEntity.setHorizontalAuths(horizontalEntities);
        dataAuthEntity.setVerticalAuths(verticalEntities);
        return dataAuthEntity;
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"dataAuth"}, allEntries=true)
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthEntity auth = this.dataAuthRepository.findById(id).orElse(null);
        if (auth == null) {
            return;
        }
        this.dataAuthVerticalService.deleteByAuthId(id);
        this.dataAuthHorizontalService.deleteByAuthId(id);
        this.dataAuthInterceptorService.deleteByAuthId(id);
        Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findDetailsByDataAuthCode(auth.getCode());
        this.dataAuthPreRuleEntityService.deleteAll(preRules);
        this.dataAuthRepository.deleteById(id);
    }

    @Override
    public Set<DataAuthEntity> findDetailsByDataViewIds(String[] dataviewIds) {
        if (dataviewIds == null || dataviewIds.length == 0) {
            return Sets.newHashSet();
        }
        Set<DataAuthEntity> auths = this.dataAuthRepository.findDetailsByDataViewIds(dataviewIds);
        if (CollectionUtils.isEmpty(auths)) {
            return auths;
        }
        for (DataAuthEntity auth : auths) {
            Set<DataAuthVerticalEntity> verticals = this.dataAuthVerticalService.findDetailsByAuthId(auth.getId());
            Set<DataAuthHorizontalEntity> horizontals = this.dataAuthHorizontalService.findDetailsByAuthId(auth.getId());
            Set<DataAuthInterceptorEntity> interceptors = this.dataAuthInterceptorService.findByAuthId(auth.getId());
            Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findByDataAuthCode(auth.getCode());
            auth.setVerticalAuths(verticals);
            auth.setHorizontalAuths(horizontals);
            auth.setInterceptors(interceptors);
            auth.setPreAuths(preRules);
        }
        return auths;
    }

    @Override
    @Transactional
    public void importAuths(List<DataAuthEntity> auths, MigrateImportModel importModel) {
        if (CollectionUtils.isEmpty(auths)) {
            importModel.appendLine("\u4e0d\u9700\u8981\u5bfc\u5165\u6570\u636e\u6743\u9650");
            return;
        }
        importModel.appendLine("\u5f00\u59cb\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6743\u9650");
        for (DataAuthEntity auth : auths) {
            this.importAuth(auth, importModel);
        }
        importModel.appendLine("\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6743\u9650\u6210\u529f");
        importModel.appendLine("\u5b8c\u6210\u6570\u636e\u6743\u9650\u5bfc\u5165");
    }

    @Override
    @Transactional
    public void importAuth(DataAuthEntity importAuth, MigrateImportModel importModel) {
        Validate.notNull((Object)((Object)importAuth), (String)"\u5bfc\u5165\u7684\u6570\u636e\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importAuth.getCode(), (String)"\u5bfc\u5165\u7684\u6570\u636e\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.append("\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u6743\u9650\uff1a").appendLine(importAuth.getName());
        DataViewEntity importDataView = importAuth.getDataView();
        Validate.notNull((Object)((Object)importDataView), (String)"\u5bfc\u5165\u7684\u6570\u636e\u6743\u9650\u7f3a\u5931\u6570\u636e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01\uff01", (Object[])new Object[0]);
        DataViewEntity dataView = this.dataViewService.findByCode(importDataView.getCode());
        Validate.notNull((Object)((Object)dataView), (String)"\u672a\u627e\u5230\u6570\u636e\u6743\u9650\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\uff1a%s", (Object[])new Object[]{importDataView.getCode()});
        importAuth.setDataView(dataView);
        this.handleImportId(importAuth);
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        long count = this.dataAuthRepository.countByCode(importAuth.getCode());
        if (count > 0L && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u6570\u636e\u6743\u9650\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u672c\u6b21\u5bfc\u5165");
            return;
        }
        if (count > 0L && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u6570\u636e\u6743\u9650\u5df2\u5b58\u5728\uff0c\u6267\u884c\u66f4\u65b0\u5bfc\u5165");
            this.handleUpdateData(importAuth);
            return;
        }
        if (count == 0L) {
            importModel.appendLine("\u6267\u884c\u6570\u636e\u6743\u9650\u7684\u65b0\u589e\u5bfc\u5165");
            this.handleCreateData(importAuth);
        }
    }

    private void handleUpdateData(DataAuthEntity importAuth) {
        DataAuthEntity dbAuth = this.dataAuthRepository.findDetailsByCode(importAuth.getCode());
        Validate.notNull((Object)((Object)dbAuth), (String)"\u6570\u636e\u6743\u9650\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        importAuth.setId(dbAuth.getId());
        this.update(importAuth);
        this.saveAuthDetails(importAuth);
    }

    private void saveAuthDetails(DataAuthEntity importAuth) {
        this.dataAuthVerticalService.save(importAuth.getId(), importAuth.getVerticalAuths());
        this.dataAuthHorizontalService.save(importAuth.getId(), importAuth.getHorizontalAuths());
        this.dataAuthInterceptorService.save(importAuth.getId(), importAuth.getInterceptors());
        Set<DataAuthPreRuleEntity> preRuleEntitySet = importAuth.getPreAuths();
        for (DataAuthPreRuleEntity preRuleEntity : preRuleEntitySet) {
            preRuleEntity.setDataAuth(importAuth);
        }
        this.dataAuthPreRuleEntityService.save(importAuth.getCode(), preRuleEntitySet);
    }

    private void handleCreateData(DataAuthEntity importAuth) {
        this.dataAuthRepository.save((Object)importAuth);
        this.saveAuthDetails(importAuth);
    }

    private void handleImportId(DataAuthEntity importAuth) {
        Set<DataAuthPreRuleEntity> set;
        Set<DataAuthInterceptorEntity> set2;
        Set<DataAuthVerticalEntity> verticalAuths;
        importAuth.setId(null);
        Set<DataAuthHorizontalEntity> horizontalAuths = importAuth.getHorizontalAuths();
        if (!CollectionUtils.isEmpty(horizontalAuths)) {
            for (DataAuthHorizontalEntity dataAuthHorizontalEntity : horizontalAuths) {
                dataAuthHorizontalEntity.setId(null);
                Set<DataAuthHorizontalRelationEntity> set3 = dataAuthHorizontalEntity.getAuthRelations();
                if (CollectionUtils.isEmpty(set3)) continue;
                for (DataAuthHorizontalRelationEntity dataAuthHorizontalRelationEntity : set3) {
                    dataAuthHorizontalRelationEntity.setId(null);
                }
            }
        }
        if (!CollectionUtils.isEmpty(verticalAuths = importAuth.getVerticalAuths())) {
            for (DataAuthVerticalEntity dataAuthVerticalEntity : verticalAuths) {
                dataAuthVerticalEntity.setId(null);
                Set<DataAuthVerticalRelationEntity> relations = dataAuthVerticalEntity.getAuthRelations();
                if (CollectionUtils.isEmpty(relations)) continue;
                for (DataAuthVerticalRelationEntity relation : relations) {
                    relation.setId(null);
                }
            }
        }
        if (!CollectionUtils.isEmpty(set2 = importAuth.getInterceptors())) {
            for (DataAuthInterceptorEntity interceptor : set2) {
                interceptor.setId(null);
            }
        }
        if (!CollectionUtils.isEmpty(set = importAuth.getPreAuths())) {
            for (DataAuthPreRuleEntity dataAuthPreRuleEntity : set) {
                dataAuthPreRuleEntity.setId(null);
            }
        }
    }
}

