/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.common.enums.AuthOperatorEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalRelationEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthVerticalRepository;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.service.dauth.DataAuthVerticalRelationService;
import com.bizunited.platform.core.service.dauth.DataAuthVerticalService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataAuthVerticalServiceImpl")
public class DataAuthVerticalServiceImpl
implements DataAuthVerticalService {
    @Autowired
    private DataAuthVerticalRepository dataAuthVerticalRepository;
    @Autowired
    private DataAuthService dataAuthService;
    @Autowired
    private DataAuthVerticalRelationService dataAuthVerticalRelationService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public Set<DataAuthVerticalEntity> save(String authId, Set<DataAuthVerticalEntity> authVerticals) {
        this.saveValidation(authId, authVerticals);
        DataAuthEntity auth = this.dataAuthService.findById(authId);
        Validate.notNull((Object)((Object)auth), (String)"\u672a\u627e\u5230\u6570\u636e\u6743\u9650\uff1a%s", (Object[])new Object[]{authId});
        if (authVerticals == null) {
            authVerticals = Sets.newHashSet();
        }
        Map<String, DataAuthVerticalEntity> authVerticalsMap = authVerticals.stream().collect(Collectors.toMap(UuidEntity::getId, v -> v, (v1, v2) -> v2));
        Set<DataAuthVerticalEntity> dbAuthVerticals = this.dataAuthVerticalRepository.findByAuth(auth);
        HashSet creates = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet deletes = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)authVerticals, dbAuthVerticals, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataAuthVerticalEntity delete : deletes) {
            this.dataAuthVerticalRelationService.deleteByAuthVertical(delete.getId());
            this.dataAuthVerticalRepository.delete((Object)delete);
        }
        for (DataAuthVerticalEntity update : updates) {
            DataAuthVerticalEntity authVertical = authVerticalsMap.get(update.getId());
            update.setAuthType(authVertical.getAuthType());
            update.setPreRule(authVertical.getPreRule());
            update.setDisplayFields(authVertical.getDisplayFields());
            update.setOprtType(authVertical.getOprtType());
            update.setProjectName(this.platformContext.getAppName());
            if (authVertical.getSortIndex() != null) {
                update.setSortIndex(authVertical.getSortIndex());
            }
            Set<DataAuthVerticalRelationEntity> relations = this.dataAuthVerticalRelationService.save(update, update.getAuthRelations());
            update.setAuthRelations(relations);
        }
        for (DataAuthVerticalEntity create : creates) {
            if (create.getSortIndex() == null) {
                create.setSortIndex(0);
            }
            create.setId(null);
            create.setDataAuth(auth);
            create.setProjectName(this.platformContext.getAppName());
            this.dataAuthVerticalRepository.save((Object)create);
            Set<DataAuthVerticalRelationEntity> relations = this.dataAuthVerticalRelationService.save(create, create.getAuthRelations());
            create.setAuthRelations(relations);
        }
        updates.addAll(creates);
        return updates;
    }

    private void validation(DataAuthVerticalEntity authVertical) {
        Validate.notBlank((CharSequence)authVertical.getDisplayFields(), (String)"\u663e\u793a\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)authVertical.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)AuthOperatorEnum.valueOf(authVertical.getOprtType())), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26\uff1a%s", (Object[])new Object[]{authVertical.getOprtType()});
        Validate.notNull((Object)((Object)authVertical.getAuthType()), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(authVertical.getAuthRelations(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void saveValidation(String authId, Set<DataAuthVerticalEntity> authVerticals) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650\u5bf9\u8c61\u7684ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authVerticals)) {
            return;
        }
        for (DataAuthVerticalEntity authVertical : authVerticals) {
            this.validation(authVertical);
        }
    }

    @Override
    public DataAuthVerticalEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthVerticalRepository.findDetailsById(id);
    }

    @Override
    public DataAuthVerticalEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataAuthVerticalRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DataAuthVerticalEntity av = this.dataAuthVerticalRepository.findById(id).orElse(null);
        if (av == null) {
            return;
        }
        this.dataAuthVerticalRelationService.deleteByAuthVertical(id);
        this.dataAuthVerticalRepository.delete((Object)av);
    }

    @Override
    public Set<DataAuthVerticalEntity> findDetailsByAuthId(String authId) {
        if (StringUtils.isBlank((CharSequence)authId)) {
            return Sets.newHashSet();
        }
        DataAuthEntity auth = new DataAuthEntity();
        auth.setId(authId);
        Set<DataAuthVerticalEntity> verticals = this.dataAuthVerticalRepository.findByAuth(auth);
        if (CollectionUtils.isEmpty(verticals)) {
            return Sets.newHashSet();
        }
        for (DataAuthVerticalEntity vertical : verticals) {
            Set<DataAuthVerticalRelationEntity> relations = this.dataAuthVerticalRelationService.findDetailsByAuthVertical(vertical.getId());
            vertical.setAuthRelations(relations);
        }
        return verticals;
    }

    @Override
    @Transactional
    public void deleteByAuthId(String authId) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataAuthEntity auth = new DataAuthEntity();
        auth.setId(authId);
        Set<DataAuthVerticalEntity> verticals = this.dataAuthVerticalRepository.findByAuth(auth);
        if (CollectionUtils.isEmpty(verticals)) {
            return;
        }
        for (DataAuthVerticalEntity vertical : verticals) {
            this.dataAuthVerticalRelationService.deleteByAuthVertical(vertical.getId());
        }
        this.dataAuthVerticalRepository.deleteAll(verticals);
    }

    @Override
    public Set<DataAuthVerticalEntity> findDetailsByAuthCode(String authCode) {
        if (StringUtils.isBlank((CharSequence)authCode)) {
            return Sets.newHashSet();
        }
        Set<DataAuthVerticalEntity> verticals = this.dataAuthVerticalRepository.findByCode(authCode);
        if (CollectionUtils.isEmpty(verticals)) {
            return Sets.newHashSet();
        }
        for (DataAuthVerticalEntity vertical : verticals) {
            Set<DataAuthVerticalRelationEntity> relations = this.dataAuthVerticalRelationService.findDetailsByAuthVertical(vertical.getId());
            vertical.setAuthRelations(relations);
        }
        return verticals;
    }

    @Override
    public Set<DataAuthVerticalEntity> findByPreRuleCode(String preRuleCode) {
        if (StringUtils.isBlank((CharSequence)preRuleCode)) {
            return null;
        }
        return this.dataAuthVerticalRepository.findByPreRuleCode(preRuleCode);
    }
}

