/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.invoke;

import com.bizunited.platform.core.service.invoke.AbstractHandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import java.util.List;

public class DefaultHandleChain
extends AbstractHandleChain {
    private List<InvokeRequestHandle> currentInvokeRequestHandles;
    private List<InvokeResponseHandle> currentInvokeResponseHandles;
    private int currentRequestIndex = 0;
    private int currentResponseIndex = 0;

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain.ChainLogic chainLogic) throws InvokeProxyException {
        if ((this.currentInvokeRequestHandles == null || this.currentInvokeRequestHandles.isEmpty()) && (this.currentInvokeResponseHandles == null || this.currentInvokeResponseHandles.isEmpty())) {
            throw new IllegalArgumentException("\u672a\u53d1\u73b0\u4efb\u4f55request\u8bf7\u6c42\u8fde\u5904\u7406\u8282\u70b9\u3001\u4efb\u4f55response\u8bf7\u6c42\u8fde\u5904\u7406\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!");
        }
        int maxRequestHandlesSize = this.currentInvokeRequestHandles.size();
        int maxResponseHandlesSize = this.currentInvokeResponseHandles.size();
        if (this.currentRequestIndex >= maxRequestHandlesSize && this.currentResponseIndex >= maxResponseHandlesSize) {
            this.rethrowException(context);
            return;
        }
        if (this.currentRequestIndex < maxRequestHandlesSize && chainLogic == HandleChain.ChainLogic.CONTINUE) {
            InvokeRequestHandle currentHandle = this.currentInvokeRequestHandles.get(this.currentRequestIndex++);
            try {
                currentHandle.doHandle(context, this);
            }
            catch (Exception e) {
                this.buildException(context, e);
                this.currentRequestIndex = maxRequestHandlesSize;
                this.doHandle(context, HandleChain.ChainLogic.CONTINUE);
            }
            this.rethrowException(context);
            return;
        }
        if (this.currentRequestIndex < maxRequestHandlesSize && chainLogic == HandleChain.ChainLogic.BREAK) {
            this.currentRequestIndex = maxRequestHandlesSize;
            this.doHandle(context, HandleChain.ChainLogic.CONTINUE);
            this.rethrowException(context);
            return;
        }
        if (this.currentResponseIndex < maxResponseHandlesSize && this.currentRequestIndex >= maxRequestHandlesSize && chainLogic == HandleChain.ChainLogic.CONTINUE) {
            InvokeResponseHandle currentHandle = this.currentInvokeResponseHandles.get(this.currentResponseIndex++);
            if (context.isException() && currentHandle.handleException(context)) {
                currentHandle.doHandle(context, this);
                this.rethrowException(context);
                return;
            }
            if (context.isException() && !currentHandle.handleException(context)) {
                this.doHandle(context, chainLogic);
                this.rethrowException(context);
                return;
            }
            try {
                currentHandle.doHandle(context, this);
            }
            catch (Exception e) {
                this.buildException(context, e);
                throw new InvokeProxyException(context, (Throwable)e);
            }
        }
        this.rethrowException(context);
    }

    void setInvokeRequestHandles(List<InvokeRequestHandle> currentInvokeRequestHandles) {
        this.currentInvokeRequestHandles = currentInvokeRequestHandles;
    }

    void setInvokeResponseHandles(List<InvokeResponseHandle> currentInvokeResponseHandles) {
        this.currentInvokeResponseHandles = currentInvokeResponseHandles;
    }
}

