/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.aspect;

import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import com.bizunited.platform.core.service.LoggerTemplateEntityService;
import com.bizunited.platform.core.service.log.aspect.NebulaLoggerHandle;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class AnnotationLoggerAroundAdvice
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationLoggerAroundAdvice.class);
    @Autowired
    @Lazy
    private LoggerTemplateEntityService loggerTemplateService;
    @Autowired
    @Lazy
    private NebulaLoggerHandle nebulaLoggerHandle;

    public Object invoke(MethodInvocation methodInvocation) {
        if (this.loggerTemplateService == null) {
            return this.ignoreProcess(methodInvocation);
        }
        Method targetMethod = methodInvocation.getMethod();
        String methodName = targetMethod.getName();
        Class<?> declaringClass = targetMethod.getDeclaringClass();
        String className = declaringClass.getName();
        String fullMethodName = StringUtils.join((Object[])new String[]{className, ".", methodName});
        if (StringUtils.containsAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{"export", "import"})) {
            return this.ignoreProcess(methodInvocation);
        }
        LoggerTemplateEntity target = this.loggerTemplateService.findByMethodName(fullMethodName);
        if (target == null || !new Integer(1).equals(target.getState())) {
            return this.ignoreProcess(methodInvocation);
        }
        LOGGER.info("\u4e1a\u52a1\u65e5\u5fd7\u70b9\uff1a" + fullMethodName + "\u6b63\u5728\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55!!");
        return this.nebulaLoggerHandle.handLogger(target, methodInvocation);
    }

    private Object ignoreProcess(MethodInvocation methodInvocation) {
        Object obj = null;
        try {
            obj = methodInvocation.proceed();
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable thr) {
            Rethrower.rethrow(thr);
        }
        return obj;
    }

    private static class Rethrower {
        private Rethrower() {
        }

        public static void rethrow(Throwable exception) {
            class CheckedExceptionRethrower<T extends Throwable> {
                CheckedExceptionRethrower() {
                }

                private void rethrow(Throwable exception) throws T {
                    throw exception;
                }
            }
            new CheckedExceptionRethrower().rethrow(exception);
        }
    }
}

