/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.entity.log.LoggerFiledMappingEntity;
import com.bizunited.platform.core.repository.log.LoggerFiledMappingEntityRepository;
import com.bizunited.platform.core.service.LoggerFiledMappingEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class LoggerFiledMappingEntityServiceImpl
implements LoggerFiledMappingEntityService {
    @Autowired
    private LoggerFiledMappingEntityRepository loggerFiledMappingEntityRepository;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public LoggerFiledMappingEntity create(LoggerFiledMappingEntity loggerFiledMappingEntity) {
        LoggerFiledMappingEntity current = this.createForm(loggerFiledMappingEntity);
        return current;
    }

    @Override
    @Transactional
    public LoggerFiledMappingEntity createForm(LoggerFiledMappingEntity loggerFiledMappingEntity) {
        Date date = new Date();
        String userAccount = SecurityUtils.getUserAccount();
        loggerFiledMappingEntity.setCreateTime(date);
        loggerFiledMappingEntity.setCreateAccount(userAccount);
        loggerFiledMappingEntity.setModifyAccount(userAccount);
        loggerFiledMappingEntity.setModifyTime(date);
        this.createValidation(loggerFiledMappingEntity);
        this.loggerFiledMappingEntityRepository.saveAndFlush((Object)loggerFiledMappingEntity);
        return loggerFiledMappingEntity;
    }

    private void createValidation(LoggerFiledMappingEntity loggerFiledMappingEntity) {
        Validate.notNull((Object)((Object)loggerFiledMappingEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)loggerFiledMappingEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        loggerFiledMappingEntity.setId(null);
        Validate.notNull((Object)loggerFiledMappingEntity.getCreateTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerFiledMappingEntity.getApplicationName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerFiledMappingEntity.getLanguage(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8bed\u8a00\uff0c\u9ed8\u8ba4CH\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerFiledMappingEntity.getFieldName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerFiledMappingEntity.getMappingType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6620\u5c04\u65b9\u5f0f 0--\u6587\u672c\uff0c1--\u5b57\u5178\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getApplicationName() == null || loggerFiledMappingEntity.getApplicationName().length() < 255 ? 1 : 0) != 0, (String)"\u5e94\u7528\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getLanguage() == null || loggerFiledMappingEntity.getLanguage().length() < 64 ? 1 : 0) != 0, (String)"\u8bed\u8a00\uff0c\u9ed8\u8ba4CH,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getFieldName() == null || loggerFiledMappingEntity.getFieldName().length() < 64 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d, \u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getFieldDesc() == null || loggerFiledMappingEntity.getFieldDesc().length() < 255 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u63cf\u8ff0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getDictCode() == null || loggerFiledMappingEntity.getDictCode().length() < 255 ? 1 : 0) != 0, (String)"\u5b57\u5178\u8868code,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        LoggerFiledMappingEntity fieldEntity = this.loggerFiledMappingEntityRepository.findByFieldNameAndProjectName(loggerFiledMappingEntity.getFieldName(), this.platformContext.getAppName());
        Validate.isTrue((fieldEntity == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u82f1\u6587\u5b57\u6bb5\u540d\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        LoggerFiledMappingEntity applicationEntity = this.loggerFiledMappingEntityRepository.findByApplicationNameAndProjectName(loggerFiledMappingEntity.getApplicationName(), this.platformContext.getAppName());
        Validate.isTrue((applicationEntity == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public LoggerFiledMappingEntity update(LoggerFiledMappingEntity loggerFiledMappingEntity) {
        LoggerFiledMappingEntity current = this.updateForm(loggerFiledMappingEntity);
        return current;
    }

    @Override
    @Transactional
    public LoggerFiledMappingEntity updateForm(LoggerFiledMappingEntity loggerFiledMappingEntity) {
        this.updateValidation(loggerFiledMappingEntity);
        String currentId = loggerFiledMappingEntity.getId();
        Optional op_currentLoggerFiledMappingEntity = this.loggerFiledMappingEntityRepository.findById(currentId);
        LoggerFiledMappingEntity currentLoggerFiledMappingEntity = op_currentLoggerFiledMappingEntity.orElse(null);
        currentLoggerFiledMappingEntity = (LoggerFiledMappingEntity)((Object)Validate.notNull((Object)((Object)currentLoggerFiledMappingEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentLoggerFiledMappingEntity.setModifyAccount(SecurityUtils.getUserAccount());
        currentLoggerFiledMappingEntity.setModifyTime(new Date());
        currentLoggerFiledMappingEntity.setApplicationName(loggerFiledMappingEntity.getApplicationName());
        currentLoggerFiledMappingEntity.setLanguage(loggerFiledMappingEntity.getLanguage());
        currentLoggerFiledMappingEntity.setFieldName(loggerFiledMappingEntity.getFieldName());
        currentLoggerFiledMappingEntity.setMappingType(loggerFiledMappingEntity.getMappingType());
        currentLoggerFiledMappingEntity.setFieldDesc(loggerFiledMappingEntity.getFieldDesc());
        currentLoggerFiledMappingEntity.setDictCode(loggerFiledMappingEntity.getDictCode());
        this.loggerFiledMappingEntityRepository.saveAndFlush((Object)currentLoggerFiledMappingEntity);
        return currentLoggerFiledMappingEntity;
    }

    private void updateValidation(LoggerFiledMappingEntity loggerFiledMappingEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)loggerFiledMappingEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerFiledMappingEntity.getApplicationName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerFiledMappingEntity.getLanguage(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8bed\u8a00\uff0c\u9ed8\u8ba4CH\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerFiledMappingEntity.getFieldName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8bed\u8a00\uff0c\u9ed8\u8ba4CH\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerFiledMappingEntity.getMappingType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6620\u5c04\u65b9\u5f0f 0--\u6587\u672c\uff0c1--\u5b57\u5178\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getApplicationName() == null || loggerFiledMappingEntity.getApplicationName().length() < 255 ? 1 : 0) != 0, (String)"\u5e94\u7528\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getLanguage() == null || loggerFiledMappingEntity.getLanguage().length() < 64 ? 1 : 0) != 0, (String)"\u8bed\u8a00\uff0c\u9ed8\u8ba4CH,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getFieldName() == null || loggerFiledMappingEntity.getFieldName().length() < 64 ? 1 : 0) != 0, (String)"\u8bed\u8a00\uff0c\u9ed8\u8ba4CH,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getFieldDesc() == null || loggerFiledMappingEntity.getFieldDesc().length() < 255 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u63cf\u8ff0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerFiledMappingEntity.getDictCode() == null || loggerFiledMappingEntity.getDictCode().length() < 255 ? 1 : 0) != 0, (String)"\u5b57\u5178\u8868code,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        LoggerFiledMappingEntity currentEntity = this.loggerFiledMappingEntityRepository.findById(loggerFiledMappingEntity.getId()).orElse(null);
        if (!StringUtils.equals((CharSequence)currentEntity.getFieldName(), (CharSequence)loggerFiledMappingEntity.getFieldName())) {
            LoggerFiledMappingEntity fieldEntity = this.loggerFiledMappingEntityRepository.findByFieldNameAndProjectName(loggerFiledMappingEntity.getFieldName(), this.platformContext.getAppName());
            Validate.isTrue((fieldEntity == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u82f1\u6587\u5b57\u6bb5\u540d\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        }
        if (!StringUtils.equals((CharSequence)currentEntity.getApplicationName(), (CharSequence)loggerFiledMappingEntity.getApplicationName())) {
            LoggerFiledMappingEntity applicationEntity = this.loggerFiledMappingEntityRepository.findByApplicationNameAndProjectName(loggerFiledMappingEntity.getApplicationName(), this.platformContext.getAppName());
            Validate.isTrue((applicationEntity == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        }
    }

    @Override
    public LoggerFiledMappingEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional current = this.loggerFiledMappingEntityRepository.findById(id);
        if (!current.isPresent()) {
            return null;
        }
        return (LoggerFiledMappingEntity)((Object)current.get());
    }

    @Override
    public LoggerFiledMappingEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.loggerFiledMappingEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        LoggerFiledMappingEntity current = this.findById(id);
        if (current != null) {
            this.loggerFiledMappingEntityRepository.delete((Object)current);
        }
    }

    @Override
    public Page<LoggerFiledMappingEntity> findByConditions(LoggerFiledMappingEntity lf, Pageable pageable) {
        String fieldDesc;
        String fieldName;
        Validate.notNull((Object)pageable, (String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>(5);
        String applicationName = lf.getApplicationName();
        if (StringUtils.isNotBlank((CharSequence)applicationName)) {
            conditions.put("applicationName", applicationName);
        }
        if (StringUtils.isNotBlank((CharSequence)(fieldName = lf.getFieldName()))) {
            conditions.put("fieldName", fieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)(fieldDesc = lf.getFieldDesc()))) {
            conditions.put("fieldDesc", fieldDesc);
        }
        return this.loggerFiledMappingEntityRepository.findByConditions(pageable, conditions);
    }
}

