/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import com.bizunited.platform.core.repository.log.LoggerTemplateEntityRepository;
import com.bizunited.platform.core.service.LoggerTemplateEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LoggerTemplateEntityServiceImpl
implements LoggerTemplateEntityService {
    private static Cache<String, LoggerTemplateEntity> localCache = null;
    private NebulaToolkitService nebulaToolkitService;
    private LoggerTemplateEntityRepository loggerTemplateEntityRepository;
    @Autowired
    private PlatformContext platformContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Autowired
    public LoggerTemplateEntityServiceImpl(NebulaToolkitService nebulaToolkitService, LoggerTemplateEntityRepository loggerTemplateEntityRepository) {
        this.nebulaToolkitService = nebulaToolkitService;
        this.loggerTemplateEntityRepository = loggerTemplateEntityRepository;
        if (localCache == null) {
            Class<LoggerTemplateEntityServiceImpl> clazz = LoggerTemplateEntityServiceImpl.class;
            // MONITORENTER : com.bizunited.platform.core.service.log.internal.LoggerTemplateEntityServiceImpl.class
            while (localCache == null) {
                ResourcePools resourcePools = ResourcePoolsBuilder.heap((long)500L).build();
                ExpiryPolicy expiryPolicy = ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofMinutes(20L));
                CacheConfigurationBuilder cacheConfigurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, LoggerTemplateEntity.class, (ResourcePools)resourcePools);
                CacheConfiguration cacheConfiguration = cacheConfigurationBuilder.withExpiry(expiryPolicy).build();
                CacheManagerBuilder build = CacheManagerBuilder.newCacheManagerBuilder();
                CacheManager cacheManager = build.withCache("preLoggerTemplateConfigured", cacheConfiguration).withDefaultSizeOfMaxObjectSize(1024L, MemoryUnit.MB).build(true);
                localCache = cacheManager.getCache("preLoggerTemplateConfigured", String.class, LoggerTemplateEntity.class);
            }
            // MONITOREXIT : clazz
        }
        this.cache();
    }

    @Override
    public LoggerTemplateEntity create(LoggerTemplateEntity loggerTemplateEntity) {
        LoggerTemplateEntity current = this.createForm(loggerTemplateEntity);
        return current;
    }

    @Override
    @Transactional
    public LoggerTemplateEntity createForm(LoggerTemplateEntity loggerTemplateEntity) {
        this.createValidation(loggerTemplateEntity);
        Date date = new Date();
        if (StringUtils.isBlank((CharSequence)loggerTemplateEntity.getCreateAccount())) {
            String userAccount = SecurityUtils.getUserAccount();
            loggerTemplateEntity.setCreateAccount(userAccount);
        }
        loggerTemplateEntity.setCreateTime(date);
        loggerTemplateEntity.setModifyTime(date);
        loggerTemplateEntity.setModifyAccount(loggerTemplateEntity.getCreateAccount());
        loggerTemplateEntity.setState(1);
        loggerTemplateEntity.setProjectName(this.platformContext.getAppName());
        this.loggerTemplateEntityRepository.save((Object)loggerTemplateEntity);
        this.cache(loggerTemplateEntity);
        return loggerTemplateEntity;
    }

    private void createValidation(LoggerTemplateEntity loggerTemplateEntity) {
        Validate.notNull((Object)((Object)loggerTemplateEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)loggerTemplateEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        loggerTemplateEntity.setId(null);
        Validate.notNull((Object)loggerTemplateEntity.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6a21\u677f\u7f16\u53f7\uff0c\u552f\u4e00\u7684\u7f16\u53f7\uff0c\u5fc5\u987b\u6709\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\uff0c\u53ef\u4ee5\u81ea\u884c\u6dfb\u52a0\uff0c\u4f46\u662f\u53ea\u80fd\u662f\u82f1\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getModule(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u6a21\u5757\uff0c\u53ef\u4ee5\u968f\u4fbf\u7f16\u5199\uff0c\u4f46\u5fc5\u987b\u662f\u82f1\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5b8c\u6574\u7684\u88ab\u62e6\u622a\u7684\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerTemplateEntity.getMethodParamIndex(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u67e5\u8be2\u6570\u636e\u8be6\u60c5\u65f6\uff0c\u4f7f\u7528\u8be5\u65b9\u6cd5\u7684\u7b2c\u51e0\u4e2a\u53c2\u6570\u4f5c\u4e3a\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getExpression(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u4fe1\u606f\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerTemplateEntity.getCompare(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8be5\u65e5\u5fd7\u6a21\u677f\u662f\u5426\u9700\u8981\u8fdb\u884c\u660e\u7ec6\u6bd4\u8f83\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getName() == null || loggerTemplateEntity.getName().length() < 255 ? 1 : 0) != 0, (String)"\u6a21\u677f\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getCode() == null || loggerTemplateEntity.getCode().length() < 255 ? 1 : 0) != 0, (String)"\u6a21\u677f\u7f16\u53f7\uff0c\u552f\u4e00\u7684\u7f16\u53f7\uff0c\u5fc5\u987b\u6709,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getType() == null || loggerTemplateEntity.getType().length() < 255 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7c7b\u578b\uff0c\u53ef\u4ee5\u81ea\u884c\u6dfb\u52a0\uff0c\u4f46\u662f\u53ea\u80fd\u662f\u82f1\u6587,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getModule() == null || loggerTemplateEntity.getModule().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u6a21\u5757\uff0c\u53ef\u4ee5\u968f\u4fbf\u7f16\u5199\uff0c\u4f46\u5fc5\u987b\u662f\u82f1\u6587,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getMethodName() == null || loggerTemplateEntity.getMethodName().length() < 255 ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u88ab\u62e6\u622a\u7684\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getPreQueryComponent() == null || loggerTemplateEntity.getPreQueryComponent().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u9884\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getPreQueryMethod() == null || loggerTemplateEntity.getPreQueryMethod().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u9884\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u7684\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getPreReturnFilter() == null || loggerTemplateEntity.getPreReturnFilter().length() < 255 ? 1 : 0) != 0, (String)"\u9884\u67e5\u8be2\u65f6\uff0c\u53ef\u4ee5\u4f7f\u7528\u8be5\u5c5e\u6027\u6307\u5b9a\u8fd9\u4e2a\u4e1a\u52a1\u5bf9\u8c61\u7684\u54ea\u4e9b\u76f4\u63a5\u6216\u95f4\u63a5\u5c5e\u6027\u9700\u8981\u8fdb\u884c\u8fd4\u56de,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getLastQueryComponent() == null || loggerTemplateEntity.getLastQueryComponent().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u540e\u7f6e\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u4fe1\u606f\uff08\u4e00\u822c\u4e3abean\u7ec4\u4ef6\u540d\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getLastQueryMethod() == null || loggerTemplateEntity.getLastQueryMethod().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u540e\u7f6e\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u7684\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getLastReturnFilter() == null || loggerTemplateEntity.getLastReturnFilter().length() < 255 ? 1 : 0) != 0, (String)"\u540e\u7f6e\u67e5\u8be2\u65f6\uff0c\u53ef\u4ee5\u4f7f\u7528\u8be5\u5c5e\u6027\u6307\u5b9a\u8fd9\u4e2a\u4e1a\u52a1\u5bf9\u8c61\u7684\u54ea\u4e9b\u76f4\u63a5\u6216\u95f4\u63a5\u5c5e\u6027\u9700\u8981\u8fdb\u884c\u8fd4\u56de,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        LoggerTemplateEntity currentLoggerTemplateEntity = this.findByCode(loggerTemplateEntity.getCode());
        Validate.isTrue((currentLoggerTemplateEntity == null ? 1 : 0) != 0, (String)"\u6a21\u677f\u7f16\u53f7\uff0c\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        currentLoggerTemplateEntity = this.findByMethodName(loggerTemplateEntity.getMethodName());
        Validate.isTrue((currentLoggerTemplateEntity == null ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u88ab\u62e6\u622a\u7684\u65b9\u6cd5\u540d\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public LoggerTemplateEntity update(LoggerTemplateEntity loggerTemplateEntity) {
        LoggerTemplateEntity current = this.updateForm(loggerTemplateEntity);
        return current;
    }

    @Override
    @Transactional
    public LoggerTemplateEntity updateForm(LoggerTemplateEntity loggerTemplateEntity) {
        this.updateValidation(loggerTemplateEntity);
        String currentId = loggerTemplateEntity.getId();
        Optional op_currentLoggerTemplateEntity = this.loggerTemplateEntityRepository.findById(currentId);
        LoggerTemplateEntity currentLoggerTemplateEntity = op_currentLoggerTemplateEntity.orElse(null);
        currentLoggerTemplateEntity = (LoggerTemplateEntity)((Object)Validate.notNull((Object)((Object)currentLoggerTemplateEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        if (StringUtils.isBlank((CharSequence)loggerTemplateEntity.getModifyAccount())) {
            currentLoggerTemplateEntity.setModifyAccount(SecurityUtils.getUserAccount());
        }
        currentLoggerTemplateEntity.setModifyTime(new Date());
        currentLoggerTemplateEntity.setName(loggerTemplateEntity.getName());
        currentLoggerTemplateEntity.setCode(loggerTemplateEntity.getCode());
        currentLoggerTemplateEntity.setType(loggerTemplateEntity.getType());
        currentLoggerTemplateEntity.setModule(loggerTemplateEntity.getModule());
        currentLoggerTemplateEntity.setMethodName(loggerTemplateEntity.getMethodName());
        currentLoggerTemplateEntity.setMethodParamIndex(loggerTemplateEntity.getMethodParamIndex());
        currentLoggerTemplateEntity.setMethodParamProperty(loggerTemplateEntity.getMethodParamProperty());
        currentLoggerTemplateEntity.setExpression(loggerTemplateEntity.getExpression());
        currentLoggerTemplateEntity.setCompare(loggerTemplateEntity.getCompare());
        currentLoggerTemplateEntity.setPreQueryComponent(loggerTemplateEntity.getPreQueryComponent());
        currentLoggerTemplateEntity.setPreQueryMethod(loggerTemplateEntity.getPreQueryMethod());
        currentLoggerTemplateEntity.setPreReturnFilter(loggerTemplateEntity.getPreReturnFilter());
        currentLoggerTemplateEntity.setLastQueryComponent(loggerTemplateEntity.getLastQueryComponent());
        currentLoggerTemplateEntity.setLastQueryMethod(loggerTemplateEntity.getLastQueryMethod());
        currentLoggerTemplateEntity.setLastReturnFilter(loggerTemplateEntity.getLastReturnFilter());
        currentLoggerTemplateEntity.setState(loggerTemplateEntity.getState());
        currentLoggerTemplateEntity.setModuleDisplayName(loggerTemplateEntity.getModuleDisplayName());
        currentLoggerTemplateEntity.setPageName(loggerTemplateEntity.getPageName());
        this.loggerTemplateEntityRepository.saveAndFlush((Object)currentLoggerTemplateEntity);
        this.cache(currentLoggerTemplateEntity);
        return currentLoggerTemplateEntity;
    }

    private void updateValidation(LoggerTemplateEntity loggerTemplateEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)loggerTemplateEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerTemplateEntity.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6a21\u677f\u7f16\u53f7\uff0c\u552f\u4e00\u7684\u7f16\u53f7\uff0c\u5fc5\u987b\u6709\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\uff0c\u53ef\u4ee5\u81ea\u884c\u6dfb\u52a0\uff0c\u4f46\u662f\u53ea\u80fd\u662f\u82f1\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getModule(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u6a21\u5757\uff0c\u53ef\u4ee5\u968f\u4fbf\u7f16\u5199\uff0c\u4f46\u5fc5\u987b\u662f\u82f1\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getMethodName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5b8c\u6574\u7684\u88ab\u62e6\u622a\u7684\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerTemplateEntity.getMethodParamIndex(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u67e5\u8be2\u6570\u636e\u8be6\u60c5\u65f6\uff0c\u4f7f\u7528\u8be5\u65b9\u6cd5\u7684\u7b2c\u51e0\u4e2a\u53c2\u6570\u4f5c\u4e3a\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerTemplateEntity.getExpression(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u4fe1\u606f\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerTemplateEntity.getCompare(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8be5\u65e5\u5fd7\u6a21\u677f\u662f\u5426\u9700\u8981\u8fdb\u884c\u660e\u7ec6\u6bd4\u8f83\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerTemplateEntity.getState(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getName() == null || loggerTemplateEntity.getName().length() < 255 ? 1 : 0) != 0, (String)"\u6a21\u677f\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getCode() == null || loggerTemplateEntity.getCode().length() < 255 ? 1 : 0) != 0, (String)"\u6a21\u677f\u7f16\u53f7\uff0c\u552f\u4e00\u7684\u7f16\u53f7\uff0c\u5fc5\u987b\u6709,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getType() == null || loggerTemplateEntity.getType().length() < 255 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7c7b\u578b\uff0c\u53ef\u4ee5\u81ea\u884c\u6dfb\u52a0\uff0c\u4f46\u662f\u53ea\u80fd\u662f\u82f1\u6587,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getModule() == null || loggerTemplateEntity.getModule().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u6a21\u5757\uff0c\u53ef\u4ee5\u968f\u4fbf\u7f16\u5199\uff0c\u4f46\u5fc5\u987b\u662f\u82f1\u6587,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getMethodName() == null || loggerTemplateEntity.getMethodName().length() < 255 ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u88ab\u62e6\u622a\u7684\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getPreQueryComponent() == null || loggerTemplateEntity.getPreQueryComponent().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u9884\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u4fe1\u606f,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getPreQueryMethod() == null || loggerTemplateEntity.getPreQueryMethod().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u9884\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u7684\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getPreReturnFilter() == null || loggerTemplateEntity.getPreReturnFilter().length() < 255 ? 1 : 0) != 0, (String)"\u9884\u67e5\u8be2\u65f6\uff0c\u53ef\u4ee5\u4f7f\u7528\u8be5\u5c5e\u6027\u6307\u5b9a\u8fd9\u4e2a\u4e1a\u52a1\u5bf9\u8c61\u7684\u54ea\u4e9b\u76f4\u63a5\u6216\u95f4\u63a5\u5c5e\u6027\u9700\u8981\u8fdb\u884c\u8fd4\u56de,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getLastQueryComponent() == null || loggerTemplateEntity.getLastQueryComponent().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u540e\u7f6e\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u4fe1\u606f\uff08\u4e00\u822c\u4e3abean\u7ec4\u4ef6\u540d\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getLastQueryMethod() == null || loggerTemplateEntity.getLastQueryMethod().length() < 255 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u540e\u7f6e\u67e5\u8be2\u7684bean\u7ec4\u4ef6\u7684\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerTemplateEntity.getLastReturnFilter() == null || loggerTemplateEntity.getLastReturnFilter().length() < 255 ? 1 : 0) != 0, (String)"\u540e\u7f6e\u67e5\u8be2\u65f6\uff0c\u53ef\u4ee5\u4f7f\u7528\u8be5\u5c5e\u6027\u6307\u5b9a\u8fd9\u4e2a\u4e1a\u52a1\u5bf9\u8c61\u7684\u54ea\u4e9b\u76f4\u63a5\u6216\u95f4\u63a5\u5c5e\u6027\u9700\u8981\u8fdb\u884c\u8fd4\u56de,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        LoggerTemplateEntity currentForId = this.findDetailsById(loggerTemplateEntity.getId());
        if (!StringUtils.equals((CharSequence)currentForId.getCode(), (CharSequence)loggerTemplateEntity.getCode())) {
            LoggerTemplateEntity currentForCode = this.findByCode(loggerTemplateEntity.getCode());
            Validate.isTrue((currentForCode == null ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u586b\u5165\u7684code\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        if (!StringUtils.equals((CharSequence)currentForId.getMethodName(), (CharSequence)loggerTemplateEntity.getMethodName())) {
            LoggerTemplateEntity currentForMethodName = this.findByMethodName(loggerTemplateEntity.getMethodName());
            Validate.isTrue((currentForMethodName == null ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u586b\u5165\u7684methodName\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        LoggerTemplateEntity current = this.findDetailsById(id);
        if (current != null) {
            this.loggerTemplateEntityRepository.delete((Object)current);
        }
    }

    @Override
    public LoggerTemplateEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        LoggerTemplateEntity result = null;
        for (Cache.Entry item : localCache) {
            LoggerTemplateEntity v = (LoggerTemplateEntity)((Object)item.getValue());
            String cid = v.getId();
            if (!StringUtils.equals((CharSequence)cid, (CharSequence)id)) continue;
            result = v;
            break;
        }
        if (result != null) {
            return result;
        }
        result = this.loggerTemplateEntityRepository.findDetailsById(id);
        if (result != null) {
            this.cache(result);
        }
        return result;
    }

    @Override
    public LoggerTemplateEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        LoggerTemplateEntity result = null;
        result = (LoggerTemplateEntity)((Object)localCache.get((Object)code));
        if (result != null) {
            return result;
        }
        result = this.loggerTemplateEntityRepository.findByCode(code);
        if (result != null) {
            this.cache(result);
        }
        return result;
    }

    @Override
    public LoggerTemplateEntity findByMethodName(String methodName) {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            return null;
        }
        LoggerTemplateEntity result = null;
        for (Cache.Entry item : localCache) {
            LoggerTemplateEntity v = (LoggerTemplateEntity)((Object)item.getValue());
            String cMethodName = v.getMethodName();
            if (!StringUtils.equals((CharSequence)cMethodName, (CharSequence)methodName)) continue;
            result = v;
            break;
        }
        if (result != null) {
            return result;
        }
        result = this.loggerTemplateEntityRepository.findByMethodNameAndProjectName(methodName, this.platformContext.getAppName());
        if (result != null) {
            this.cache(result);
        }
        return result;
    }

    @Override
    public Page<LoggerTemplateEntity> findByConditions(LoggerTemplateEntity loggerTemplateEntity, Pageable pageable) {
        Integer state;
        String methodName;
        String name;
        Validate.notNull((Object)pageable, (String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, Object> conditions = new HashMap<String, Object>(5);
        String code = loggerTemplateEntity.getCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = loggerTemplateEntity.getName()))) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)(methodName = loggerTemplateEntity.getMethodName()))) {
            conditions.put("methodName", methodName);
        }
        if ((state = loggerTemplateEntity.getState()) != null) {
            conditions.put("state", state);
        }
        return this.loggerTemplateEntityRepository.findByConditions(pageable, conditions);
    }

    @Override
    public List<String> findAllModule() {
        return this.loggerTemplateEntityRepository.findAllModule();
    }

    @Override
    @Transactional
    public void disableById(String id) {
        LoggerTemplateEntity entity = this.findDetailsById(id);
        Validate.isTrue((entity != null ? 1 : 0) != 0, (String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u65e5\u5fd7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        entity.setState(0);
        this.loggerTemplateEntityRepository.saveAndFlush((Object)entity);
    }

    @Override
    @Transactional
    public void enableById(String id) {
        LoggerTemplateEntity entity = this.findDetailsById(id);
        Validate.isTrue((entity != null ? 1 : 0) != 0, (String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u65e5\u5fd7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        entity.setState(1);
        this.loggerTemplateEntityRepository.saveAndFlush((Object)entity);
    }

    @Override
    public void cache() {
        List loggerTemplateEntities = this.loggerTemplateEntityRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)loggerTemplateEntities)) {
            loggerTemplateEntities.forEach(l -> this.cache((LoggerTemplateEntity)((Object)l)));
        }
    }

    @Override
    public void cache(LoggerTemplateEntity loggerTemplateEntity) {
        if (loggerTemplateEntity == null) {
            return;
        }
        LoggerTemplateEntity target = (LoggerTemplateEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)loggerTemplateEntity, LoggerTemplateEntity.class, HashSet.class, ArrayList.class, new String[0]));
        localCache.put((Object)loggerTemplateEntity.getCode(), (Object)target);
    }
}

