/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.migrate.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.entity.MigrateExportEntity;
import com.bizunited.platform.core.repository.migrate.MigrateExportRepository;
import com.bizunited.platform.core.service.CodeRuleService;
import com.bizunited.platform.core.service.EnvironmentVariableService;
import com.bizunited.platform.core.service.RemoteServiceAddressService;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.service.migrate.MigrateExportService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="migrateExportService")
public class MigrateExportServiceImpl
implements MigrateExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportServiceImpl.class);
    @Autowired
    private MigrateExportRepository migrateExportRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private UserService userService;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private DataAuthService dataAuthService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CodeRuleService codeRuleService;
    @Autowired
    private EnvironmentVariableService environmentVariableService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private PlatformContext platformContext;
    @Autowired
    private RemoteServiceAddressService remoteServiceAddressService;

    @Override
    @Transactional
    public MigrateExportEntity save(MigrateExportEntity export) {
        Validate.notNull((Object)export.getDataType(), (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = SecurityUtils.getCurrentUser();
        export.setCreateTime(new Date());
        export.setCreateUser(user);
        export.setCreator(user.getAccount());
        return (MigrateExportEntity)((Object)this.migrateExportRepository.save((Object)export));
    }

    @Override
    public List<MigrateExportEntity> findDetailsByDataType(Integer dataType) {
        if (dataType == null) {
            return Lists.newArrayList();
        }
        String projectName = this.platformContext.getAppName();
        List<MigrateExportEntity> exports = StringUtils.isNotBlank((CharSequence)projectName) ? this.migrateExportRepository.findByDataTypeAndProjectName(dataType, projectName) : this.migrateExportRepository.findByDataTypeAndBlankProjectName(dataType);
        if (CollectionUtils.isEmpty(exports)) {
            return Lists.newArrayList();
        }
        HashMap<String, UserVo> userCache = new HashMap<String, UserVo>();
        for (MigrateExportEntity export : exports) {
            String creator = export.getCreator();
            UserVo user = (UserVo)userCache.get(creator);
            if (user == null) {
                user = this.userService.findByAccount(creator);
                userCache.put(creator, user);
            }
            export.setCreateUser(user);
        }
        return exports;
    }

    private MigrateExportEntity save(Integer dataType, String datas) {
        Validate.notNull((Object)dataType, (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MigrateExportEntity export = new MigrateExportEntity();
        export.setDataType(dataType);
        export.setDatas(datas);
        export.setProjectName(this.platformContext.getAppName());
        MigrateExportService migrateExportService = (MigrateExportService)this.applicationContext.getBean(MigrateExportService.class);
        return migrateExportService.save(export);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportDataView(String[] ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportRemoteService(String[] ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleDataViewGroup(DataViewEntity exportDataView, DataViewGroupEntity group) {
        DataViewGroupEntity exportGroup;
        if (group == null) {
            return;
        }
        DataViewGroupEntity tmpGroup = exportGroup = (DataViewGroupEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)group, DataViewGroupEntity.class, null, null, new String[0]));
        while (group.getParent() != null) {
            group = group.getParent();
            DataViewGroupEntity tmp = (DataViewGroupEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)group, DataViewGroupEntity.class, null, null, new String[0]));
            tmpGroup.setParent(tmp);
            tmpGroup = tmp;
        }
        exportDataView.setDataViewGroup(exportGroup);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportCodeRule(String[] codeRuleIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportEnv(String[] envIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

