/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.aspect;

import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.serviceable.aspect.AbstractNebulaServiceMethodExecution;
import com.bizunited.platform.core.service.serviceable.handle.ServiceMethodExecutionHandle;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AnnotationNebulaServiceMethodAspect
extends AbstractNebulaServiceMethodExecution {
    @Pointcut(value="execution(@com.bizunited.platform.core.annotations.NebulaServiceMethod public * *(..))")
    public void aspectHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="aspectHandle()")
    public Object around(ProceedingJoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method currentMethod = methodSignature.getMethod();
        Object[] args = point.getArgs();
        Object result = null;
        if (this.isExecutionInfoEmpty() || !this.hasExecutionInfo(currentMethod)) {
            try {
                this.pushExecutionInfo(currentMethod);
                NebulaServiceMethod nebulaServiceMethod = currentMethod.getAnnotation(NebulaServiceMethod.class);
                String servicableMethodName = nebulaServiceMethod.name();
                ServicableMethodInfo servicableMethodInfo = super.findByServicableMethodName(servicableMethodName);
                Validate.notNull((Object)servicableMethodInfo, (String)"\u672a\u53d1\u73b0\u540d\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6e90\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{servicableMethodName});
                InvokeProxyBuilder invokeProxyBuilder = this.buildInvokeProxy(servicableMethodInfo);
                invokeProxyBuilder.addInvokeRequestTypeFilter(ServiceMethodExecutionHandle.class);
                InvokeProxy invokeProxy = invokeProxyBuilder.build();
                InvokeParams invokeParams = new InvokeParams();
                if (args != null && args.length != 0) {
                    invokeParams.setVariables(args);
                }
                invokeParams.putInvokeParam("_server_aop_point_", (Object)point);
                Object object = result = invokeProxy.invoke(invokeParams);
                return object;
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                Rethrower.rethrow(thr);
            }
            finally {
                this.popExecutionInfo();
            }
        } else if (!this.isExecutionInfoEmpty() && this.hasExecutionInfo(currentMethod)) {
            try {
                return point.proceed(point.getArgs());
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                Rethrower.rethrow(thr);
            }
        }
        return null;
    }

    private static class Rethrower {
        private Rethrower() {
        }

        public static void rethrow(Throwable exception) {
            class CheckedExceptionRethrower<T extends Throwable> {
                CheckedExceptionRethrower() {
                }

                private void rethrow(Throwable exception) throws T {
                    throw exception;
                }
            }
            new CheckedExceptionRethrower().rethrow(exception);
        }
    }
}

