/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.dauth;

import com.bizunited.platform.core.common.enums.SqlOperatorEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthHorizontalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthTypeEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalRelationEntity;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;

public class ServicableDataAuthInfo
implements Serializable {
    private static final long serialVersionUID = -1L;
    private UserVo currentUser;
    private Boolean hasAdminRole = false;
    private String servicableName;
    private String dataAuthCode;
    private String competenceId;
    private final Set<HorizontalAuth> horizontalAuths = Sets.newHashSet();
    private final Set<VerticalAuth> verticalAuths = Sets.newHashSet();

    public static ServicableDataAuthInfo newInstance(DataAuthEntity dataAuth, Boolean hasAdminRole, String competenceId) {
        ServicableDataAuthInfo info = new ServicableDataAuthInfo();
        info.currentUser = SecurityUtils.getCurrentUser();
        info.hasAdminRole = hasAdminRole;
        info.competenceId = competenceId;
        if (dataAuth == null) {
            return info;
        }
        info.servicableName = dataAuth.getSerivceableName();
        info.dataAuthCode = dataAuth.getCode();
        for (DataAuthHorizontalEntity horizontal : dataAuth.getHorizontalAuths()) {
            HorizontalAuth hauth = new HorizontalAuth();
            hauth.setFieldName(horizontal.getFieldName());
            hauth.setAuthType(horizontal.getAuthType());
            hauth.setSortIndex(horizontal.getSortIndex());
            hauth.setParamKey(horizontal.getParamKey());
            hauth.setLevel(horizontal.getLevel());
            hauth.setOprt(SqlOperatorEnum.valueOf(horizontal.getOprtType()));
            info.horizontalAuths.add(hauth);
        }
        for (DataAuthVerticalEntity vertical : dataAuth.getVerticalAuths()) {
            VerticalAuth vauth = new VerticalAuth();
            vauth.setAuthType(vertical.getAuthType());
            vauth.setOprt(SqlOperatorEnum.valueOf(vertical.getOprtType()));
            vauth.setSortIndex(vertical.getSortIndex());
            Set<String> value = vertical.getAuthRelations().stream().map(DataAuthVerticalRelationEntity::getAuthRelationIds).collect(Collectors.toSet());
            vauth.setValue(value);
            vauth.setDisplayNames(vertical.getDisplayFields());
            info.verticalAuths.add(vauth);
        }
        return info;
    }

    public UserVo getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getHasAdminRole() {
        return this.hasAdminRole;
    }

    public void setHasAdminRole(Boolean hasAdminRole) {
        this.hasAdminRole = hasAdminRole;
    }

    public Set<HorizontalAuth> getHorizontalAuths() {
        return this.horizontalAuths;
    }

    public Set<VerticalAuth> getVerticalAuths() {
        return this.verticalAuths;
    }

    public String getServicableName() {
        return this.servicableName;
    }

    public String getDataAuthCode() {
        return this.dataAuthCode;
    }

    public String getCompetenceId() {
        return this.competenceId;
    }

    public static class VerticalAuth
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private DataAuthTypeEntity authType;
        private SqlOperatorEnum oprt;
        private Integer sortIndex;
        private Set<String> value;
        private String displayNames;

        public DataAuthTypeEntity getAuthType() {
            return this.authType;
        }

        void setAuthType(DataAuthTypeEntity authType) {
            this.authType = authType;
        }

        public SqlOperatorEnum getOprt() {
            return this.oprt;
        }

        void setOprt(SqlOperatorEnum oprt) {
            this.oprt = oprt;
        }

        public Set<String> getValue() {
            return this.value;
        }

        void setValue(Set<String> value) {
            this.value = value;
        }

        public Integer getSortIndex() {
            return this.sortIndex;
        }

        void setSortIndex(Integer sortIndex) {
            this.sortIndex = sortIndex;
        }

        public String getDisplayNames() {
            return this.displayNames;
        }

        void setDisplayNames(String displayNames) {
            this.displayNames = displayNames;
        }
    }

    public static class HorizontalAuth
    implements Serializable {
        private static final long serialVersionUID = -1L;
        public String fieldName;
        public DataAuthTypeEntity authType;
        public SqlOperatorEnum oprt;
        public Integer sortIndex;
        public String paramKey;
        public Integer level;

        public String getFieldName() {
            return this.fieldName;
        }

        void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public DataAuthTypeEntity getAuthType() {
            return this.authType;
        }

        void setAuthType(DataAuthTypeEntity authType) {
            this.authType = authType;
        }

        public SqlOperatorEnum getOprt() {
            return this.oprt;
        }

        void setOprt(SqlOperatorEnum oprt) {
            this.oprt = oprt;
        }

        public Integer getSortIndex() {
            return this.sortIndex;
        }

        void setSortIndex(Integer sortIndex) {
            this.sortIndex = sortIndex;
        }

        public String getParamKey() {
            return this.paramKey;
        }

        void setParamKey(String paramKey) {
            this.paramKey = paramKey;
        }

        public Integer getLevel() {
            return this.level;
        }

        void setLevel(Integer level) {
            this.level = level;
        }
    }
}

