/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.handle;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ServiceMethodExecutionHandle")
public class ServiceMethodExecutionHandle
implements InvokeRequestHandle {
    @Autowired
    private ServicableMethodService servicableMethodService;
    public static final String SERVER_NAME_PARAM = "_service_name_";
    public static final String SERVER_AOP_POINT = "_server_aop_point_";

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        InvokeParams invokeParams = context.getParams();
        Object[] args = invokeParams.getVariables();
        Object result = null;
        if (invokeParams.getInvokeParam(SERVER_AOP_POINT) != null) {
            ProceedingJoinPoint point = (ProceedingJoinPoint)invokeParams.getInvokeParam(SERVER_AOP_POINT);
            try {
                result = point.proceed(args);
            }
            catch (Throwable e) {
                Rethrower.rethrow(e);
            }
        } else {
            String serviceName = invokeParams.getInvokeParam(SERVER_NAME_PARAM).toString();
            result = this.servicableMethodService.invoke(serviceName, args);
        }
        context.setResult(result);
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }

    private static class Rethrower {
        private Rethrower() {
        }

        public static void rethrow(Throwable exception) {
            class CheckedExceptionRethrower<T extends Throwable> {
                CheckedExceptionRethrower() {
                }

                private void rethrow(Throwable exception) throws T {
                    throw exception;
                }
            }
            new CheckedExceptionRethrower().rethrow(exception);
        }
    }
}

