/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.enums.SqlOperatorEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalRelationEntity;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateEntityService;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.service.dauth.internal.DataAuthPreAuthDecisionService;
import com.bizunited.platform.core.service.serviceable.ServicableDataAuthService;
import com.bizunited.platform.core.service.serviceable.dauth.ServicableDataAuthInfo;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class ServicableDataAuthServiceImpl
implements ServicableDataAuthService {
    protected static final String DATA_AUTH_KEY = "servicableDataAuth";
    private static Map<String, ServicableMethodInfo> caches = new ConcurrentHashMap<String, ServicableMethodInfo>();
    @Autowired
    private DataAuthService dataAuthService;
    @Autowired
    private DataAuthPrefabricateEntityService dataAuthPrefabricateEntityService;
    @Autowired
    private DataAuthPreAuthDecisionService dataAuthPreAuthDecisionService;
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;

    @Override
    public void create(ServicableMethodInfo info) {
        Validate.notNull((Object)info, (String)"\u5c06\u8981\u7f13\u5b58\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)info.getName(), (String)"\u5c06\u8981\u7f13\u5b58\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u5fc5\u987b\u6709\u4e3a\u4e00\u4e2aname\u4fe1\u606f", (Object[])new Object[0]);
        caches.put(info.getName(), info);
    }

    @Override
    public Page<JSONObject> findByConditions(Pageable pageable, String name, String description) {
        Collection<ServicableMethodInfo> servicableDataAuthInfos = caches.values();
        List dataAuthMethods = servicableDataAuthInfos.stream().filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return StringUtils.contains((CharSequence)item.getName(), (CharSequence)name);
            }
            return true;
        }).filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)description)) {
                return StringUtils.contains((CharSequence)item.getDescription(), (CharSequence)description);
            }
            return true;
        }).collect(Collectors.toList());
        long totalNum = dataAuthMethods.size();
        List<ServicableMethodInfo> resultMethods = dataAuthMethods.stream().skip(pageable.getPageSize() * pageable.getPageNumber()).limit(pageable.getPageSize()).sorted(Comparator.comparing(ServicableMethodInfo::getName)).collect(Collectors.toList());
        List<JSONObject> results = this.buildResults(resultMethods);
        return new PageImpl(results, pageable, totalNum);
    }

    @Override
    public ServicableDataAuthInfo fetchServicableDataAuthInfo() {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        return (ServicableDataAuthInfo)attributes.getAttribute(DATA_AUTH_KEY, Integer.MAX_VALUE);
    }

    private List<JSONObject> buildResults(List<ServicableMethodInfo> servicableMethodInfos) {
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        servicableMethodInfos.forEach(item -> {
            JSONObject jsonitem = this.findDetailJson((ServicableMethodInfo)item);
            results.add(jsonitem);
        });
        return results;
    }

    private JSONObject findDetailJson(ServicableMethodInfo servicableMethodInfo) {
        JSONObject jsonitem = new JSONObject();
        jsonitem.put("id", (Object)servicableMethodInfo.getName());
        jsonitem.put("name", (Object)servicableMethodInfo.getName());
        jsonitem.put("description", (Object)servicableMethodInfo.getDescription());
        jsonitem.put("simpleMethodName", (Object)servicableMethodInfo.getSimpleMethodName());
        jsonitem.put("interfaceName", (Object)servicableMethodInfo.getInterfaceName());
        jsonitem.put("returnCollection", (Object)servicableMethodInfo.isReturnCollection());
        jsonitem.put("returnClass", (Object)servicableMethodInfo.getReturnClass().getName());
        JSONArray jsonArray = new JSONArray();
        Set<DataAuthEntity> dataAuths = this.dataAuthService.findByServiceableName(servicableMethodInfo.getName());
        for (DataAuthEntity e : dataAuths) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)e.getId());
            json.put("code", (Object)e.getCode());
            json.put("name", (Object)e.getName());
            json.put("projectName", (Object)e.getProjectName());
            json.put("type", (Object)"auth");
            json.put("title", (Object)e.getName());
            jsonArray.add((Object)json);
        }
        jsonitem.put("children", (Object)jsonArray);
        return jsonitem;
    }

    @Override
    public Map<ServicableDataAuthInfo.HorizontalAuth, Object> analysisPrefabricateHorizontal(ServicableDataAuthInfo info) {
        if (info == null || info.getHasAdminRole().booleanValue()) {
            return Maps.newHashMap();
        }
        HashMap results = Maps.newHashMap();
        Set hauths = info.getHorizontalAuths();
        hauths = hauths.stream().sorted(Comparator.comparingInt(ServicableDataAuthInfo.HorizontalAuth::getSortIndex)).collect(Collectors.toCollection(LinkedHashSet::new));
        for (ServicableDataAuthInfo.HorizontalAuth e : hauths) {
            Object value = this.dataAuthPrefabricateEntityService.getCurrentPresetValue(e.getParamKey(), e.getLevel());
            results.put(e, value);
        }
        return results;
    }

    @Override
    public Set<String> analysisPrefabricateVertical(ServicableDataAuthInfo info) {
        if (info == null || info.getHasAdminRole().booleanValue()) {
            return Sets.newHashSet();
        }
        UserVo user = info.getCurrentUser();
        Set vauths = info.getVerticalAuths();
        vauths = vauths.stream().sorted(Comparator.comparingInt(ServicableDataAuthInfo.VerticalAuth::getSortIndex)).collect(Collectors.toCollection(LinkedHashSet::new));
        HashSet results = Sets.newHashSet();
        for (ServicableDataAuthInfo.VerticalAuth e : vauths) {
            Set<String> currentPresetValues = this.dataAuthPrefabricateEntityService.getCurrentPresetValueInnerType(user, e.getAuthType());
            Sets.SetView existValues = Sets.intersection(currentPresetValues, e.getValue());
            String[] splits = StringUtils.split((String)e.getDisplayNames(), (String)",");
            if ((e.getOprt() != SqlOperatorEnum.IN || CollectionUtils.isEmpty((Collection)existValues)) && (e.getOprt() != SqlOperatorEnum.NIN || !CollectionUtils.isEmpty((Collection)existValues))) continue;
            results.addAll(Sets.union((Set)results, Arrays.stream(splits).collect(Collectors.toSet())));
        }
        return results;
    }

    @Override
    public JSONArray findFieldsByServicableNameAndAuthCode(String servicableName, String dataAuthCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{servicableName, dataAuthCode})) {
            return new JSONArray();
        }
        boolean hasAdmin = this.dataAuthPreAuthDecisionService.hasAdminRole();
        DataAuthEntity dataAuth = null;
        ServicableMethodInfo servicableMethodInfo = caches.get(servicableName);
        Validate.notNull((Object)servicableMethodInfo, (String)"\u65e0\u6548\u7684\u670d\u52a1\u6e90\uff1a%s", (Object[])new Object[]{servicableName});
        PersistentClass persistentClass = this.nebulaStaticPersistentService.findByPersistentClass(servicableMethodInfo.getReturnClass().getName());
        Validate.notNull((Object)persistentClass, (String)"\u672a\u80fd\u67e5\u8be2\u5230\u6307\u5b9a\u6a21\u578b\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        if (hasAdmin) {
            return this.buildFieldsInfo(new JSONArray(), persistentClass, null);
        }
        DataAuthPreRuleEntity preRule = this.dataAuthPreAuthDecisionService.decision(dataAuthCode);
        if (preRule != null) {
            dataAuth = this.dataAuthService.findDetailsByServicableNameAndAuthCodeAndPreRule(servicableName, dataAuthCode, preRule.getCode());
        }
        HashSet results = Sets.newHashSet();
        if (dataAuth != null) {
            Set vauths = dataAuth.getVerticalAuths();
            vauths = vauths.stream().sorted(Comparator.comparingInt(DataAuthVerticalEntity::getSortIndex)).collect(Collectors.toCollection(LinkedHashSet::new));
            for (DataAuthVerticalEntity e : vauths) {
                Set<String> currentPresetValues = this.dataAuthPrefabricateEntityService.getCurrentPresetValueInnerType(SecurityUtils.getCurrentUser(), e.getAuthType());
                Set<DataAuthVerticalRelationEntity> authRelations = e.getAuthRelations();
                Sets.SetView existValues = Sets.intersection(currentPresetValues, authRelations.stream().map(DataAuthVerticalRelationEntity::getAuthRelationIds).collect(Collectors.toSet()));
                String[] splits = StringUtils.split((String)e.getDisplayFields(), (String)",");
                if ((SqlOperatorEnum.valueOf(e.getOprtType()) != SqlOperatorEnum.IN || CollectionUtils.isEmpty((Collection)existValues)) && (SqlOperatorEnum.valueOf(e.getOprtType()) != SqlOperatorEnum.NIN || !CollectionUtils.isEmpty((Collection)existValues))) continue;
                results.addAll(Sets.union((Set)results, Arrays.stream(splits).collect(Collectors.toSet())));
            }
        }
        return this.buildFieldsInfo(new JSONArray(), persistentClass, results);
    }

    private JSONArray buildFieldsInfo(JSONArray jsonArray, PersistentClass persistentClass, Set<String> fieldNames) {
        List properties = persistentClass.getProperties();
        if (CollectionUtils.isEmpty(fieldNames)) {
            for (PersistentProperty p : properties) {
                JSONObject json = new JSONObject();
                json.put("fieldName", (Object)p.getPropertyName());
                json.put("chineseDesc", (Object)p.getPropertyDesc());
                jsonArray.add((Object)json);
            }
            return jsonArray;
        }
        for (String fieldName : fieldNames) {
            JSONObject json = new JSONObject();
            json.put("fieldName", (Object)fieldName);
            String chineseDesc = properties.stream().filter(e -> StringUtils.equals((CharSequence)e.getPropertyName(), (CharSequence)fieldName)).map(PersistentProperty::getPropertyDesc).findFirst().orElse("");
            Validate.notBlank((CharSequence)chineseDesc, (String)"\u672a\u77e5\u7684\u5b57\u6bb5\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            json.put("chineseDesc", (Object)chineseDesc);
            jsonArray.add((Object)json);
        }
        return jsonArray;
    }
}

