/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractObjectValueMappingTemplate
implements ValueMappingTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractObjectValueMappingTemplate.class);
    @Autowired
    private ApplicationContext applicationContext;

    protected Object mappingObject(JSONObject jsonObject, Class<?> parameterClass) {
        String className = parameterClass.getName();
        Object result = null;
        try {
            result = JSONObject.parseObject((String)jsonObject.toJSONString(), parameterClass);
        }
        catch (RuntimeException e) {
            LOGGER.warn(e.getMessage());
        }
        if (result != null) {
            return result;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            parameterClass = classLoader.loadClass(className);
            result = JSONObject.parseObject((String)jsonObject.toJSONString(), parameterClass);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            LOGGER.warn(e.getMessage());
        }
        if (result != null) {
            return result;
        }
        classLoader = this.applicationContext.getClassLoader();
        try {
            parameterClass = classLoader.loadClass(className);
            result = JSONObject.parseObject((String)jsonObject.toJSONString(), parameterClass);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

