/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PageableValueMappingTemplate
implements ValueMappingTemplate {
    @Override
    public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
        Class<?> parameterType = parameter.getType();
        boolean isArray = parameterType.isArray();
        if (isArray) {
            return false;
        }
        return Pageable.class.isAssignableFrom(parameterType);
    }

    @Override
    public Object mapping(Class<?> targetComponentType, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams) {
        Object value = invokeParams.getInvokeParam(parameterName);
        if (value == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            Object sorts;
            Integer size;
            Map pageMapping = (Map)value;
            Integer page = (Integer)pageMapping.get("page");
            if (page == null) {
                page = 0;
            }
            if ((size = (Integer)pageMapping.get("size")) == null) {
                size = 50;
            }
            if ((sorts = pageMapping.get("sort")) == null || sorts instanceof Map) {
                // empty if block
            }
            return PageRequest.of((int)page, (int)size);
        }
        if (value instanceof JSONObject) {
            JSONObject valueJson = (JSONObject)value;
            return JSONObject.toJavaObject((JSON)valueJson, PageRequest.class);
        }
        throw new IllegalArgumentException("\u5206\u9875\u60c5\u51b5\u63cf\u8ff0Pageable\uff0cjson\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
    }
}

