/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template.base;

import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.template.base.AbstractPrimitiveValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component
public class ByteValueMappingTemplate
extends AbstractPrimitiveValueMappingTemplate {
    @Override
    public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
        Class<?> parameterType = parameter.getType();
        boolean isArray = parameterType.isArray();
        if (!(isArray || parameterType != Byte.class && parameterType != Byte.TYPE)) {
            Validate.isTrue((boolean)super.checkServiceMethodParamAnnotation(parameter), (String)"\u8bbe\u5b9a\u670d\u52a1\u6e90\u65f6Byte/byte\u7c7b\u578b\u7684\u53c2\u6570[%s]\uff0c\u5fc5\u987b\u643a\u5e26ServiceMethodParam\u6ce8\u89e3", (Object[])new Object[]{targetMethod.toString()});
            return true;
        }
        if (isArray && (parameterType.getComponentType() == Byte.class || parameterType.getComponentType() == Byte.TYPE)) {
            Validate.isTrue((boolean)super.checkServiceMethodParamAnnotation(parameter), (String)"\u8bbe\u5b9a\u670d\u52a1\u6e90\u65f6Byte/byte\u7c7b\u578b\u7684\u53c2\u6570[%s]\uff0c\u5fc5\u987b\u643a\u5e26ServiceMethodParam\u6ce8\u89e3", (Object[])new Object[]{targetMethod.toString()});
            return true;
        }
        return false;
    }

    @Override
    protected Object mappingNoArrayToNoArray(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams, Object value) {
        Class<?> parameterType = parameter.getType();
        boolean isTypePrimitive = parameterType.isPrimitive();
        boolean isValuePrimitive = value.getClass().isPrimitive();
        if (!isTypePrimitive && isValuePrimitive) {
            return (byte)((Byte)value);
        }
        if (isTypePrimitive && !isValuePrimitive) {
            return (byte)((Byte)value);
        }
        return value;
    }

    @Override
    protected Object mappingArrayToArray(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams, Object values) {
        Class<?> parameterType = parameter.getType();
        boolean isTypePrimitive = parameterType.isPrimitive();
        boolean isValuePrimitive = values.getClass().isPrimitive();
        if (!isTypePrimitive && isValuePrimitive) {
            return ArrayUtils.toObject((byte[])((byte[])values));
        }
        if (isTypePrimitive && !isValuePrimitive) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])values));
        }
        return values;
    }
}

