package com.bizunited.platform.rbac.process;

import com.bizunited.platform.common.enums.BooleanEnum;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.rbac.server.enums.RoleTypeEnum;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.vo.RoleImportVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 角色导入实现类
 * @Author: chenrong
 * @Date: 2020/10/28 9:27
 */
@Component
public class RoleImportProcess implements FormDetailsImportBoxProcess<RoleVo, RoleImportVo> {

  @Autowired
  private RoleService roleService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 导入实现方法
   * @param roleImportVo
   * @param params
   * @param templateCode
   * @param templateVersion
   * @return
   */
  @Override
  public RoleVo process(RoleImportVo roleImportVo, Map<String, Object> params, String templateCode, String templateVersion){
    if(roleImportVo == null){
      return null;
    }
    this.validateTrue(StringUtils.isNotBlank(roleImportVo.getRoleName()), "角色名称不能为空");
    this.validateTrue(StringUtils.isNotBlank(roleImportVo.getIsDeny()), "是否系统角色不能为空");
    this.validateTrue(StringUtils.isNotBlank(roleImportVo.getRoleType()), "角色类型不能为空");
    this.validateTrue(StringUtils.isNotBlank(roleImportVo.getTstatus()), "角色状态不能为空");
    String parentCode = roleImportVo.getParentCode();
    RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(roleImportVo, RoleVo.class, HashSet.class, ArrayList.class);
    if(StringUtils.isNotBlank(parentCode)){
      RoleVo parent = this.roleService.findByCode(parentCode);
      roleVo.setParent(parent);
    }
    // 是否系统角色
    BooleanEnum booleanEnum = BooleanEnum.valueOfDesc(roleImportVo.getIsDeny());
    if(booleanEnum != null) {
      roleVo.setIsDeny(booleanEnum.getStatus());
    }
    // 角色类型
    RoleTypeEnum roleTypeEnum = RoleTypeEnum.valueOfDesc(roleImportVo.getRoleType());
    if(roleTypeEnum != null) {
      roleVo.setRoleType(roleTypeEnum.getType());
    }
    // 角色状态，启用/禁用
    NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfDesc(roleImportVo.getTstatus());
    if(normalStatusEnum != null) {
      roleVo.setTstatus(normalStatusEnum.getStatus());
    }
    return roleVo;
  }

  /**
   * 导入字段校验
   * @param expression
   * @param message
   */
  private void validateTrue(boolean expression, String message) {
    if(!expression) {
      throw new ExcelMigrateException(message);
    }
  }

  /**
   * 导入数据持久化
   * @param roleVo
   * @param params
   */
  @Override
  public void execute(RoleVo roleVo, Map<String, Object> params){
    this.roleService.create(roleVo);
  }
}
