/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.process;

import com.bizunited.platform.common.enums.BooleanEnum;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.rbac.server.enums.RoleTypeEnum;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.vo.RoleImportVo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleImportProcess
implements FormDetailsImportBoxProcess<RoleVo, RoleImportVo> {
    @Autowired
    private RoleService roleService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public RoleVo process(RoleImportVo roleImportVo, Map<String, Object> params, String templateCode, String templateVersion) {
        NormalStatusEnum normalStatusEnum;
        RoleTypeEnum roleTypeEnum;
        BooleanEnum booleanEnum;
        if (roleImportVo == null) {
            return null;
        }
        this.validateTrue(StringUtils.isNotBlank((CharSequence)roleImportVo.getRoleName()), "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateTrue(StringUtils.isNotBlank((CharSequence)roleImportVo.getIsDeny()), "\u662f\u5426\u7cfb\u7edf\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateTrue(StringUtils.isNotBlank((CharSequence)roleImportVo.getRoleType()), "\u89d2\u8272\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateTrue(StringUtils.isNotBlank((CharSequence)roleImportVo.getTstatus()), "\u89d2\u8272\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        String parentCode = roleImportVo.getParentCode();
        RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleImportVo, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            RoleVo parent = this.roleService.findByCode(parentCode);
            roleVo.setParent(parent);
        }
        if ((booleanEnum = BooleanEnum.valueOfDesc((String)roleImportVo.getIsDeny())) != null) {
            roleVo.setIsDeny(booleanEnum.getStatus());
        }
        if ((roleTypeEnum = RoleTypeEnum.valueOfDesc((String)roleImportVo.getRoleType())) != null) {
            roleVo.setRoleType(roleTypeEnum.getType());
        }
        if ((normalStatusEnum = NormalStatusEnum.valueOfDesc((String)roleImportVo.getTstatus())) != null) {
            roleVo.setTstatus(normalStatusEnum.getStatus());
        }
        return roleVo;
    }

    private void validateTrue(boolean expression, String message) {
        if (!expression) {
            throw new ExcelMigrateException(message);
        }
    }

    public void execute(RoleVo roleVo, Map<String, Object> params) {
        this.roleService.create(roleVo);
    }
}

