package com.bizunited.platform.rbac.transfer;

import com.bizunited.platform.common.enums.BooleanEnum;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.rbac.server.enums.RoleTypeEnum;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.vo.RoleExportVo;
import org.springframework.stereotype.Component;

/**
 * 角色类转换实现类
 * @Author: chenrong
 * @Date: 2020/11/2 18:17
 */
@Component
public class RoleExportTransfer implements Transfer<RoleVo, RoleExportVo> {

  @Override
  public RoleExportVo transfer(RoleVo role) {
    RoleExportVo roleExportVo = new RoleExportVo();
    RoleVo parent = role.getParent();
    if(parent != null){
      roleExportVo.setParentCode(parent.getRoleCode());
    }
    roleExportVo.setRoleCode(role.getRoleCode());
    roleExportVo.setRoleName(role.getRoleName());
    roleExportVo.setComment(role.getComment());
    // 角色状态
    NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfStatus(role.getTstatus());
    if(normalStatusEnum != null){
      roleExportVo.setTstatus(normalStatusEnum.getDesc());
    }
    // 角色类型
    RoleTypeEnum roleTypeEnum = RoleTypeEnum.valueOfType(role.getRoleType());
    if(roleTypeEnum != null) {
      roleExportVo.setRoleType(roleTypeEnum.getDesc());
    }
    // 是否系统角色
    BooleanEnum booleanEnum = BooleanEnum.valueOfStatus(role.getIsDeny());
    if(booleanEnum != null) {
      roleExportVo.setIsDeny(booleanEnum.getDesc());
    }
    roleExportVo.setCreateDate(role.getCreateDate());
    return roleExportVo;
  }
}
