package com.bizunited.platform.rbac.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;
import java.io.Serializable;
import java.util.Date;

/**
 * 角色导出对象模型
 * @Author: chenrong
 * @Date: 2020/10/26 11:29
 */
@NebulaExcelExport(excelName = "角色导出数据")
public class RoleExportVo implements Serializable {

  private static final long serialVersionUID = 2718226174829006028L;

  /** 角色编码 **/
  @NebulaExcelColumn(title = "角色编码", order = 0)
  private String roleCode;

  /** 角色名称 **/
  @NebulaExcelColumn(title = "角色名称", order = 1)
  private String roleName;

  /** 角色类型 **/
  @NebulaExcelColumn(title = "角色类型", order = 2)
  private String roleType;

  /** 角色状态 **/
  @NebulaExcelColumn(title = "状态", order = 3)
  private String tstatus;

  /** 是否系统角色 **/
  @NebulaExcelColumn(title = "是否系统角色", order = 4)
  private String isDeny;

  /** 父级角色编码 **/
  @NebulaExcelColumn(title = "父级角色", order = 5)
  private String parentCode;

  /** 角色来源 **/
  @NebulaExcelColumn(title = "角色来源", order = 6)
  private String source;

  /** 角色备注 **/
  @NebulaExcelColumn(title = "备注", order = 7)
  private String comment;

  /** 创建时间 **/
  @NebulaExcelColumn(title = "创建日期", order = 8, format = "yyyy-MM-dd")
  private Date createDate;

  public String getRoleCode() {
    return roleCode;
  }

  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }

  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  public String getRoleType() {
    return roleType;
  }

  public void setRoleType(String roleType) {
    this.roleType = roleType;
  }

  public String getTstatus() {
    return tstatus;
  }

  public void setTstatus(String tstatus) {
    this.tstatus = tstatus;
  }

  public String getIsDeny() {
    return isDeny;
  }

  public void setIsDeny(String isDeny) {
    this.isDeny = isDeny;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public Date getCreateDate() {
    return createDate;
  }

  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
}
