package com.bizunited.platform.rbac.process;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.transfer.RoleExportTransfer;
import com.bizunited.platform.rbac.vo.RoleExportVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 角色导出实现类
 * @Author: chenrong
 * @Date: 2020/10/26 15:38
 */
@Component
public class RoleExportProcess implements FormDetailsExportBoxProcess<RoleExportVo> {

  @Autowired
  private RoleService roleService;
  @Autowired
  private RoleExportTransfer roleExportTransfer;

  /**
   * 导出实现方法
   * @param pageable
   * @param dataViewCode
   * @param exportFiled
   * @param exportParam
   * @param params
   * @return
   */
  @Override
  public Page<RoleExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params){
    Page<RoleVo> page = this.roleService.findAll(pageable);
    if(page == null || CollectionUtils.isEmpty(page.getContent())){
      return Page.empty(pageable);
    }
    Collection<RoleExportVo> collection = CollectionTransferUtils.transfer(page.getContent(), roleExportTransfer, HashSet.class, ArrayList.class);
    List<RoleExportVo> roleExportVos = Lists.newArrayList(collection);
    return new PageImpl<>(roleExportVos, pageable, page.getTotalElements());
  }
}
